package software.amazon.awscdk.interfaces.rds;

/**
 * A reference to a DBCluster resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.rds.*;
 * DBClusterReference dBClusterReference = DBClusterReference.builder()
 *         .dbClusterArn("dbClusterArn")
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.822Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_rds.DBClusterReference")
@software.amazon.jsii.Jsii.Proxy(DBClusterReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DBClusterReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the DBCluster resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbClusterArn();

    /**
     * The DBClusterIdentifier of the DBCluster resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbClusterIdentifier();

    /**
     * @return a {@link Builder} of {@link DBClusterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DBClusterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DBClusterReference> {
        java.lang.String dbClusterArn;
        java.lang.String dbClusterIdentifier;

        /**
         * Sets the value of {@link DBClusterReference#getDbClusterArn}
         * @param dbClusterArn The ARN of the DBCluster resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterArn(java.lang.String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        /**
         * Sets the value of {@link DBClusterReference#getDbClusterIdentifier}
         * @param dbClusterIdentifier The DBClusterIdentifier of the DBCluster resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(java.lang.String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DBClusterReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DBClusterReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DBClusterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DBClusterReference {
        private final java.lang.String dbClusterArn;
        private final java.lang.String dbClusterIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbClusterArn = software.amazon.jsii.Kernel.get(this, "dbClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbClusterArn = java.util.Objects.requireNonNull(builder.dbClusterArn, "dbClusterArn is required");
            this.dbClusterIdentifier = java.util.Objects.requireNonNull(builder.dbClusterIdentifier, "dbClusterIdentifier is required");
        }

        @Override
        public final java.lang.String getDbClusterArn() {
            return this.dbClusterArn;
        }

        @Override
        public final java.lang.String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbClusterArn", om.valueToTree(this.getDbClusterArn()));
            data.set("dbClusterIdentifier", om.valueToTree(this.getDbClusterIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_rds.DBClusterReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DBClusterReference.Jsii$Proxy that = (DBClusterReference.Jsii$Proxy) o;

            if (!dbClusterArn.equals(that.dbClusterArn)) return false;
            return this.dbClusterIdentifier.equals(that.dbClusterIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.dbClusterArn.hashCode();
            result = 31 * result + (this.dbClusterIdentifier.hashCode());
            return result;
        }
    }
}
