package software.amazon.awscdk.interfaces.redshift;

/**
 * A reference to a ClusterSecurityGroupIngress resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.redshift.*;
 * ClusterSecurityGroupIngressReference clusterSecurityGroupIngressReference = ClusterSecurityGroupIngressReference.builder()
 *         .clusterSecurityGroupIngressId("clusterSecurityGroupIngressId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.832Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_redshift.ClusterSecurityGroupIngressReference")
@software.amazon.jsii.Jsii.Proxy(ClusterSecurityGroupIngressReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClusterSecurityGroupIngressReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the ClusterSecurityGroupIngress resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterSecurityGroupIngressId();

    /**
     * @return a {@link Builder} of {@link ClusterSecurityGroupIngressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterSecurityGroupIngressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterSecurityGroupIngressReference> {
        java.lang.String clusterSecurityGroupIngressId;

        /**
         * Sets the value of {@link ClusterSecurityGroupIngressReference#getClusterSecurityGroupIngressId}
         * @param clusterSecurityGroupIngressId The Id of the ClusterSecurityGroupIngress resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSecurityGroupIngressId(java.lang.String clusterSecurityGroupIngressId) {
            this.clusterSecurityGroupIngressId = clusterSecurityGroupIngressId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterSecurityGroupIngressReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClusterSecurityGroupIngressReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterSecurityGroupIngressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterSecurityGroupIngressReference {
        private final java.lang.String clusterSecurityGroupIngressId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterSecurityGroupIngressId = software.amazon.jsii.Kernel.get(this, "clusterSecurityGroupIngressId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterSecurityGroupIngressId = java.util.Objects.requireNonNull(builder.clusterSecurityGroupIngressId, "clusterSecurityGroupIngressId is required");
        }

        @Override
        public final java.lang.String getClusterSecurityGroupIngressId() {
            return this.clusterSecurityGroupIngressId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterSecurityGroupIngressId", om.valueToTree(this.getClusterSecurityGroupIngressId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_redshift.ClusterSecurityGroupIngressReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterSecurityGroupIngressReference.Jsii$Proxy that = (ClusterSecurityGroupIngressReference.Jsii$Proxy) o;

            return this.clusterSecurityGroupIngressId.equals(that.clusterSecurityGroupIngressId);
        }

        @Override
        public final int hashCode() {
            int result = this.clusterSecurityGroupIngressId.hashCode();
            return result;
        }
    }
}
