package software.amazon.awscdk.interfaces.refactorspaces;

/**
 * A reference to a Route resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.refactorspaces.*;
 * RouteReference routeReference = RouteReference.builder()
 *         .applicationIdentifier("applicationIdentifier")
 *         .environmentIdentifier("environmentIdentifier")
 *         .routeArn("routeArn")
 *         .routeIdentifier("routeIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.841Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_refactorspaces.RouteReference")
@software.amazon.jsii.Jsii.Proxy(RouteReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RouteReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApplicationIdentifier of the Route resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationIdentifier();

    /**
     * The EnvironmentIdentifier of the Route resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentIdentifier();

    /**
     * The ARN of the Route resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteArn();

    /**
     * The RouteIdentifier of the Route resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteIdentifier();

    /**
     * @return a {@link Builder} of {@link RouteReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RouteReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RouteReference> {
        java.lang.String applicationIdentifier;
        java.lang.String environmentIdentifier;
        java.lang.String routeArn;
        java.lang.String routeIdentifier;

        /**
         * Sets the value of {@link RouteReference#getApplicationIdentifier}
         * @param applicationIdentifier The ApplicationIdentifier of the Route resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationIdentifier(java.lang.String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link RouteReference#getEnvironmentIdentifier}
         * @param environmentIdentifier The EnvironmentIdentifier of the Route resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(java.lang.String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link RouteReference#getRouteArn}
         * @param routeArn The ARN of the Route resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeArn(java.lang.String routeArn) {
            this.routeArn = routeArn;
            return this;
        }

        /**
         * Sets the value of {@link RouteReference#getRouteIdentifier}
         * @param routeIdentifier The RouteIdentifier of the Route resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeIdentifier(java.lang.String routeIdentifier) {
            this.routeIdentifier = routeIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RouteReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RouteReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RouteReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteReference {
        private final java.lang.String applicationIdentifier;
        private final java.lang.String environmentIdentifier;
        private final java.lang.String routeArn;
        private final java.lang.String routeIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationIdentifier = software.amazon.jsii.Kernel.get(this, "applicationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentIdentifier = software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeArn = software.amazon.jsii.Kernel.get(this, "routeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeIdentifier = software.amazon.jsii.Kernel.get(this, "routeIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationIdentifier = java.util.Objects.requireNonNull(builder.applicationIdentifier, "applicationIdentifier is required");
            this.environmentIdentifier = java.util.Objects.requireNonNull(builder.environmentIdentifier, "environmentIdentifier is required");
            this.routeArn = java.util.Objects.requireNonNull(builder.routeArn, "routeArn is required");
            this.routeIdentifier = java.util.Objects.requireNonNull(builder.routeIdentifier, "routeIdentifier is required");
        }

        @Override
        public final java.lang.String getApplicationIdentifier() {
            return this.applicationIdentifier;
        }

        @Override
        public final java.lang.String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        @Override
        public final java.lang.String getRouteArn() {
            return this.routeArn;
        }

        @Override
        public final java.lang.String getRouteIdentifier() {
            return this.routeIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationIdentifier", om.valueToTree(this.getApplicationIdentifier()));
            data.set("environmentIdentifier", om.valueToTree(this.getEnvironmentIdentifier()));
            data.set("routeArn", om.valueToTree(this.getRouteArn()));
            data.set("routeIdentifier", om.valueToTree(this.getRouteIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_refactorspaces.RouteReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RouteReference.Jsii$Proxy that = (RouteReference.Jsii$Proxy) o;

            if (!applicationIdentifier.equals(that.applicationIdentifier)) return false;
            if (!environmentIdentifier.equals(that.environmentIdentifier)) return false;
            if (!routeArn.equals(that.routeArn)) return false;
            return this.routeIdentifier.equals(that.routeIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationIdentifier.hashCode();
            result = 31 * result + (this.environmentIdentifier.hashCode());
            result = 31 * result + (this.routeArn.hashCode());
            result = 31 * result + (this.routeIdentifier.hashCode());
            return result;
        }
    }
}
