package software.amazon.awscdk.interfaces.refactorspaces;

/**
 * A reference to a Service resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.refactorspaces.*;
 * ServiceReference serviceReference = ServiceReference.builder()
 *         .applicationIdentifier("applicationIdentifier")
 *         .environmentIdentifier("environmentIdentifier")
 *         .serviceArn("serviceArn")
 *         .serviceIdentifier("serviceIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.841Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_refactorspaces.ServiceReference")
@software.amazon.jsii.Jsii.Proxy(ServiceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApplicationIdentifier of the Service resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationIdentifier();

    /**
     * The EnvironmentIdentifier of the Service resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentIdentifier();

    /**
     * The ARN of the Service resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceArn();

    /**
     * The ServiceIdentifier of the Service resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceIdentifier();

    /**
     * @return a {@link Builder} of {@link ServiceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceReference> {
        java.lang.String applicationIdentifier;
        java.lang.String environmentIdentifier;
        java.lang.String serviceArn;
        java.lang.String serviceIdentifier;

        /**
         * Sets the value of {@link ServiceReference#getApplicationIdentifier}
         * @param applicationIdentifier The ApplicationIdentifier of the Service resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationIdentifier(java.lang.String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link ServiceReference#getEnvironmentIdentifier}
         * @param environmentIdentifier The EnvironmentIdentifier of the Service resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(java.lang.String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link ServiceReference#getServiceArn}
         * @param serviceArn The ARN of the Service resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceArn(java.lang.String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        /**
         * Sets the value of {@link ServiceReference#getServiceIdentifier}
         * @param serviceIdentifier The ServiceIdentifier of the Service resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceIdentifier(java.lang.String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceReference {
        private final java.lang.String applicationIdentifier;
        private final java.lang.String environmentIdentifier;
        private final java.lang.String serviceArn;
        private final java.lang.String serviceIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationIdentifier = software.amazon.jsii.Kernel.get(this, "applicationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentIdentifier = software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceArn = software.amazon.jsii.Kernel.get(this, "serviceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceIdentifier = software.amazon.jsii.Kernel.get(this, "serviceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationIdentifier = java.util.Objects.requireNonNull(builder.applicationIdentifier, "applicationIdentifier is required");
            this.environmentIdentifier = java.util.Objects.requireNonNull(builder.environmentIdentifier, "environmentIdentifier is required");
            this.serviceArn = java.util.Objects.requireNonNull(builder.serviceArn, "serviceArn is required");
            this.serviceIdentifier = java.util.Objects.requireNonNull(builder.serviceIdentifier, "serviceIdentifier is required");
        }

        @Override
        public final java.lang.String getApplicationIdentifier() {
            return this.applicationIdentifier;
        }

        @Override
        public final java.lang.String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        @Override
        public final java.lang.String getServiceArn() {
            return this.serviceArn;
        }

        @Override
        public final java.lang.String getServiceIdentifier() {
            return this.serviceIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationIdentifier", om.valueToTree(this.getApplicationIdentifier()));
            data.set("environmentIdentifier", om.valueToTree(this.getEnvironmentIdentifier()));
            data.set("serviceArn", om.valueToTree(this.getServiceArn()));
            data.set("serviceIdentifier", om.valueToTree(this.getServiceIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_refactorspaces.ServiceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceReference.Jsii$Proxy that = (ServiceReference.Jsii$Proxy) o;

            if (!applicationIdentifier.equals(that.applicationIdentifier)) return false;
            if (!environmentIdentifier.equals(that.environmentIdentifier)) return false;
            if (!serviceArn.equals(that.serviceArn)) return false;
            return this.serviceIdentifier.equals(that.serviceIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationIdentifier.hashCode();
            result = 31 * result + (this.environmentIdentifier.hashCode());
            result = 31 * result + (this.serviceArn.hashCode());
            result = 31 * result + (this.serviceIdentifier.hashCode());
            return result;
        }
    }
}
