package software.amazon.awscdk.interfaces.regional;

/**
 * A reference to a ByteMatchSet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.regional.*;
 * ByteMatchSetReference byteMatchSetReference = ByteMatchSetReference.builder()
 *         .byteMatchSetId("byteMatchSetId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.080Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_wafregional.ByteMatchSetReference")
@software.amazon.jsii.Jsii.Proxy(ByteMatchSetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ByteMatchSetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the ByteMatchSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getByteMatchSetId();

    /**
     * @return a {@link Builder} of {@link ByteMatchSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ByteMatchSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ByteMatchSetReference> {
        java.lang.String byteMatchSetId;

        /**
         * Sets the value of {@link ByteMatchSetReference#getByteMatchSetId}
         * @param byteMatchSetId The Id of the ByteMatchSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder byteMatchSetId(java.lang.String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ByteMatchSetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ByteMatchSetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ByteMatchSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ByteMatchSetReference {
        private final java.lang.String byteMatchSetId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.byteMatchSetId = software.amazon.jsii.Kernel.get(this, "byteMatchSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.byteMatchSetId = java.util.Objects.requireNonNull(builder.byteMatchSetId, "byteMatchSetId is required");
        }

        @Override
        public final java.lang.String getByteMatchSetId() {
            return this.byteMatchSetId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("byteMatchSetId", om.valueToTree(this.getByteMatchSetId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_wafregional.ByteMatchSetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ByteMatchSetReference.Jsii$Proxy that = (ByteMatchSetReference.Jsii$Proxy) o;

            return this.byteMatchSetId.equals(that.byteMatchSetId);
        }

        @Override
        public final int hashCode() {
            int result = this.byteMatchSetId.hashCode();
            return result;
        }
    }
}
