package software.amazon.awscdk.interfaces.regional;

/**
 * A reference to a GeoMatchSet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.regional.*;
 * GeoMatchSetReference geoMatchSetReference = GeoMatchSetReference.builder()
 *         .geoMatchSetId("geoMatchSetId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.080Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_wafregional.GeoMatchSetReference")
@software.amazon.jsii.Jsii.Proxy(GeoMatchSetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GeoMatchSetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the GeoMatchSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGeoMatchSetId();

    /**
     * @return a {@link Builder} of {@link GeoMatchSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GeoMatchSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GeoMatchSetReference> {
        java.lang.String geoMatchSetId;

        /**
         * Sets the value of {@link GeoMatchSetReference#getGeoMatchSetId}
         * @param geoMatchSetId The Id of the GeoMatchSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoMatchSetId(java.lang.String geoMatchSetId) {
            this.geoMatchSetId = geoMatchSetId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GeoMatchSetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GeoMatchSetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GeoMatchSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoMatchSetReference {
        private final java.lang.String geoMatchSetId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.geoMatchSetId = software.amazon.jsii.Kernel.get(this, "geoMatchSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.geoMatchSetId = java.util.Objects.requireNonNull(builder.geoMatchSetId, "geoMatchSetId is required");
        }

        @Override
        public final java.lang.String getGeoMatchSetId() {
            return this.geoMatchSetId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("geoMatchSetId", om.valueToTree(this.getGeoMatchSetId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_wafregional.GeoMatchSetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GeoMatchSetReference.Jsii$Proxy that = (GeoMatchSetReference.Jsii$Proxy) o;

            return this.geoMatchSetId.equals(that.geoMatchSetId);
        }

        @Override
        public final int hashCode() {
            int result = this.geoMatchSetId.hashCode();
            return result;
        }
    }
}
