package software.amazon.awscdk.interfaces.regional;

/**
 * A reference to a WebACLAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.regional.*;
 * WebACLAssociationReference webACLAssociationReference = WebACLAssociationReference.builder()
 *         .webAclAssociationId("webAclAssociationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.086Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_wafregional.WebACLAssociationReference")
@software.amazon.jsii.Jsii.Proxy(WebACLAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebACLAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the WebACLAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWebAclAssociationId();

    /**
     * @return a {@link Builder} of {@link WebACLAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebACLAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebACLAssociationReference> {
        java.lang.String webAclAssociationId;

        /**
         * Sets the value of {@link WebACLAssociationReference#getWebAclAssociationId}
         * @param webAclAssociationId The Id of the WebACLAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAclAssociationId(java.lang.String webAclAssociationId) {
            this.webAclAssociationId = webAclAssociationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebACLAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebACLAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebACLAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebACLAssociationReference {
        private final java.lang.String webAclAssociationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.webAclAssociationId = software.amazon.jsii.Kernel.get(this, "webAclAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.webAclAssociationId = java.util.Objects.requireNonNull(builder.webAclAssociationId, "webAclAssociationId is required");
        }

        @Override
        public final java.lang.String getWebAclAssociationId() {
            return this.webAclAssociationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("webAclAssociationId", om.valueToTree(this.getWebAclAssociationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_wafregional.WebACLAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebACLAssociationReference.Jsii$Proxy that = (WebACLAssociationReference.Jsii$Proxy) o;

            return this.webAclAssociationId.equals(that.webAclAssociationId);
        }

        @Override
        public final int hashCode() {
            int result = this.webAclAssociationId.hashCode();
            return result;
        }
    }
}
