package software.amazon.awscdk.interfaces.resourceexplorer2;

/**
 * A reference to a DefaultViewAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.resourceexplorer2.*;
 * DefaultViewAssociationReference defaultViewAssociationReference = DefaultViewAssociationReference.builder()
 *         .associatedAwsPrincipal("associatedAwsPrincipal")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.845Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_resourceexplorer2.DefaultViewAssociationReference")
@software.amazon.jsii.Jsii.Proxy(DefaultViewAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DefaultViewAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AssociatedAwsPrincipal of the DefaultViewAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssociatedAwsPrincipal();

    /**
     * @return a {@link Builder} of {@link DefaultViewAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DefaultViewAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DefaultViewAssociationReference> {
        java.lang.String associatedAwsPrincipal;

        /**
         * Sets the value of {@link DefaultViewAssociationReference#getAssociatedAwsPrincipal}
         * @param associatedAwsPrincipal The AssociatedAwsPrincipal of the DefaultViewAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedAwsPrincipal(java.lang.String associatedAwsPrincipal) {
            this.associatedAwsPrincipal = associatedAwsPrincipal;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DefaultViewAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DefaultViewAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DefaultViewAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultViewAssociationReference {
        private final java.lang.String associatedAwsPrincipal;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.associatedAwsPrincipal = software.amazon.jsii.Kernel.get(this, "associatedAwsPrincipal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.associatedAwsPrincipal = java.util.Objects.requireNonNull(builder.associatedAwsPrincipal, "associatedAwsPrincipal is required");
        }

        @Override
        public final java.lang.String getAssociatedAwsPrincipal() {
            return this.associatedAwsPrincipal;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("associatedAwsPrincipal", om.valueToTree(this.getAssociatedAwsPrincipal()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_resourceexplorer2.DefaultViewAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DefaultViewAssociationReference.Jsii$Proxy that = (DefaultViewAssociationReference.Jsii$Proxy) o;

            return this.associatedAwsPrincipal.equals(that.associatedAwsPrincipal);
        }

        @Override
        public final int hashCode() {
            int result = this.associatedAwsPrincipal.hashCode();
            return result;
        }
    }
}
