package software.amazon.awscdk.interfaces.robomaker;

/**
 * A reference to a RobotApplication resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.robomaker.*;
 * RobotApplicationReference robotApplicationReference = RobotApplicationReference.builder()
 *         .robotApplicationArn("robotApplicationArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.859Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_robomaker.RobotApplicationReference")
@software.amazon.jsii.Jsii.Proxy(RobotApplicationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RobotApplicationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the RobotApplication resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRobotApplicationArn();

    /**
     * @return a {@link Builder} of {@link RobotApplicationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RobotApplicationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RobotApplicationReference> {
        java.lang.String robotApplicationArn;

        /**
         * Sets the value of {@link RobotApplicationReference#getRobotApplicationArn}
         * @param robotApplicationArn The Arn of the RobotApplication resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder robotApplicationArn(java.lang.String robotApplicationArn) {
            this.robotApplicationArn = robotApplicationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RobotApplicationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RobotApplicationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RobotApplicationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RobotApplicationReference {
        private final java.lang.String robotApplicationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.robotApplicationArn = software.amazon.jsii.Kernel.get(this, "robotApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.robotApplicationArn = java.util.Objects.requireNonNull(builder.robotApplicationArn, "robotApplicationArn is required");
        }

        @Override
        public final java.lang.String getRobotApplicationArn() {
            return this.robotApplicationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("robotApplicationArn", om.valueToTree(this.getRobotApplicationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_robomaker.RobotApplicationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RobotApplicationReference.Jsii$Proxy that = (RobotApplicationReference.Jsii$Proxy) o;

            return this.robotApplicationArn.equals(that.robotApplicationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.robotApplicationArn.hashCode();
            return result;
        }
    }
}
