package software.amazon.awscdk.interfaces.robomaker;

/**
 * A reference to a RobotApplicationVersion resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.robomaker.*;
 * RobotApplicationVersionReference robotApplicationVersionReference = RobotApplicationVersionReference.builder()
 *         .robotApplicationVersionArn("robotApplicationVersionArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.860Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_robomaker.RobotApplicationVersionReference")
@software.amazon.jsii.Jsii.Proxy(RobotApplicationVersionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RobotApplicationVersionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the RobotApplicationVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRobotApplicationVersionArn();

    /**
     * @return a {@link Builder} of {@link RobotApplicationVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RobotApplicationVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RobotApplicationVersionReference> {
        java.lang.String robotApplicationVersionArn;

        /**
         * Sets the value of {@link RobotApplicationVersionReference#getRobotApplicationVersionArn}
         * @param robotApplicationVersionArn The Arn of the RobotApplicationVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder robotApplicationVersionArn(java.lang.String robotApplicationVersionArn) {
            this.robotApplicationVersionArn = robotApplicationVersionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RobotApplicationVersionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RobotApplicationVersionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RobotApplicationVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RobotApplicationVersionReference {
        private final java.lang.String robotApplicationVersionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.robotApplicationVersionArn = software.amazon.jsii.Kernel.get(this, "robotApplicationVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.robotApplicationVersionArn = java.util.Objects.requireNonNull(builder.robotApplicationVersionArn, "robotApplicationVersionArn is required");
        }

        @Override
        public final java.lang.String getRobotApplicationVersionArn() {
            return this.robotApplicationVersionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("robotApplicationVersionArn", om.valueToTree(this.getRobotApplicationVersionArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_robomaker.RobotApplicationVersionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RobotApplicationVersionReference.Jsii$Proxy that = (RobotApplicationVersionReference.Jsii$Proxy) o;

            return this.robotApplicationVersionArn.equals(that.robotApplicationVersionArn);
        }

        @Override
        public final int hashCode() {
            int result = this.robotApplicationVersionArn.hashCode();
            return result;
        }
    }
}
