package software.amazon.awscdk.interfaces.route53;

/**
 * A reference to a RecordSetGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.route53.*;
 * RecordSetGroupReference recordSetGroupReference = RecordSetGroupReference.builder()
 *         .recordSetGroupId("recordSetGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.866Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_route53.RecordSetGroupReference")
@software.amazon.jsii.Jsii.Proxy(RecordSetGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RecordSetGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the RecordSetGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRecordSetGroupId();

    /**
     * @return a {@link Builder} of {@link RecordSetGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RecordSetGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RecordSetGroupReference> {
        java.lang.String recordSetGroupId;

        /**
         * Sets the value of {@link RecordSetGroupReference#getRecordSetGroupId}
         * @param recordSetGroupId The Id of the RecordSetGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordSetGroupId(java.lang.String recordSetGroupId) {
            this.recordSetGroupId = recordSetGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RecordSetGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RecordSetGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RecordSetGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordSetGroupReference {
        private final java.lang.String recordSetGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.recordSetGroupId = software.amazon.jsii.Kernel.get(this, "recordSetGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.recordSetGroupId = java.util.Objects.requireNonNull(builder.recordSetGroupId, "recordSetGroupId is required");
        }

        @Override
        public final java.lang.String getRecordSetGroupId() {
            return this.recordSetGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("recordSetGroupId", om.valueToTree(this.getRecordSetGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_route53.RecordSetGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RecordSetGroupReference.Jsii$Proxy that = (RecordSetGroupReference.Jsii$Proxy) o;

            return this.recordSetGroupId.equals(that.recordSetGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.recordSetGroupId.hashCode();
            return result;
        }
    }
}
