package software.amazon.awscdk.interfaces.route53profiles;

/**
 * A reference to a ProfileResourceAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.route53profiles.*;
 * ProfileResourceAssociationReference profileResourceAssociationReference = ProfileResourceAssociationReference.builder()
 *         .profileResourceAssociationId("profileResourceAssociationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.868Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_route53profiles.ProfileResourceAssociationReference")
@software.amazon.jsii.Jsii.Proxy(ProfileResourceAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProfileResourceAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the ProfileResourceAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProfileResourceAssociationId();

    /**
     * @return a {@link Builder} of {@link ProfileResourceAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProfileResourceAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProfileResourceAssociationReference> {
        java.lang.String profileResourceAssociationId;

        /**
         * Sets the value of {@link ProfileResourceAssociationReference#getProfileResourceAssociationId}
         * @param profileResourceAssociationId The Id of the ProfileResourceAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profileResourceAssociationId(java.lang.String profileResourceAssociationId) {
            this.profileResourceAssociationId = profileResourceAssociationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProfileResourceAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProfileResourceAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProfileResourceAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProfileResourceAssociationReference {
        private final java.lang.String profileResourceAssociationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.profileResourceAssociationId = software.amazon.jsii.Kernel.get(this, "profileResourceAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.profileResourceAssociationId = java.util.Objects.requireNonNull(builder.profileResourceAssociationId, "profileResourceAssociationId is required");
        }

        @Override
        public final java.lang.String getProfileResourceAssociationId() {
            return this.profileResourceAssociationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("profileResourceAssociationId", om.valueToTree(this.getProfileResourceAssociationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_route53profiles.ProfileResourceAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProfileResourceAssociationReference.Jsii$Proxy that = (ProfileResourceAssociationReference.Jsii$Proxy) o;

            return this.profileResourceAssociationId.equals(that.profileResourceAssociationId);
        }

        @Override
        public final int hashCode() {
            int result = this.profileResourceAssociationId.hashCode();
            return result;
        }
    }
}
