package software.amazon.awscdk.interfaces.route53recoveryreadiness;

/**
 * A reference to a ResourceSet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.route53recoveryreadiness.*;
 * ResourceSetReference resourceSetReference = ResourceSetReference.builder()
 *         .resourceSetArn("resourceSetArn")
 *         .resourceSetName("resourceSetName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.873Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_route53recoveryreadiness.ResourceSetReference")
@software.amazon.jsii.Jsii.Proxy(ResourceSetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourceSetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ResourceSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceSetArn();

    /**
     * The ResourceSetName of the ResourceSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceSetName();

    /**
     * @return a {@link Builder} of {@link ResourceSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourceSetReference> {
        java.lang.String resourceSetArn;
        java.lang.String resourceSetName;

        /**
         * Sets the value of {@link ResourceSetReference#getResourceSetArn}
         * @param resourceSetArn The ARN of the ResourceSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSetArn(java.lang.String resourceSetArn) {
            this.resourceSetArn = resourceSetArn;
            return this;
        }

        /**
         * Sets the value of {@link ResourceSetReference#getResourceSetName}
         * @param resourceSetName The ResourceSetName of the ResourceSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSetName(java.lang.String resourceSetName) {
            this.resourceSetName = resourceSetName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceSetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourceSetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourceSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceSetReference {
        private final java.lang.String resourceSetArn;
        private final java.lang.String resourceSetName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceSetArn = software.amazon.jsii.Kernel.get(this, "resourceSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceSetName = software.amazon.jsii.Kernel.get(this, "resourceSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceSetArn = java.util.Objects.requireNonNull(builder.resourceSetArn, "resourceSetArn is required");
            this.resourceSetName = java.util.Objects.requireNonNull(builder.resourceSetName, "resourceSetName is required");
        }

        @Override
        public final java.lang.String getResourceSetArn() {
            return this.resourceSetArn;
        }

        @Override
        public final java.lang.String getResourceSetName() {
            return this.resourceSetName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceSetArn", om.valueToTree(this.getResourceSetArn()));
            data.set("resourceSetName", om.valueToTree(this.getResourceSetName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_route53recoveryreadiness.ResourceSetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceSetReference.Jsii$Proxy that = (ResourceSetReference.Jsii$Proxy) o;

            if (!resourceSetArn.equals(that.resourceSetArn)) return false;
            return this.resourceSetName.equals(that.resourceSetName);
        }

        @Override
        public final int hashCode() {
            int result = this.resourceSetArn.hashCode();
            result = 31 * result + (this.resourceSetName.hashCode());
            return result;
        }
    }
}
