package software.amazon.awscdk.interfaces.route53resolver;

/**
 * A reference to a ResolverDNSSECConfig resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.route53resolver.*;
 * ResolverDNSSECConfigReference resolverDNSSECConfigReference = ResolverDNSSECConfigReference.builder()
 *         .resolverDnssecConfigId("resolverDnssecConfigId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.879Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_route53resolver.ResolverDNSSECConfigReference")
@software.amazon.jsii.Jsii.Proxy(ResolverDNSSECConfigReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResolverDNSSECConfigReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the ResolverDNSSECConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResolverDnssecConfigId();

    /**
     * @return a {@link Builder} of {@link ResolverDNSSECConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResolverDNSSECConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResolverDNSSECConfigReference> {
        java.lang.String resolverDnssecConfigId;

        /**
         * Sets the value of {@link ResolverDNSSECConfigReference#getResolverDnssecConfigId}
         * @param resolverDnssecConfigId The Id of the ResolverDNSSECConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolverDnssecConfigId(java.lang.String resolverDnssecConfigId) {
            this.resolverDnssecConfigId = resolverDnssecConfigId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResolverDNSSECConfigReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResolverDNSSECConfigReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResolverDNSSECConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResolverDNSSECConfigReference {
        private final java.lang.String resolverDnssecConfigId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resolverDnssecConfigId = software.amazon.jsii.Kernel.get(this, "resolverDnssecConfigId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resolverDnssecConfigId = java.util.Objects.requireNonNull(builder.resolverDnssecConfigId, "resolverDnssecConfigId is required");
        }

        @Override
        public final java.lang.String getResolverDnssecConfigId() {
            return this.resolverDnssecConfigId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resolverDnssecConfigId", om.valueToTree(this.getResolverDnssecConfigId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_route53resolver.ResolverDNSSECConfigReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResolverDNSSECConfigReference.Jsii$Proxy that = (ResolverDNSSECConfigReference.Jsii$Proxy) o;

            return this.resolverDnssecConfigId.equals(that.resolverDnssecConfigId);
        }

        @Override
        public final int hashCode() {
            int result = this.resolverDnssecConfigId.hashCode();
            return result;
        }
    }
}
