package software.amazon.awscdk.interfaces.s3;

/**
 * A reference to a AccessGrant resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.s3.*;
 * AccessGrantReference accessGrantReference = AccessGrantReference.builder()
 *         .accessGrantArn("accessGrantArn")
 *         .accessGrantId("accessGrantId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.894Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_s3.AccessGrantReference")
@software.amazon.jsii.Jsii.Proxy(AccessGrantReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessGrantReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AccessGrant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessGrantArn();

    /**
     * The AccessGrantId of the AccessGrant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessGrantId();

    /**
     * @return a {@link Builder} of {@link AccessGrantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessGrantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessGrantReference> {
        java.lang.String accessGrantArn;
        java.lang.String accessGrantId;

        /**
         * Sets the value of {@link AccessGrantReference#getAccessGrantArn}
         * @param accessGrantArn The ARN of the AccessGrant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGrantArn(java.lang.String accessGrantArn) {
            this.accessGrantArn = accessGrantArn;
            return this;
        }

        /**
         * Sets the value of {@link AccessGrantReference#getAccessGrantId}
         * @param accessGrantId The AccessGrantId of the AccessGrant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGrantId(java.lang.String accessGrantId) {
            this.accessGrantId = accessGrantId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessGrantReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessGrantReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessGrantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessGrantReference {
        private final java.lang.String accessGrantArn;
        private final java.lang.String accessGrantId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessGrantArn = software.amazon.jsii.Kernel.get(this, "accessGrantArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessGrantId = software.amazon.jsii.Kernel.get(this, "accessGrantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessGrantArn = java.util.Objects.requireNonNull(builder.accessGrantArn, "accessGrantArn is required");
            this.accessGrantId = java.util.Objects.requireNonNull(builder.accessGrantId, "accessGrantId is required");
        }

        @Override
        public final java.lang.String getAccessGrantArn() {
            return this.accessGrantArn;
        }

        @Override
        public final java.lang.String getAccessGrantId() {
            return this.accessGrantId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessGrantArn", om.valueToTree(this.getAccessGrantArn()));
            data.set("accessGrantId", om.valueToTree(this.getAccessGrantId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_s3.AccessGrantReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessGrantReference.Jsii$Proxy that = (AccessGrantReference.Jsii$Proxy) o;

            if (!accessGrantArn.equals(that.accessGrantArn)) return false;
            return this.accessGrantId.equals(that.accessGrantId);
        }

        @Override
        public final int hashCode() {
            int result = this.accessGrantArn.hashCode();
            result = 31 * result + (this.accessGrantId.hashCode());
            return result;
        }
    }
}
