package software.amazon.awscdk.interfaces.s3vectors;

/**
 * A reference to a VectorBucketPolicy resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.s3vectors.*;
 * VectorBucketPolicyReference vectorBucketPolicyReference = VectorBucketPolicyReference.builder()
 *         .vectorBucketArn("vectorBucketArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.910Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_s3vectors.VectorBucketPolicyReference")
@software.amazon.jsii.Jsii.Proxy(VectorBucketPolicyReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VectorBucketPolicyReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The VectorBucketArn of the VectorBucketPolicy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVectorBucketArn();

    /**
     * @return a {@link Builder} of {@link VectorBucketPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VectorBucketPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VectorBucketPolicyReference> {
        java.lang.String vectorBucketArn;

        /**
         * Sets the value of {@link VectorBucketPolicyReference#getVectorBucketArn}
         * @param vectorBucketArn The VectorBucketArn of the VectorBucketPolicy resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorBucketArn(java.lang.String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VectorBucketPolicyReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VectorBucketPolicyReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VectorBucketPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VectorBucketPolicyReference {
        private final java.lang.String vectorBucketArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vectorBucketArn = software.amazon.jsii.Kernel.get(this, "vectorBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vectorBucketArn = java.util.Objects.requireNonNull(builder.vectorBucketArn, "vectorBucketArn is required");
        }

        @Override
        public final java.lang.String getVectorBucketArn() {
            return this.vectorBucketArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vectorBucketArn", om.valueToTree(this.getVectorBucketArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_s3vectors.VectorBucketPolicyReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VectorBucketPolicyReference.Jsii$Proxy that = (VectorBucketPolicyReference.Jsii$Proxy) o;

            return this.vectorBucketArn.equals(that.vectorBucketArn);
        }

        @Override
        public final int hashCode() {
            int result = this.vectorBucketArn.hashCode();
            return result;
        }
    }
}
