package software.amazon.awscdk.interfaces.sagemaker;

/**
 * A reference to a AppImageConfig resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.sagemaker.*;
 * AppImageConfigReference appImageConfigReference = AppImageConfigReference.builder()
 *         .appImageConfigArn("appImageConfigArn")
 *         .appImageConfigName("appImageConfigName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.910Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_sagemaker.AppImageConfigReference")
@software.amazon.jsii.Jsii.Proxy(AppImageConfigReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppImageConfigReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AppImageConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppImageConfigArn();

    /**
     * The AppImageConfigName of the AppImageConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppImageConfigName();

    /**
     * @return a {@link Builder} of {@link AppImageConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppImageConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppImageConfigReference> {
        java.lang.String appImageConfigArn;
        java.lang.String appImageConfigName;

        /**
         * Sets the value of {@link AppImageConfigReference#getAppImageConfigArn}
         * @param appImageConfigArn The ARN of the AppImageConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appImageConfigArn(java.lang.String appImageConfigArn) {
            this.appImageConfigArn = appImageConfigArn;
            return this;
        }

        /**
         * Sets the value of {@link AppImageConfigReference#getAppImageConfigName}
         * @param appImageConfigName The AppImageConfigName of the AppImageConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appImageConfigName(java.lang.String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppImageConfigReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppImageConfigReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppImageConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppImageConfigReference {
        private final java.lang.String appImageConfigArn;
        private final java.lang.String appImageConfigName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appImageConfigArn = software.amazon.jsii.Kernel.get(this, "appImageConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appImageConfigName = software.amazon.jsii.Kernel.get(this, "appImageConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appImageConfigArn = java.util.Objects.requireNonNull(builder.appImageConfigArn, "appImageConfigArn is required");
            this.appImageConfigName = java.util.Objects.requireNonNull(builder.appImageConfigName, "appImageConfigName is required");
        }

        @Override
        public final java.lang.String getAppImageConfigArn() {
            return this.appImageConfigArn;
        }

        @Override
        public final java.lang.String getAppImageConfigName() {
            return this.appImageConfigName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appImageConfigArn", om.valueToTree(this.getAppImageConfigArn()));
            data.set("appImageConfigName", om.valueToTree(this.getAppImageConfigName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_sagemaker.AppImageConfigReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppImageConfigReference.Jsii$Proxy that = (AppImageConfigReference.Jsii$Proxy) o;

            if (!appImageConfigArn.equals(that.appImageConfigArn)) return false;
            return this.appImageConfigName.equals(that.appImageConfigName);
        }

        @Override
        public final int hashCode() {
            int result = this.appImageConfigArn.hashCode();
            result = 31 * result + (this.appImageConfigName.hashCode());
            return result;
        }
    }
}
