package software.amazon.awscdk.interfaces.sagemaker;

/**
 * A reference to a App resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.sagemaker.*;
 * AppReference appReference = AppReference.builder()
 *         .appArn("appArn")
 *         .appName("appName")
 *         .appType("appType")
 *         .domainId("domainId")
 *         .userProfileName("userProfileName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.911Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_sagemaker.AppReference")
@software.amazon.jsii.Jsii.Proxy(AppReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the App resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppArn();

    /**
     * The AppName of the App resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppName();

    /**
     * The AppType of the App resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppType();

    /**
     * The DomainId of the App resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainId();

    /**
     * The UserProfileName of the App resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserProfileName();

    /**
     * @return a {@link Builder} of {@link AppReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppReference> {
        java.lang.String appArn;
        java.lang.String appName;
        java.lang.String appType;
        java.lang.String domainId;
        java.lang.String userProfileName;

        /**
         * Sets the value of {@link AppReference#getAppArn}
         * @param appArn The ARN of the App resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appArn(java.lang.String appArn) {
            this.appArn = appArn;
            return this;
        }

        /**
         * Sets the value of {@link AppReference#getAppName}
         * @param appName The AppName of the App resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appName(java.lang.String appName) {
            this.appName = appName;
            return this;
        }

        /**
         * Sets the value of {@link AppReference#getAppType}
         * @param appType The AppType of the App resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appType(java.lang.String appType) {
            this.appType = appType;
            return this;
        }

        /**
         * Sets the value of {@link AppReference#getDomainId}
         * @param domainId The DomainId of the App resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainId(java.lang.String domainId) {
            this.domainId = domainId;
            return this;
        }

        /**
         * Sets the value of {@link AppReference#getUserProfileName}
         * @param userProfileName The UserProfileName of the App resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userProfileName(java.lang.String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppReference {
        private final java.lang.String appArn;
        private final java.lang.String appName;
        private final java.lang.String appType;
        private final java.lang.String domainId;
        private final java.lang.String userProfileName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appArn = software.amazon.jsii.Kernel.get(this, "appArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appName = software.amazon.jsii.Kernel.get(this, "appName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appType = software.amazon.jsii.Kernel.get(this, "appType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainId = software.amazon.jsii.Kernel.get(this, "domainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userProfileName = software.amazon.jsii.Kernel.get(this, "userProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appArn = java.util.Objects.requireNonNull(builder.appArn, "appArn is required");
            this.appName = java.util.Objects.requireNonNull(builder.appName, "appName is required");
            this.appType = java.util.Objects.requireNonNull(builder.appType, "appType is required");
            this.domainId = java.util.Objects.requireNonNull(builder.domainId, "domainId is required");
            this.userProfileName = java.util.Objects.requireNonNull(builder.userProfileName, "userProfileName is required");
        }

        @Override
        public final java.lang.String getAppArn() {
            return this.appArn;
        }

        @Override
        public final java.lang.String getAppName() {
            return this.appName;
        }

        @Override
        public final java.lang.String getAppType() {
            return this.appType;
        }

        @Override
        public final java.lang.String getDomainId() {
            return this.domainId;
        }

        @Override
        public final java.lang.String getUserProfileName() {
            return this.userProfileName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appArn", om.valueToTree(this.getAppArn()));
            data.set("appName", om.valueToTree(this.getAppName()));
            data.set("appType", om.valueToTree(this.getAppType()));
            data.set("domainId", om.valueToTree(this.getDomainId()));
            data.set("userProfileName", om.valueToTree(this.getUserProfileName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_sagemaker.AppReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppReference.Jsii$Proxy that = (AppReference.Jsii$Proxy) o;

            if (!appArn.equals(that.appArn)) return false;
            if (!appName.equals(that.appName)) return false;
            if (!appType.equals(that.appType)) return false;
            if (!domainId.equals(that.domainId)) return false;
            return this.userProfileName.equals(that.userProfileName);
        }

        @Override
        public final int hashCode() {
            int result = this.appArn.hashCode();
            result = 31 * result + (this.appName.hashCode());
            result = 31 * result + (this.appType.hashCode());
            result = 31 * result + (this.domainId.hashCode());
            result = 31 * result + (this.userProfileName.hashCode());
            return result;
        }
    }
}
