package software.amazon.awscdk.interfaces.sagemaker;

/**
 * A reference to a CodeRepository resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.sagemaker.*;
 * CodeRepositoryReference codeRepositoryReference = CodeRepositoryReference.builder()
 *         .codeRepositoryId("codeRepositoryId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.911Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_sagemaker.CodeRepositoryReference")
@software.amazon.jsii.Jsii.Proxy(CodeRepositoryReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeRepositoryReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the CodeRepository resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCodeRepositoryId();

    /**
     * @return a {@link Builder} of {@link CodeRepositoryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeRepositoryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeRepositoryReference> {
        java.lang.String codeRepositoryId;

        /**
         * Sets the value of {@link CodeRepositoryReference#getCodeRepositoryId}
         * @param codeRepositoryId The Id of the CodeRepository resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeRepositoryId(java.lang.String codeRepositoryId) {
            this.codeRepositoryId = codeRepositoryId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeRepositoryReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeRepositoryReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeRepositoryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeRepositoryReference {
        private final java.lang.String codeRepositoryId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.codeRepositoryId = software.amazon.jsii.Kernel.get(this, "codeRepositoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.codeRepositoryId = java.util.Objects.requireNonNull(builder.codeRepositoryId, "codeRepositoryId is required");
        }

        @Override
        public final java.lang.String getCodeRepositoryId() {
            return this.codeRepositoryId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("codeRepositoryId", om.valueToTree(this.getCodeRepositoryId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_sagemaker.CodeRepositoryReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeRepositoryReference.Jsii$Proxy that = (CodeRepositoryReference.Jsii$Proxy) o;

            return this.codeRepositoryId.equals(that.codeRepositoryId);
        }

        @Override
        public final int hashCode() {
            int result = this.codeRepositoryId.hashCode();
            return result;
        }
    }
}
