package software.amazon.awscdk.interfaces.securityhub;

/**
 * A reference to a AggregatorV2 resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.securityhub.*;
 * AggregatorV2Reference aggregatorV2Reference = AggregatorV2Reference.builder()
 *         .aggregatorV2Arn("aggregatorV2Arn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.947Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_securityhub.AggregatorV2Reference")
@software.amazon.jsii.Jsii.Proxy(AggregatorV2Reference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AggregatorV2Reference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AggregatorV2Arn of the AggregatorV2 resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAggregatorV2Arn();

    /**
     * @return a {@link Builder} of {@link AggregatorV2Reference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AggregatorV2Reference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AggregatorV2Reference> {
        java.lang.String aggregatorV2Arn;

        /**
         * Sets the value of {@link AggregatorV2Reference#getAggregatorV2Arn}
         * @param aggregatorV2Arn The AggregatorV2Arn of the AggregatorV2 resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aggregatorV2Arn(java.lang.String aggregatorV2Arn) {
            this.aggregatorV2Arn = aggregatorV2Arn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AggregatorV2Reference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AggregatorV2Reference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AggregatorV2Reference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregatorV2Reference {
        private final java.lang.String aggregatorV2Arn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aggregatorV2Arn = software.amazon.jsii.Kernel.get(this, "aggregatorV2Arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aggregatorV2Arn = java.util.Objects.requireNonNull(builder.aggregatorV2Arn, "aggregatorV2Arn is required");
        }

        @Override
        public final java.lang.String getAggregatorV2Arn() {
            return this.aggregatorV2Arn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aggregatorV2Arn", om.valueToTree(this.getAggregatorV2Arn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_securityhub.AggregatorV2Reference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AggregatorV2Reference.Jsii$Proxy that = (AggregatorV2Reference.Jsii$Proxy) o;

            return this.aggregatorV2Arn.equals(that.aggregatorV2Arn);
        }

        @Override
        public final int hashCode() {
            int result = this.aggregatorV2Arn.hashCode();
            return result;
        }
    }
}
