package software.amazon.awscdk.interfaces.securityhub;

/**
 * A reference to a OrganizationConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.securityhub.*;
 * OrganizationConfigurationReference organizationConfigurationReference = OrganizationConfigurationReference.builder()
 *         .organizationConfigurationIdentifier("organizationConfigurationIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.963Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_securityhub.OrganizationConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(OrganizationConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OrganizationConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The OrganizationConfigurationIdentifier of the OrganizationConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOrganizationConfigurationIdentifier();

    /**
     * @return a {@link Builder} of {@link OrganizationConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OrganizationConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OrganizationConfigurationReference> {
        java.lang.String organizationConfigurationIdentifier;

        /**
         * Sets the value of {@link OrganizationConfigurationReference#getOrganizationConfigurationIdentifier}
         * @param organizationConfigurationIdentifier The OrganizationConfigurationIdentifier of the OrganizationConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationConfigurationIdentifier(java.lang.String organizationConfigurationIdentifier) {
            this.organizationConfigurationIdentifier = organizationConfigurationIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OrganizationConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OrganizationConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OrganizationConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationConfigurationReference {
        private final java.lang.String organizationConfigurationIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.organizationConfigurationIdentifier = software.amazon.jsii.Kernel.get(this, "organizationConfigurationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.organizationConfigurationIdentifier = java.util.Objects.requireNonNull(builder.organizationConfigurationIdentifier, "organizationConfigurationIdentifier is required");
        }

        @Override
        public final java.lang.String getOrganizationConfigurationIdentifier() {
            return this.organizationConfigurationIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("organizationConfigurationIdentifier", om.valueToTree(this.getOrganizationConfigurationIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_securityhub.OrganizationConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OrganizationConfigurationReference.Jsii$Proxy that = (OrganizationConfigurationReference.Jsii$Proxy) o;

            return this.organizationConfigurationIdentifier.equals(that.organizationConfigurationIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.organizationConfigurationIdentifier.hashCode();
            return result;
        }
    }
}
