package software.amazon.awscdk.interfaces.securityhub;

/**
 * A reference to a PolicyAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.securityhub.*;
 * PolicyAssociationReference policyAssociationReference = PolicyAssociationReference.builder()
 *         .associationIdentifier("associationIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.964Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_securityhub.PolicyAssociationReference")
@software.amazon.jsii.Jsii.Proxy(PolicyAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AssociationIdentifier of the PolicyAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssociationIdentifier();

    /**
     * @return a {@link Builder} of {@link PolicyAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PolicyAssociationReference> {
        java.lang.String associationIdentifier;

        /**
         * Sets the value of {@link PolicyAssociationReference#getAssociationIdentifier}
         * @param associationIdentifier The AssociationIdentifier of the PolicyAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associationIdentifier(java.lang.String associationIdentifier) {
            this.associationIdentifier = associationIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PolicyAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PolicyAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyAssociationReference {
        private final java.lang.String associationIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.associationIdentifier = software.amazon.jsii.Kernel.get(this, "associationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.associationIdentifier = java.util.Objects.requireNonNull(builder.associationIdentifier, "associationIdentifier is required");
        }

        @Override
        public final java.lang.String getAssociationIdentifier() {
            return this.associationIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("associationIdentifier", om.valueToTree(this.getAssociationIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_securityhub.PolicyAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyAssociationReference.Jsii$Proxy that = (PolicyAssociationReference.Jsii$Proxy) o;

            return this.associationIdentifier.equals(that.associationIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.associationIdentifier.hashCode();
            return result;
        }
    }
}
