package software.amazon.awscdk.interfaces.servicecatalog;

/**
 * A reference to a LaunchRoleConstraint resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.servicecatalog.*;
 * LaunchRoleConstraintReference launchRoleConstraintReference = LaunchRoleConstraintReference.builder()
 *         .launchRoleConstraintId("launchRoleConstraintId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.973Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_servicecatalog.LaunchRoleConstraintReference")
@software.amazon.jsii.Jsii.Proxy(LaunchRoleConstraintReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LaunchRoleConstraintReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the LaunchRoleConstraint resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLaunchRoleConstraintId();

    /**
     * @return a {@link Builder} of {@link LaunchRoleConstraintReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LaunchRoleConstraintReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LaunchRoleConstraintReference> {
        java.lang.String launchRoleConstraintId;

        /**
         * Sets the value of {@link LaunchRoleConstraintReference#getLaunchRoleConstraintId}
         * @param launchRoleConstraintId The Id of the LaunchRoleConstraint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchRoleConstraintId(java.lang.String launchRoleConstraintId) {
            this.launchRoleConstraintId = launchRoleConstraintId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LaunchRoleConstraintReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LaunchRoleConstraintReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LaunchRoleConstraintReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchRoleConstraintReference {
        private final java.lang.String launchRoleConstraintId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.launchRoleConstraintId = software.amazon.jsii.Kernel.get(this, "launchRoleConstraintId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.launchRoleConstraintId = java.util.Objects.requireNonNull(builder.launchRoleConstraintId, "launchRoleConstraintId is required");
        }

        @Override
        public final java.lang.String getLaunchRoleConstraintId() {
            return this.launchRoleConstraintId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("launchRoleConstraintId", om.valueToTree(this.getLaunchRoleConstraintId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_servicecatalog.LaunchRoleConstraintReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LaunchRoleConstraintReference.Jsii$Proxy that = (LaunchRoleConstraintReference.Jsii$Proxy) o;

            return this.launchRoleConstraintId.equals(that.launchRoleConstraintId);
        }

        @Override
        public final int hashCode() {
            int result = this.launchRoleConstraintId.hashCode();
            return result;
        }
    }
}
