package software.amazon.awscdk.interfaces.servicecatalog;

/**
 * A reference to a PortfolioPrincipalAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.servicecatalog.*;
 * PortfolioPrincipalAssociationReference portfolioPrincipalAssociationReference = PortfolioPrincipalAssociationReference.builder()
 *         .portfolioId("portfolioId")
 *         .principalArn("principalArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.974Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_servicecatalog.PortfolioPrincipalAssociationReference")
@software.amazon.jsii.Jsii.Proxy(PortfolioPrincipalAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PortfolioPrincipalAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The PortfolioId of the PortfolioPrincipalAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortfolioId();

    /**
     * The PrincipalARN of the PortfolioPrincipalAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrincipalArn();

    /**
     * @return a {@link Builder} of {@link PortfolioPrincipalAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PortfolioPrincipalAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PortfolioPrincipalAssociationReference> {
        java.lang.String portfolioId;
        java.lang.String principalArn;

        /**
         * Sets the value of {@link PortfolioPrincipalAssociationReference#getPortfolioId}
         * @param portfolioId The PortfolioId of the PortfolioPrincipalAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portfolioId(java.lang.String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        /**
         * Sets the value of {@link PortfolioPrincipalAssociationReference#getPrincipalArn}
         * @param principalArn The PrincipalARN of the PortfolioPrincipalAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principalArn(java.lang.String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PortfolioPrincipalAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PortfolioPrincipalAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PortfolioPrincipalAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortfolioPrincipalAssociationReference {
        private final java.lang.String portfolioId;
        private final java.lang.String principalArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.portfolioId = software.amazon.jsii.Kernel.get(this, "portfolioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.principalArn = software.amazon.jsii.Kernel.get(this, "principalArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.portfolioId = java.util.Objects.requireNonNull(builder.portfolioId, "portfolioId is required");
            this.principalArn = java.util.Objects.requireNonNull(builder.principalArn, "principalArn is required");
        }

        @Override
        public final java.lang.String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final java.lang.String getPrincipalArn() {
            return this.principalArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("portfolioId", om.valueToTree(this.getPortfolioId()));
            data.set("principalArn", om.valueToTree(this.getPrincipalArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_servicecatalog.PortfolioPrincipalAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PortfolioPrincipalAssociationReference.Jsii$Proxy that = (PortfolioPrincipalAssociationReference.Jsii$Proxy) o;

            if (!portfolioId.equals(that.portfolioId)) return false;
            return this.principalArn.equals(that.principalArn);
        }

        @Override
        public final int hashCode() {
            int result = this.portfolioId.hashCode();
            result = 31 * result + (this.principalArn.hashCode());
            return result;
        }
    }
}
