package software.amazon.awscdk.interfaces.servicecatalog;

/**
 * A reference to a TagOption resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.servicecatalog.*;
 * TagOptionReference tagOptionReference = TagOptionReference.builder()
 *         .tagOptionId("tagOptionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.977Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_servicecatalog.TagOptionReference")
@software.amazon.jsii.Jsii.Proxy(TagOptionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TagOptionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the TagOption resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTagOptionId();

    /**
     * @return a {@link Builder} of {@link TagOptionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TagOptionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TagOptionReference> {
        java.lang.String tagOptionId;

        /**
         * Sets the value of {@link TagOptionReference#getTagOptionId}
         * @param tagOptionId The Id of the TagOption resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagOptionId(java.lang.String tagOptionId) {
            this.tagOptionId = tagOptionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TagOptionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TagOptionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TagOptionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagOptionReference {
        private final java.lang.String tagOptionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tagOptionId = software.amazon.jsii.Kernel.get(this, "tagOptionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tagOptionId = java.util.Objects.requireNonNull(builder.tagOptionId, "tagOptionId is required");
        }

        @Override
        public final java.lang.String getTagOptionId() {
            return this.tagOptionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("tagOptionId", om.valueToTree(this.getTagOptionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_servicecatalog.TagOptionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TagOptionReference.Jsii$Proxy that = (TagOptionReference.Jsii$Proxy) o;

            return this.tagOptionId.equals(that.tagOptionId);
        }

        @Override
        public final int hashCode() {
            int result = this.tagOptionId.hashCode();
            return result;
        }
    }
}
