package software.amazon.awscdk.interfaces.servicecatalogappregistry;

/**
 * A reference to a AttributeGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.servicecatalogappregistry.*;
 * AttributeGroupReference attributeGroupReference = AttributeGroupReference.builder()
 *         .attributeGroupArn("attributeGroupArn")
 *         .attributeGroupId("attributeGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.977Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_servicecatalogappregistry.AttributeGroupReference")
@software.amazon.jsii.Jsii.Proxy(AttributeGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AttributeGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AttributeGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAttributeGroupArn();

    /**
     * The Id of the AttributeGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAttributeGroupId();

    /**
     * @return a {@link Builder} of {@link AttributeGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AttributeGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AttributeGroupReference> {
        java.lang.String attributeGroupArn;
        java.lang.String attributeGroupId;

        /**
         * Sets the value of {@link AttributeGroupReference#getAttributeGroupArn}
         * @param attributeGroupArn The ARN of the AttributeGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeGroupArn(java.lang.String attributeGroupArn) {
            this.attributeGroupArn = attributeGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link AttributeGroupReference#getAttributeGroupId}
         * @param attributeGroupId The Id of the AttributeGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeGroupId(java.lang.String attributeGroupId) {
            this.attributeGroupId = attributeGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AttributeGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AttributeGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AttributeGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeGroupReference {
        private final java.lang.String attributeGroupArn;
        private final java.lang.String attributeGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.attributeGroupArn = software.amazon.jsii.Kernel.get(this, "attributeGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attributeGroupId = software.amazon.jsii.Kernel.get(this, "attributeGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.attributeGroupArn = java.util.Objects.requireNonNull(builder.attributeGroupArn, "attributeGroupArn is required");
            this.attributeGroupId = java.util.Objects.requireNonNull(builder.attributeGroupId, "attributeGroupId is required");
        }

        @Override
        public final java.lang.String getAttributeGroupArn() {
            return this.attributeGroupArn;
        }

        @Override
        public final java.lang.String getAttributeGroupId() {
            return this.attributeGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("attributeGroupArn", om.valueToTree(this.getAttributeGroupArn()));
            data.set("attributeGroupId", om.valueToTree(this.getAttributeGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_servicecatalogappregistry.AttributeGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AttributeGroupReference.Jsii$Proxy that = (AttributeGroupReference.Jsii$Proxy) o;

            if (!attributeGroupArn.equals(that.attributeGroupArn)) return false;
            return this.attributeGroupId.equals(that.attributeGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.attributeGroupArn.hashCode();
            result = 31 * result + (this.attributeGroupId.hashCode());
            return result;
        }
    }
}
