package software.amazon.awscdk.interfaces.ses;

/**
 * A reference to a ContactList resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ses.*;
 * ContactListReference contactListReference = ContactListReference.builder()
 *         .contactListName("contactListName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.983Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ses.ContactListReference")
@software.amazon.jsii.Jsii.Proxy(ContactListReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContactListReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ContactListName of the ContactList resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContactListName();

    /**
     * @return a {@link Builder} of {@link ContactListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContactListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContactListReference> {
        java.lang.String contactListName;

        /**
         * Sets the value of {@link ContactListReference#getContactListName}
         * @param contactListName The ContactListName of the ContactList resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactListName(java.lang.String contactListName) {
            this.contactListName = contactListName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContactListReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContactListReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContactListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContactListReference {
        private final java.lang.String contactListName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contactListName = software.amazon.jsii.Kernel.get(this, "contactListName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contactListName = java.util.Objects.requireNonNull(builder.contactListName, "contactListName is required");
        }

        @Override
        public final java.lang.String getContactListName() {
            return this.contactListName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("contactListName", om.valueToTree(this.getContactListName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ses.ContactListReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContactListReference.Jsii$Proxy that = (ContactListReference.Jsii$Proxy) o;

            return this.contactListName.equals(that.contactListName);
        }

        @Override
        public final int hashCode() {
            int result = this.contactListName.hashCode();
            return result;
        }
    }
}
