package software.amazon.awscdk.interfaces.ses;

/**
 * A reference to a MailManagerAddonInstance resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ses.*;
 * MailManagerAddonInstanceReference mailManagerAddonInstanceReference = MailManagerAddonInstanceReference.builder()
 *         .addonInstanceId("addonInstanceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.000Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ses.MailManagerAddonInstanceReference")
@software.amazon.jsii.Jsii.Proxy(MailManagerAddonInstanceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MailManagerAddonInstanceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AddonInstanceId of the MailManagerAddonInstance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAddonInstanceId();

    /**
     * @return a {@link Builder} of {@link MailManagerAddonInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MailManagerAddonInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MailManagerAddonInstanceReference> {
        java.lang.String addonInstanceId;

        /**
         * Sets the value of {@link MailManagerAddonInstanceReference#getAddonInstanceId}
         * @param addonInstanceId The AddonInstanceId of the MailManagerAddonInstance resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addonInstanceId(java.lang.String addonInstanceId) {
            this.addonInstanceId = addonInstanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MailManagerAddonInstanceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MailManagerAddonInstanceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MailManagerAddonInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MailManagerAddonInstanceReference {
        private final java.lang.String addonInstanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addonInstanceId = software.amazon.jsii.Kernel.get(this, "addonInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addonInstanceId = java.util.Objects.requireNonNull(builder.addonInstanceId, "addonInstanceId is required");
        }

        @Override
        public final java.lang.String getAddonInstanceId() {
            return this.addonInstanceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("addonInstanceId", om.valueToTree(this.getAddonInstanceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ses.MailManagerAddonInstanceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MailManagerAddonInstanceReference.Jsii$Proxy that = (MailManagerAddonInstanceReference.Jsii$Proxy) o;

            return this.addonInstanceId.equals(that.addonInstanceId);
        }

        @Override
        public final int hashCode() {
            int result = this.addonInstanceId.hashCode();
            return result;
        }
    }
}
