package software.amazon.awscdk.interfaces.ses;

/**
 * A reference to a MailManagerArchive resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ses.*;
 * MailManagerArchiveReference mailManagerArchiveReference = MailManagerArchiveReference.builder()
 *         .archiveId("archiveId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.001Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ses.MailManagerArchiveReference")
@software.amazon.jsii.Jsii.Proxy(MailManagerArchiveReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MailManagerArchiveReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ArchiveId of the MailManagerArchive resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArchiveId();

    /**
     * @return a {@link Builder} of {@link MailManagerArchiveReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MailManagerArchiveReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MailManagerArchiveReference> {
        java.lang.String archiveId;

        /**
         * Sets the value of {@link MailManagerArchiveReference#getArchiveId}
         * @param archiveId The ArchiveId of the MailManagerArchive resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archiveId(java.lang.String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MailManagerArchiveReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MailManagerArchiveReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MailManagerArchiveReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MailManagerArchiveReference {
        private final java.lang.String archiveId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.archiveId = software.amazon.jsii.Kernel.get(this, "archiveId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.archiveId = java.util.Objects.requireNonNull(builder.archiveId, "archiveId is required");
        }

        @Override
        public final java.lang.String getArchiveId() {
            return this.archiveId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("archiveId", om.valueToTree(this.getArchiveId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ses.MailManagerArchiveReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MailManagerArchiveReference.Jsii$Proxy that = (MailManagerArchiveReference.Jsii$Proxy) o;

            return this.archiveId.equals(that.archiveId);
        }

        @Override
        public final int hashCode() {
            int result = this.archiveId.hashCode();
            return result;
        }
    }
}
