package software.amazon.awscdk.interfaces.signer;

/**
 * A reference to a ProfilePermission resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.signer.*;
 * ProfilePermissionReference profilePermissionReference = ProfilePermissionReference.builder()
 *         .profileName("profileName")
 *         .statementId("statementId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.007Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_signer.ProfilePermissionReference")
@software.amazon.jsii.Jsii.Proxy(ProfilePermissionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProfilePermissionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ProfileName of the ProfilePermission resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProfileName();

    /**
     * The StatementId of the ProfilePermission resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatementId();

    /**
     * @return a {@link Builder} of {@link ProfilePermissionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProfilePermissionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProfilePermissionReference> {
        java.lang.String profileName;
        java.lang.String statementId;

        /**
         * Sets the value of {@link ProfilePermissionReference#getProfileName}
         * @param profileName The ProfileName of the ProfilePermission resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profileName(java.lang.String profileName) {
            this.profileName = profileName;
            return this;
        }

        /**
         * Sets the value of {@link ProfilePermissionReference#getStatementId}
         * @param statementId The StatementId of the ProfilePermission resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statementId(java.lang.String statementId) {
            this.statementId = statementId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProfilePermissionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProfilePermissionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProfilePermissionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProfilePermissionReference {
        private final java.lang.String profileName;
        private final java.lang.String statementId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.profileName = software.amazon.jsii.Kernel.get(this, "profileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statementId = software.amazon.jsii.Kernel.get(this, "statementId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.profileName = java.util.Objects.requireNonNull(builder.profileName, "profileName is required");
            this.statementId = java.util.Objects.requireNonNull(builder.statementId, "statementId is required");
        }

        @Override
        public final java.lang.String getProfileName() {
            return this.profileName;
        }

        @Override
        public final java.lang.String getStatementId() {
            return this.statementId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("profileName", om.valueToTree(this.getProfileName()));
            data.set("statementId", om.valueToTree(this.getStatementId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_signer.ProfilePermissionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProfilePermissionReference.Jsii$Proxy that = (ProfilePermissionReference.Jsii$Proxy) o;

            if (!profileName.equals(that.profileName)) return false;
            return this.statementId.equals(that.statementId);
        }

        @Override
        public final int hashCode() {
            int result = this.profileName.hashCode();
            result = 31 * result + (this.statementId.hashCode());
            return result;
        }
    }
}
