package software.amazon.awscdk.interfaces.simspaceweaver;

/**
 * A reference to a Simulation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.simspaceweaver.*;
 * SimulationReference simulationReference = SimulationReference.builder()
 *         .simulationName("simulationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.008Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_simspaceweaver.SimulationReference")
@software.amazon.jsii.Jsii.Proxy(SimulationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SimulationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Name of the Simulation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSimulationName();

    /**
     * @return a {@link Builder} of {@link SimulationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SimulationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SimulationReference> {
        java.lang.String simulationName;

        /**
         * Sets the value of {@link SimulationReference#getSimulationName}
         * @param simulationName The Name of the Simulation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simulationName(java.lang.String simulationName) {
            this.simulationName = simulationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SimulationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SimulationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SimulationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SimulationReference {
        private final java.lang.String simulationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.simulationName = software.amazon.jsii.Kernel.get(this, "simulationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.simulationName = java.util.Objects.requireNonNull(builder.simulationName, "simulationName is required");
        }

        @Override
        public final java.lang.String getSimulationName() {
            return this.simulationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("simulationName", om.valueToTree(this.getSimulationName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_simspaceweaver.SimulationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SimulationReference.Jsii$Proxy that = (SimulationReference.Jsii$Proxy) o;

            return this.simulationName.equals(that.simulationName);
        }

        @Override
        public final int hashCode() {
            int result = this.simulationName.hashCode();
            return result;
        }
    }
}
