package software.amazon.awscdk.interfaces.stepfunctions;

/**
 * A reference to a StateMachineVersion resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.stepfunctions.*;
 * StateMachineVersionReference stateMachineVersionReference = StateMachineVersionReference.builder()
 *         .stateMachineVersionArn("stateMachineVersionArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.044Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_stepfunctions.StateMachineVersionReference")
@software.amazon.jsii.Jsii.Proxy(StateMachineVersionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StateMachineVersionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the StateMachineVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStateMachineVersionArn();

    /**
     * @return a {@link Builder} of {@link StateMachineVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StateMachineVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StateMachineVersionReference> {
        java.lang.String stateMachineVersionArn;

        /**
         * Sets the value of {@link StateMachineVersionReference#getStateMachineVersionArn}
         * @param stateMachineVersionArn The Arn of the StateMachineVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineVersionArn(java.lang.String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StateMachineVersionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StateMachineVersionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StateMachineVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateMachineVersionReference {
        private final java.lang.String stateMachineVersionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stateMachineVersionArn = software.amazon.jsii.Kernel.get(this, "stateMachineVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stateMachineVersionArn = java.util.Objects.requireNonNull(builder.stateMachineVersionArn, "stateMachineVersionArn is required");
        }

        @Override
        public final java.lang.String getStateMachineVersionArn() {
            return this.stateMachineVersionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stateMachineVersionArn", om.valueToTree(this.getStateMachineVersionArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_stepfunctions.StateMachineVersionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StateMachineVersionReference.Jsii$Proxy that = (StateMachineVersionReference.Jsii$Proxy) o;

            return this.stateMachineVersionArn.equals(that.stateMachineVersionArn);
        }

        @Override
        public final int hashCode() {
            int result = this.stateMachineVersionArn.hashCode();
            return result;
        }
    }
}
