package software.amazon.awscdk.interfaces.verifiedpermissions;

/**
 * A reference to a PolicyTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.verifiedpermissions.*;
 * PolicyTemplateReference policyTemplateReference = PolicyTemplateReference.builder()
 *         .policyStoreId("policyStoreId")
 *         .policyTemplateId("policyTemplateId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.058Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_verifiedpermissions.PolicyTemplateReference")
@software.amazon.jsii.Jsii.Proxy(PolicyTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The PolicyStoreId of the PolicyTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyStoreId();

    /**
     * The PolicyTemplateId of the PolicyTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyTemplateId();

    /**
     * @return a {@link Builder} of {@link PolicyTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PolicyTemplateReference> {
        java.lang.String policyStoreId;
        java.lang.String policyTemplateId;

        /**
         * Sets the value of {@link PolicyTemplateReference#getPolicyStoreId}
         * @param policyStoreId The PolicyStoreId of the PolicyTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStoreId(java.lang.String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        /**
         * Sets the value of {@link PolicyTemplateReference#getPolicyTemplateId}
         * @param policyTemplateId The PolicyTemplateId of the PolicyTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyTemplateId(java.lang.String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PolicyTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PolicyTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyTemplateReference {
        private final java.lang.String policyStoreId;
        private final java.lang.String policyTemplateId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyStoreId = software.amazon.jsii.Kernel.get(this, "policyStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyTemplateId = software.amazon.jsii.Kernel.get(this, "policyTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyStoreId = java.util.Objects.requireNonNull(builder.policyStoreId, "policyStoreId is required");
            this.policyTemplateId = java.util.Objects.requireNonNull(builder.policyTemplateId, "policyTemplateId is required");
        }

        @Override
        public final java.lang.String getPolicyStoreId() {
            return this.policyStoreId;
        }

        @Override
        public final java.lang.String getPolicyTemplateId() {
            return this.policyTemplateId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policyStoreId", om.valueToTree(this.getPolicyStoreId()));
            data.set("policyTemplateId", om.valueToTree(this.getPolicyTemplateId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_verifiedpermissions.PolicyTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyTemplateReference.Jsii$Proxy that = (PolicyTemplateReference.Jsii$Proxy) o;

            if (!policyStoreId.equals(that.policyStoreId)) return false;
            return this.policyTemplateId.equals(that.policyTemplateId);
        }

        @Override
        public final int hashCode() {
            int result = this.policyStoreId.hashCode();
            result = 31 * result + (this.policyTemplateId.hashCode());
            return result;
        }
    }
}
