package software.amazon.awscdk.interfaces.wisdom;

/**
 * A reference to a AIPromptVersion resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.wisdom.*;
 * AIPromptVersionReference aIPromptVersionReference = AIPromptVersionReference.builder()
 *         .aiPromptId("aiPromptId")
 *         .assistantId("assistantId")
 *         .versionNumber("versionNumber")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.092Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_wisdom.AIPromptVersionReference")
@software.amazon.jsii.Jsii.Proxy(AIPromptVersionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AIPromptVersionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AIPromptId of the AIPromptVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAiPromptId();

    /**
     * The AssistantId of the AIPromptVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantId();

    /**
     * The VersionNumber of the AIPromptVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVersionNumber();

    /**
     * @return a {@link Builder} of {@link AIPromptVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AIPromptVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AIPromptVersionReference> {
        java.lang.String aiPromptId;
        java.lang.String assistantId;
        java.lang.String versionNumber;

        /**
         * Sets the value of {@link AIPromptVersionReference#getAiPromptId}
         * @param aiPromptId The AIPromptId of the AIPromptVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aiPromptId(java.lang.String aiPromptId) {
            this.aiPromptId = aiPromptId;
            return this;
        }

        /**
         * Sets the value of {@link AIPromptVersionReference#getAssistantId}
         * @param assistantId The AssistantId of the AIPromptVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(java.lang.String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        /**
         * Sets the value of {@link AIPromptVersionReference#getVersionNumber}
         * @param versionNumber The VersionNumber of the AIPromptVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionNumber(java.lang.String versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AIPromptVersionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AIPromptVersionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AIPromptVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AIPromptVersionReference {
        private final java.lang.String aiPromptId;
        private final java.lang.String assistantId;
        private final java.lang.String versionNumber;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aiPromptId = software.amazon.jsii.Kernel.get(this, "aiPromptId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assistantId = software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionNumber = software.amazon.jsii.Kernel.get(this, "versionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aiPromptId = java.util.Objects.requireNonNull(builder.aiPromptId, "aiPromptId is required");
            this.assistantId = java.util.Objects.requireNonNull(builder.assistantId, "assistantId is required");
            this.versionNumber = java.util.Objects.requireNonNull(builder.versionNumber, "versionNumber is required");
        }

        @Override
        public final java.lang.String getAiPromptId() {
            return this.aiPromptId;
        }

        @Override
        public final java.lang.String getAssistantId() {
            return this.assistantId;
        }

        @Override
        public final java.lang.String getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aiPromptId", om.valueToTree(this.getAiPromptId()));
            data.set("assistantId", om.valueToTree(this.getAssistantId()));
            data.set("versionNumber", om.valueToTree(this.getVersionNumber()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_wisdom.AIPromptVersionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AIPromptVersionReference.Jsii$Proxy that = (AIPromptVersionReference.Jsii$Proxy) o;

            if (!aiPromptId.equals(that.aiPromptId)) return false;
            if (!assistantId.equals(that.assistantId)) return false;
            return this.versionNumber.equals(that.versionNumber);
        }

        @Override
        public final int hashCode() {
            int result = this.aiPromptId.hashCode();
            result = 31 * result + (this.assistantId.hashCode());
            result = 31 * result + (this.versionNumber.hashCode());
            return result;
        }
    }
}
