package software.amazon.awscdk.interfaces.wisdom;

/**
 * A reference to a AssistantAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.wisdom.*;
 * AssistantAssociationReference assistantAssociationReference = AssistantAssociationReference.builder()
 *         .assistantAssociationArn("assistantAssociationArn")
 *         .assistantAssociationId("assistantAssociationId")
 *         .assistantId("assistantId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.093Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_wisdom.AssistantAssociationReference")
@software.amazon.jsii.Jsii.Proxy(AssistantAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssistantAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AssistantAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantAssociationArn();

    /**
     * The AssistantAssociationId of the AssistantAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantAssociationId();

    /**
     * The AssistantId of the AssistantAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantId();

    /**
     * @return a {@link Builder} of {@link AssistantAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssistantAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssistantAssociationReference> {
        java.lang.String assistantAssociationArn;
        java.lang.String assistantAssociationId;
        java.lang.String assistantId;

        /**
         * Sets the value of {@link AssistantAssociationReference#getAssistantAssociationArn}
         * @param assistantAssociationArn The ARN of the AssistantAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantAssociationArn(java.lang.String assistantAssociationArn) {
            this.assistantAssociationArn = assistantAssociationArn;
            return this;
        }

        /**
         * Sets the value of {@link AssistantAssociationReference#getAssistantAssociationId}
         * @param assistantAssociationId The AssistantAssociationId of the AssistantAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantAssociationId(java.lang.String assistantAssociationId) {
            this.assistantAssociationId = assistantAssociationId;
            return this;
        }

        /**
         * Sets the value of {@link AssistantAssociationReference#getAssistantId}
         * @param assistantId The AssistantId of the AssistantAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(java.lang.String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssistantAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssistantAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssistantAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssistantAssociationReference {
        private final java.lang.String assistantAssociationArn;
        private final java.lang.String assistantAssociationId;
        private final java.lang.String assistantId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assistantAssociationArn = software.amazon.jsii.Kernel.get(this, "assistantAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assistantAssociationId = software.amazon.jsii.Kernel.get(this, "assistantAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assistantId = software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assistantAssociationArn = java.util.Objects.requireNonNull(builder.assistantAssociationArn, "assistantAssociationArn is required");
            this.assistantAssociationId = java.util.Objects.requireNonNull(builder.assistantAssociationId, "assistantAssociationId is required");
            this.assistantId = java.util.Objects.requireNonNull(builder.assistantId, "assistantId is required");
        }

        @Override
        public final java.lang.String getAssistantAssociationArn() {
            return this.assistantAssociationArn;
        }

        @Override
        public final java.lang.String getAssistantAssociationId() {
            return this.assistantAssociationId;
        }

        @Override
        public final java.lang.String getAssistantId() {
            return this.assistantId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assistantAssociationArn", om.valueToTree(this.getAssistantAssociationArn()));
            data.set("assistantAssociationId", om.valueToTree(this.getAssistantAssociationId()));
            data.set("assistantId", om.valueToTree(this.getAssistantId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_wisdom.AssistantAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssistantAssociationReference.Jsii$Proxy that = (AssistantAssociationReference.Jsii$Proxy) o;

            if (!assistantAssociationArn.equals(that.assistantAssociationArn)) return false;
            if (!assistantAssociationId.equals(that.assistantAssociationId)) return false;
            return this.assistantId.equals(that.assistantId);
        }

        @Override
        public final int hashCode() {
            int result = this.assistantAssociationArn.hashCode();
            result = 31 * result + (this.assistantAssociationId.hashCode());
            result = 31 * result + (this.assistantId.hashCode());
            return result;
        }
    }
}
