package software.amazon.awscdk.interfaces.workspaces;

/**
 * A reference to a WorkspacesPool resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.workspaces.*;
 * WorkspacesPoolReference workspacesPoolReference = WorkspacesPoolReference.builder()
 *         .poolId("poolId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:04.100Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_workspaces.WorkspacesPoolReference")
@software.amazon.jsii.Jsii.Proxy(WorkspacesPoolReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WorkspacesPoolReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The PoolId of the WorkspacesPool resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPoolId();

    /**
     * @return a {@link Builder} of {@link WorkspacesPoolReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WorkspacesPoolReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WorkspacesPoolReference> {
        java.lang.String poolId;

        /**
         * Sets the value of {@link WorkspacesPoolReference#getPoolId}
         * @param poolId The PoolId of the WorkspacesPool resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder poolId(java.lang.String poolId) {
            this.poolId = poolId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WorkspacesPoolReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WorkspacesPoolReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WorkspacesPoolReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkspacesPoolReference {
        private final java.lang.String poolId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.poolId = software.amazon.jsii.Kernel.get(this, "poolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.poolId = java.util.Objects.requireNonNull(builder.poolId, "poolId is required");
        }

        @Override
        public final java.lang.String getPoolId() {
            return this.poolId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("poolId", om.valueToTree(this.getPoolId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_workspaces.WorkspacesPoolReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WorkspacesPoolReference.Jsii$Proxy that = (WorkspacesPoolReference.Jsii$Proxy) o;

            return this.poolId.equals(that.poolId);
        }

        @Override
        public final int hashCode() {
            int result = this.poolId.hashCode();
            return result;
        }
    }
}
