package software.amazon.awscdk.services.acmpca;

/**
 * Defines a Certificate for ACMPCA.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.acmpca.*;
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V4_1_X_KRAFT)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.tls(TlsAuthProps.builder()
 *                 .certificateAuthorities(List.of(CertificateAuthority.fromCertificateAuthorityArn(this, "CertificateAuthority", "arn:aws:acm-pca:us-west-2:1234567890:certificate-authority/11111111-1111-1111-1111-111111111111")))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:44.008Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CertificateAuthority")
public class CertificateAuthority extends software.amazon.jsii.JsiiObject {

    protected CertificateAuthority(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CertificateAuthority(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Import an existing Certificate given an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param certificateAuthorityArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.acmpca.ICertificateAuthority fromCertificateAuthorityArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String certificateAuthorityArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.acmpca.CertificateAuthority.class, "fromCertificateAuthorityArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.acmpca.ICertificateAuthority.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(certificateAuthorityArn, "certificateAuthorityArn is required") });
    }
}
