package software.amazon.awscdk.services.apigateway;

/**
 * The <code>AWS::ApiGateway::RestApi</code> resource creates a REST API.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_CreateRestApi.html">restapi:create</a> in the <em>Amazon API Gateway REST API Reference</em> .
 * <p>
 * <blockquote>
 * <p>
 * On January 1, 2016, the Swagger Specification was donated to the <a href="https://docs.aws.amazon.com/https://www.openapis.org/">OpenAPI initiative</a> , becoming the foundation of the OpenAPI Specification.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * Object body;
 * Object policy;
 * CfnRestApi cfnRestApi = CfnRestApi.Builder.create(this, "MyCfnRestApi")
 *         .apiKeySourceType("apiKeySourceType")
 *         .binaryMediaTypes(List.of("binaryMediaTypes"))
 *         .body(body)
 *         .bodyS3Location(S3LocationProperty.builder()
 *                 .bucket("bucket")
 *                 .eTag("eTag")
 *                 .key("key")
 *                 .version("version")
 *                 .build())
 *         .cloneFrom("cloneFrom")
 *         .description("description")
 *         .disableExecuteApiEndpoint(false)
 *         .endpointAccessMode("endpointAccessMode")
 *         .endpointConfiguration(EndpointConfigurationProperty.builder()
 *                 .ipAddressType("ipAddressType")
 *                 .types(List.of("types"))
 *                 .vpcEndpointIds(List.of("vpcEndpointIds"))
 *                 .build())
 *         .failOnWarnings(false)
 *         .minimumCompressionSize(123)
 *         .mode("mode")
 *         .name("name")
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .policy(policy)
 *         .securityPolicy("securityPolicy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:44.280Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnRestApi")
public class CfnRestApi extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.apigateway.IRestApiRef, software.amazon.awscdk.ITaggable {

    protected CfnRestApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRestApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnRestApi.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::ApiGateway::RestApi</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRestApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnRestApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::ApiGateway::RestApi</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRestApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Creates a new IRestApiRef from a restApiId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param restApiId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.apigateway.IRestApiRef fromRestApiId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String restApiId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.CfnRestApi.class, "fromRestApiId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.apigateway.IRestApiRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(restApiId, "restApiId is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The string identifier of the associated RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRestApiId() {
        return software.amazon.jsii.Kernel.get(this, "attrRestApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The root resource ID for a <code>RestApi</code> resource, such as <code>a0bc123d4e</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRootResourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrRootResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a RestApi resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.apigateway.RestApiReference getRestApiRef() {
        return software.amazon.jsii.Kernel.get(this, "restApiRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.apigateway.RestApiReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The source of the API key for metering requests according to a usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApiKeySourceType() {
        return software.amazon.jsii.Kernel.get(this, "apiKeySourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The source of the API key for metering requests according to a usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiKeySourceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "apiKeySourceType", value);
    }

    /**
     * The list of binary media types supported by the RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBinaryMediaTypes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "binaryMediaTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of binary media types supported by the RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBinaryMediaTypes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "binaryMediaTypes", value);
    }

    /**
     * An OpenAPI specification that defines a set of RESTful APIs in JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBody() {
        return software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An OpenAPI specification that defines a set of RESTful APIs in JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBody(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "body", value);
    }

    /**
     * The Amazon Simple Storage Service (Amazon S3) location that points to an OpenAPI file, which defines a set of RESTful APIs in JSON or YAML format.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.apigateway.CfnRestApi.S3LocationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBodyS3Location() {
        return software.amazon.jsii.Kernel.get(this, "bodyS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon Simple Storage Service (Amazon S3) location that points to an OpenAPI file, which defines a set of RESTful APIs in JSON or YAML format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBodyS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bodyS3Location", value);
    }

    /**
     * The Amazon Simple Storage Service (Amazon S3) location that points to an OpenAPI file, which defines a set of RESTful APIs in JSON or YAML format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBodyS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnRestApi.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "bodyS3Location", value);
    }

    /**
     * The ID of the RestApi that you want to clone from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloneFrom() {
        return software.amazon.jsii.Kernel.get(this, "cloneFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the RestApi that you want to clone from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloneFrom(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cloneFrom", value);
    }

    /**
     * The description of the RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDisableExecuteApiEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "disableExecuteApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableExecuteApiEndpoint(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "disableExecuteApiEndpoint", value);
    }

    /**
     * Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableExecuteApiEndpoint(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "disableExecuteApiEndpoint", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointAccessMode() {
        return software.amazon.jsii.Kernel.get(this, "endpointAccessMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointAccessMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointAccessMode", value);
    }

    /**
     * A list of the endpoint types and IP address types of the API.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.apigateway.CfnRestApi.EndpointConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEndpointConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "endpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of the endpoint types and IP address types of the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "endpointConfiguration", value);
    }

    /**
     * A list of the endpoint types and IP address types of the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnRestApi.EndpointConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "endpointConfiguration", value);
    }

    /**
     * A query parameter to indicate whether to rollback the API update ( <code>true</code> ) or not ( <code>false</code> ) when a warning is encountered.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFailOnWarnings() {
        return software.amazon.jsii.Kernel.get(this, "failOnWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A query parameter to indicate whether to rollback the API update ( <code>true</code> ) or not ( <code>false</code> ) when a warning is encountered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailOnWarnings(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "failOnWarnings", value);
    }

    /**
     * A query parameter to indicate whether to rollback the API update ( <code>true</code> ) or not ( <code>false</code> ) when a warning is encountered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailOnWarnings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "failOnWarnings", value);
    }

    /**
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinimumCompressionSize() {
        return software.amazon.jsii.Kernel.get(this, "minimumCompressionSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinimumCompressionSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minimumCompressionSize", value);
    }

    /**
     * This property applies only when you use OpenAPI to define your REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This property applies only when you use OpenAPI to define your REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "mode", value);
    }

    /**
     * The name of the RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Custom header parameters as part of the request.
     * <p>
     * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Custom header parameters as part of the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * Custom header parameters as part of the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * A policy document that contains the permissions for the <code>RestApi</code> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPolicy() {
        return software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A policy document that contains the permissions for the <code>RestApi</code> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicy(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "policy", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecurityPolicy() {
        return software.amazon.jsii.Kernel.get(this, "securityPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityPolicy", value);
    }

    /**
     * The key-value map of strings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The key-value map of strings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The <code>EndpointConfiguration</code> property type specifies the endpoint types and IP address types of a REST API.
     * <p>
     * <code>EndpointConfiguration</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html">AWS::ApiGateway::RestApi</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * EndpointConfigurationProperty endpointConfigurationProperty = EndpointConfigurationProperty.builder()
     *         .ipAddressType("ipAddressType")
     *         .types(List.of("types"))
     *         .vpcEndpointIds(List.of("vpcEndpointIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnRestApi.EndpointConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IP address types that can invoke an API (RestApi).
         * <p>
         * Use <code>ipv4</code> to allow only IPv4 addresses to invoke an API, or use <code>dualstack</code> to allow both IPv4 and IPv6 addresses to invoke an API. For the <code>PRIVATE</code> endpoint type, only <code>dualstack</code> is supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-ipaddresstype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
            return null;
        }

        /**
         * A list of endpoint types of an API (RestApi) or its custom domain name (DomainName).
         * <p>
         * For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code> . For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code> . For a private API, the endpoint type is <code>PRIVATE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes.
         * <p>
         * It is only supported for <code>PRIVATE</code> endpoint type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-vpcendpointids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-vpcendpointids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcEndpointIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointConfigurationProperty> {
            java.lang.String ipAddressType;
            java.util.List<java.lang.String> types;
            java.util.List<java.lang.String> vpcEndpointIds;

            /**
             * Sets the value of {@link EndpointConfigurationProperty#getIpAddressType}
             * @param ipAddressType The IP address types that can invoke an API (RestApi).
             *                      Use <code>ipv4</code> to allow only IPv4 addresses to invoke an API, or use <code>dualstack</code> to allow both IPv4 and IPv6 addresses to invoke an API. For the <code>PRIVATE</code> endpoint type, only <code>dualstack</code> is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipAddressType(java.lang.String ipAddressType) {
                this.ipAddressType = ipAddressType;
                return this;
            }

            /**
             * Sets the value of {@link EndpointConfigurationProperty#getTypes}
             * @param types A list of endpoint types of an API (RestApi) or its custom domain name (DomainName).
             *              For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code> . For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code> . For a private API, the endpoint type is <code>PRIVATE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Sets the value of {@link EndpointConfigurationProperty#getVpcEndpointIds}
             * @param vpcEndpointIds A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes.
             *                       It is only supported for <code>PRIVATE</code> endpoint type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpointIds(java.util.List<java.lang.String> vpcEndpointIds) {
                this.vpcEndpointIds = vpcEndpointIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointConfigurationProperty {
            private final java.lang.String ipAddressType;
            private final java.util.List<java.lang.String> types;
            private final java.util.List<java.lang.String> vpcEndpointIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.vpcEndpointIds = software.amazon.jsii.Kernel.get(this, "vpcEndpointIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipAddressType = builder.ipAddressType;
                this.types = builder.types;
                this.vpcEndpointIds = builder.vpcEndpointIds;
            }

            @Override
            public final java.lang.String getIpAddressType() {
                return this.ipAddressType;
            }

            @Override
            public final java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            public final java.util.List<java.lang.String> getVpcEndpointIds() {
                return this.vpcEndpointIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIpAddressType() != null) {
                    data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
                }
                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }
                if (this.getVpcEndpointIds() != null) {
                    data.set("vpcEndpointIds", om.valueToTree(this.getVpcEndpointIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnRestApi.EndpointConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointConfigurationProperty.Jsii$Proxy that = (EndpointConfigurationProperty.Jsii$Proxy) o;

                if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
                if (this.types != null ? !this.types.equals(that.types) : that.types != null) return false;
                return this.vpcEndpointIds != null ? this.vpcEndpointIds.equals(that.vpcEndpointIds) : that.vpcEndpointIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipAddressType != null ? this.ipAddressType.hashCode() : 0;
                result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
                result = 31 * result + (this.vpcEndpointIds != null ? this.vpcEndpointIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>S3Location</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html">AWS::ApiGateway::RestApi</a> resource that specifies the Amazon S3 location of a OpenAPI (formerly Swagger) file that defines a set of RESTful APIs in JSON or YAML.
     * <p>
     * <blockquote>
     * <p>
     * On January 1, 2016, the Swagger Specification was donated to the <a href="https://docs.aws.amazon.com/https://www.openapis.org/">OpenAPI initiative</a> , becoming the foundation of the OpenAPI Specification.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         .eTag("eTag")
     *         .key("key")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnRestApi.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket where the OpenAPI file is stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucket() {
            return null;
        }

        /**
         * The Amazon S3 ETag (a file checksum) of the OpenAPI file.
         * <p>
         * If you don't specify a value, API Gateway skips ETag validation of your OpenAPI file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getETag() {
            return null;
        }

        /**
         * The file name of the OpenAPI file (Amazon S3 object name).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * For versioning-enabled buckets, a specific version of the OpenAPI file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String eTag;
            java.lang.String key;
            java.lang.String version;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket The name of the S3 bucket where the OpenAPI file is stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getETag}
             * @param eTag The Amazon S3 ETag (a file checksum) of the OpenAPI file.
             *             If you don't specify a value, API Gateway skips ETag validation of your OpenAPI file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eTag(java.lang.String eTag) {
                this.eTag = eTag;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key The file name of the OpenAPI file (Amazon S3 object name).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getVersion}
             * @param version For versioning-enabled buckets, a specific version of the OpenAPI file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String eTag;
            private final java.lang.String key;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eTag = software.amazon.jsii.Kernel.get(this, "eTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = builder.bucket;
                this.eTag = builder.eTag;
                this.key = builder.key;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getETag() {
                return this.eTag;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucket() != null) {
                    data.set("bucket", om.valueToTree(this.getBucket()));
                }
                if (this.getETag() != null) {
                    data.set("eTag", om.valueToTree(this.getETag()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnRestApi.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
                if (this.eTag != null ? !this.eTag.equals(that.eTag) : that.eTag != null) return false;
                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket != null ? this.bucket.hashCode() : 0;
                result = 31 * result + (this.eTag != null ? this.eTag.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnRestApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnRestApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigateway.CfnRestApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The source of the API key for metering requests according to a usage plan.
         * <p>
         * Valid values are: <code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. <code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype</a>
         * @param apiKeySourceType The source of the API key for metering requests according to a usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySourceType(final java.lang.String apiKeySourceType) {
            this.props().apiKeySourceType(apiKeySourceType);
            return this;
        }

        /**
         * The list of binary media types supported by the RestApi.
         * <p>
         * By default, the RestApi supports only UTF-8-encoded text payloads.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes</a>
         * @param binaryMediaTypes The list of binary media types supported by the RestApi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryMediaTypes(final java.util.List<java.lang.String> binaryMediaTypes) {
            this.props().binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        /**
         * An OpenAPI specification that defines a set of RESTful APIs in JSON format.
         * <p>
         * For YAML templates, you can also provide the specification in YAML format.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body</a>
         * @param body An OpenAPI specification that defines a set of RESTful APIs in JSON format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder body(final java.lang.Object body) {
            this.props().body(body);
            return this;
        }

        /**
         * The Amazon Simple Storage Service (Amazon S3) location that points to an OpenAPI file, which defines a set of RESTful APIs in JSON or YAML format.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location</a>
         * @param bodyS3Location The Amazon Simple Storage Service (Amazon S3) location that points to an OpenAPI file, which defines a set of RESTful APIs in JSON or YAML format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(final software.amazon.awscdk.IResolvable bodyS3Location) {
            this.props().bodyS3Location(bodyS3Location);
            return this;
        }
        /**
         * The Amazon Simple Storage Service (Amazon S3) location that points to an OpenAPI file, which defines a set of RESTful APIs in JSON or YAML format.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location</a>
         * @param bodyS3Location The Amazon Simple Storage Service (Amazon S3) location that points to an OpenAPI file, which defines a set of RESTful APIs in JSON or YAML format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bodyS3Location(final software.amazon.awscdk.services.apigateway.CfnRestApi.S3LocationProperty bodyS3Location) {
            this.props().bodyS3Location(bodyS3Location);
            return this;
        }

        /**
         * The ID of the RestApi that you want to clone from.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom</a>
         * @param cloneFrom The ID of the RestApi that you want to clone from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneFrom(final java.lang.String cloneFrom) {
            this.props().cloneFrom(cloneFrom);
            return this;
        }

        /**
         * The description of the RestApi.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description</a>
         * @param description The description of the RestApi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
         * <p>
         * By default, clients can invoke your API with the default <code>https://{api_id}.execute-api.{region}.amazonaws.com</code> endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-disableexecuteapiendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-disableexecuteapiendpoint</a>
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(final java.lang.Boolean disableExecuteApiEndpoint) {
            this.props().disableExecuteApiEndpoint(disableExecuteApiEndpoint);
            return this;
        }
        /**
         * Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
         * <p>
         * By default, clients can invoke your API with the default <code>https://{api_id}.execute-api.{region}.amazonaws.com</code> endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-disableexecuteapiendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-disableexecuteapiendpoint</a>
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(final software.amazon.awscdk.IResolvable disableExecuteApiEndpoint) {
            this.props().disableExecuteApiEndpoint(disableExecuteApiEndpoint);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointaccessmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointaccessmode</a>
         * @param endpointAccessMode This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointAccessMode(final java.lang.String endpointAccessMode) {
            this.props().endpointAccessMode(endpointAccessMode);
            return this;
        }

        /**
         * A list of the endpoint types and IP address types of the API.
         * <p>
         * Use this property when creating an API. When importing an existing API, specify the endpoint configuration types using the <code>Parameters</code> property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration</a>
         * @param endpointConfiguration A list of the endpoint types and IP address types of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(final software.amazon.awscdk.IResolvable endpointConfiguration) {
            this.props().endpointConfiguration(endpointConfiguration);
            return this;
        }
        /**
         * A list of the endpoint types and IP address types of the API.
         * <p>
         * Use this property when creating an API. When importing an existing API, specify the endpoint configuration types using the <code>Parameters</code> property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration</a>
         * @param endpointConfiguration A list of the endpoint types and IP address types of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfiguration(final software.amazon.awscdk.services.apigateway.CfnRestApi.EndpointConfigurationProperty endpointConfiguration) {
            this.props().endpointConfiguration(endpointConfiguration);
            return this;
        }

        /**
         * A query parameter to indicate whether to rollback the API update ( <code>true</code> ) or not ( <code>false</code> ) when a warning is encountered.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings</a>
         * @param failOnWarnings A query parameter to indicate whether to rollback the API update ( <code>true</code> ) or not ( <code>false</code> ) when a warning is encountered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final java.lang.Boolean failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }
        /**
         * A query parameter to indicate whether to rollback the API update ( <code>true</code> ) or not ( <code>false</code> ) when a warning is encountered.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings</a>
         * @param failOnWarnings A query parameter to indicate whether to rollback the API update ( <code>true</code> ) or not ( <code>false</code> ) when a warning is encountered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final software.amazon.awscdk.IResolvable failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }

        /**
         * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API.
         * <p>
         * When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize</a>
         * @param minimumCompressionSize A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCompressionSize(final java.lang.Number minimumCompressionSize) {
            this.props().minimumCompressionSize(minimumCompressionSize);
            return this;
        }

        /**
         * This property applies only when you use OpenAPI to define your REST API.
         * <p>
         * The <code>Mode</code> determines how API Gateway handles resource updates.
         * <p>
         * Valid values are <code>overwrite</code> or <code>merge</code> .
         * <p>
         * For <code>overwrite</code> , the new API definition replaces the existing one. The existing API identifier remains unchanged.
         * <p>
         * For <code>merge</code> , the new API definition is merged with the existing API.
         * <p>
         * If you don't specify this property, a default value is chosen. For REST APIs created before March 29, 2021, the default is <code>overwrite</code> . For REST APIs created after March 29, 2021, the new API definition takes precedence, but any container types such as endpoint configurations and binary media types are merged with the existing API.
         * <p>
         * Use the default mode to define top-level <code>RestApi</code> properties in addition to using OpenAPI. Generally, it's preferred to use API Gateway's OpenAPI extensions to model these properties.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-mode</a>
         * @param mode This property applies only when you use OpenAPI to define your REST API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(final java.lang.String mode) {
            this.props().mode(mode);
            return this;
        }

        /**
         * The name of the RestApi.
         * <p>
         * A name is required if the REST API is not based on an OpenAPI specification.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name</a>
         * @param name The name of the RestApi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * Custom header parameters as part of the request.
         * <p>
         * For example, to exclude DocumentationParts from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters</a>
         * @param parameters Custom header parameters as part of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props().parameters(parameters);
            return this;
        }
        /**
         * Custom header parameters as part of the request.
         * <p>
         * For example, to exclude DocumentationParts from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters</a>
         * @param parameters Custom header parameters as part of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.IResolvable parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * A policy document that contains the permissions for the <code>RestApi</code> resource.
         * <p>
         * To set the ARN for the policy, use the <code>!Join</code> intrinsic function with <code>""</code> as delimiter and values of <code>"execute-api:/"</code> and <code>"*"</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy</a>
         * @param policy A policy document that contains the permissions for the <code>RestApi</code> resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final java.lang.Object policy) {
            this.props().policy(policy);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-securitypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-securitypolicy</a>
         * @param securityPolicy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicy(final java.lang.String securityPolicy) {
            this.props().securityPolicy(securityPolicy);
            return this;
        }

        /**
         * The key-value map of strings.
         * <p>
         * The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code> . The tag value can be up to 256 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-tags</a>
         * @param tags The key-value map of strings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnRestApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnRestApi build() {
            return new software.amazon.awscdk.services.apigateway.CfnRestApi(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.CfnRestApiProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigateway.CfnRestApiProps.Builder();
            }
            return this.props;
        }
    }
}
