package software.amazon.awscdk.services.apigateway;

/**
 * The Mode that determines how API Gateway handles resource updates when importing an OpenAPI definition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SpecRestApi api = SpecRestApi.Builder.create(this, "books-api")
 *         .apiDefinition(ApiDefinition.fromAsset("path-to-file.json"))
 *         .mode(RestApiMode.MERGE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:44.412Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.RestApiMode")
public enum RestApiMode {
    /**
     * The new API definition replaces the existing one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OVERWRITE,
    /**
     * The new API definition is merged with the existing API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MERGE,
}
