package software.amazon.awscdk.services.apigatewayv2;

/**
 * The <code>AWS::ApiGatewayV2::DomainName</code> resource specifies a custom domain name for your API in Amazon API Gateway (API Gateway).
 * <p>
 * You can use a custom domain name to provide a URL that's more intuitive and easier to recall. For more information about using custom domain names, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Set up Custom Domain Name for an API in API Gateway</a> in the <em>API Gateway Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * CfnDomainName cfnDomainName = CfnDomainName.Builder.create(this, "MyCfnDomainName")
 *         .domainName("domainName")
 *         // the properties below are optional
 *         .domainNameConfigurations(List.of(DomainNameConfigurationProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .certificateName("certificateName")
 *                 .endpointType("endpointType")
 *                 .ipAddressType("ipAddressType")
 *                 .ownershipVerificationCertificateArn("ownershipVerificationCertificateArn")
 *                 .securityPolicy("securityPolicy")
 *                 .build()))
 *         .mutualTlsAuthentication(MutualTlsAuthenticationProperty.builder()
 *                 .truststoreUri("truststoreUri")
 *                 .truststoreVersion("truststoreVersion")
 *                 .build())
 *         .routingMode("routingMode")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:44.491Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnDomainName")
public class CfnDomainName extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.apigatewayv2.IDomainNameRef, software.amazon.awscdk.ITaggable {

    protected CfnDomainName(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomainName(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.CfnDomainName.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::ApiGatewayV2::DomainName</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomainName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.CfnDomainNameProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Represents an Amazon Resource Name (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainNameArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainNameArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name associated with the regional endpoint for this custom domain name.
     * <p>
     * You set up this association by adding a DNS record that points the custom domain name to this regional domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRegionalDomainName() {
        return software.amazon.jsii.Kernel.get(this, "attrRegionalDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRegionalHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "attrRegionalHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a DomainName resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.apigatewayv2.DomainNameReference getDomainNameRef() {
        return software.amazon.jsii.Kernel.get(this, "domainNameRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.apigatewayv2.DomainNameReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The custom domain name for your API in Amazon API Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The custom domain name for your API in Amazon API Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * The domain name configurations.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.apigatewayv2.CfnDomainName.DomainNameConfigurationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDomainNameConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "domainNameConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The domain name configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainNameConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "domainNameConfigurations", value);
    }

    /**
     * The domain name configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainNameConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.apigatewayv2.CfnDomainName.DomainNameConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.apigatewayv2.CfnDomainName.DomainNameConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "domainNameConfigurations", value);
    }

    /**
     * The mutual TLS authentication configuration for a custom domain name.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.apigatewayv2.CfnDomainName.MutualTlsAuthenticationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMutualTlsAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "mutualTlsAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The mutual TLS authentication configuration for a custom domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMutualTlsAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mutualTlsAuthentication", value);
    }

    /**
     * The mutual TLS authentication configuration for a custom domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMutualTlsAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.CfnDomainName.MutualTlsAuthenticationProperty value) {
        software.amazon.jsii.Kernel.set(this, "mutualTlsAuthentication", value);
    }

    /**
     * The routing mode API Gateway uses to route traffic to your APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoutingMode() {
        return software.amazon.jsii.Kernel.get(this, "routingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The routing mode API Gateway uses to route traffic to your APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoutingMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "routingMode", value);
    }

    /**
     * The collection of tags associated with a domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The collection of tags associated with a domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The <code>DomainNameConfiguration</code> property type specifies the configuration for an API's domain name.
     * <p>
     * <code>DomainNameConfiguration</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html">AWS::ApiGatewayV2::DomainName</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigatewayv2.*;
     * DomainNameConfigurationProperty domainNameConfigurationProperty = DomainNameConfigurationProperty.builder()
     *         .certificateArn("certificateArn")
     *         .certificateName("certificateName")
     *         .endpointType("endpointType")
     *         .ipAddressType("ipAddressType")
     *         .ownershipVerificationCertificateArn("ownershipVerificationCertificateArn")
     *         .securityPolicy("securityPolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnDomainName.DomainNameConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainNameConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainNameConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An AWS -managed certificate that will be used by the edge-optimized endpoint for this domain name.
         * <p>
         * AWS Certificate Manager is the only supported source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-certificatename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-certificatename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateName() {
            return null;
        }

        /**
         * The endpoint type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-endpointtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-endpointtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointType() {
            return null;
        }

        /**
         * The IP address types that can invoke the domain name.
         * <p>
         * Use <code>ipv4</code> to allow only IPv4 addresses to invoke your domain name, or use <code>dualstack</code> to allow both IPv4 and IPv6 addresses to invoke your domain name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-ipaddresstype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
            return null;
        }

        /**
         * The Amazon resource name (ARN) for the public certificate issued by Certificate Manager .
         * <p>
         * This ARN is used to validate custom domain ownership. It's required only if you configure mutual TLS and use either an ACM-imported or a private CA certificate ARN as the regionalCertificateArn.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-ownershipverificationcertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-ownershipverificationcertificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOwnershipVerificationCertificateArn() {
            return null;
        }

        /**
         * The Transport Layer Security (TLS) version of the security policy for this domain name.
         * <p>
         * The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-securitypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-securitypolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DomainNameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainNameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainNameConfigurationProperty> {
            java.lang.String certificateArn;
            java.lang.String certificateName;
            java.lang.String endpointType;
            java.lang.String ipAddressType;
            java.lang.String ownershipVerificationCertificateArn;
            java.lang.String securityPolicy;

            /**
             * Sets the value of {@link DomainNameConfigurationProperty#getCertificateArn}
             * @param certificateArn An AWS -managed certificate that will be used by the edge-optimized endpoint for this domain name.
             *                       AWS Certificate Manager is the only supported source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of {@link DomainNameConfigurationProperty#getCertificateName}
             * @param certificateName The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateName(java.lang.String certificateName) {
                this.certificateName = certificateName;
                return this;
            }

            /**
             * Sets the value of {@link DomainNameConfigurationProperty#getEndpointType}
             * @param endpointType The endpoint type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointType(java.lang.String endpointType) {
                this.endpointType = endpointType;
                return this;
            }

            /**
             * Sets the value of {@link DomainNameConfigurationProperty#getIpAddressType}
             * @param ipAddressType The IP address types that can invoke the domain name.
             *                      Use <code>ipv4</code> to allow only IPv4 addresses to invoke your domain name, or use <code>dualstack</code> to allow both IPv4 and IPv6 addresses to invoke your domain name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipAddressType(java.lang.String ipAddressType) {
                this.ipAddressType = ipAddressType;
                return this;
            }

            /**
             * Sets the value of {@link DomainNameConfigurationProperty#getOwnershipVerificationCertificateArn}
             * @param ownershipVerificationCertificateArn The Amazon resource name (ARN) for the public certificate issued by Certificate Manager .
             *                                            This ARN is used to validate custom domain ownership. It's required only if you configure mutual TLS and use either an ACM-imported or a private CA certificate ARN as the regionalCertificateArn.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ownershipVerificationCertificateArn(java.lang.String ownershipVerificationCertificateArn) {
                this.ownershipVerificationCertificateArn = ownershipVerificationCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link DomainNameConfigurationProperty#getSecurityPolicy}
             * @param securityPolicy The Transport Layer Security (TLS) version of the security policy for this domain name.
             *                       The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityPolicy(java.lang.String securityPolicy) {
                this.securityPolicy = securityPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainNameConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainNameConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainNameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainNameConfigurationProperty {
            private final java.lang.String certificateArn;
            private final java.lang.String certificateName;
            private final java.lang.String endpointType;
            private final java.lang.String ipAddressType;
            private final java.lang.String ownershipVerificationCertificateArn;
            private final java.lang.String securityPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateName = software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpointType = software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ownershipVerificationCertificateArn = software.amazon.jsii.Kernel.get(this, "ownershipVerificationCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityPolicy = software.amazon.jsii.Kernel.get(this, "securityPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = builder.certificateArn;
                this.certificateName = builder.certificateName;
                this.endpointType = builder.endpointType;
                this.ipAddressType = builder.ipAddressType;
                this.ownershipVerificationCertificateArn = builder.ownershipVerificationCertificateArn;
                this.securityPolicy = builder.securityPolicy;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public final java.lang.String getCertificateName() {
                return this.certificateName;
            }

            @Override
            public final java.lang.String getEndpointType() {
                return this.endpointType;
            }

            @Override
            public final java.lang.String getIpAddressType() {
                return this.ipAddressType;
            }

            @Override
            public final java.lang.String getOwnershipVerificationCertificateArn() {
                return this.ownershipVerificationCertificateArn;
            }

            @Override
            public final java.lang.String getSecurityPolicy() {
                return this.securityPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }
                if (this.getCertificateName() != null) {
                    data.set("certificateName", om.valueToTree(this.getCertificateName()));
                }
                if (this.getEndpointType() != null) {
                    data.set("endpointType", om.valueToTree(this.getEndpointType()));
                }
                if (this.getIpAddressType() != null) {
                    data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
                }
                if (this.getOwnershipVerificationCertificateArn() != null) {
                    data.set("ownershipVerificationCertificateArn", om.valueToTree(this.getOwnershipVerificationCertificateArn()));
                }
                if (this.getSecurityPolicy() != null) {
                    data.set("securityPolicy", om.valueToTree(this.getSecurityPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnDomainName.DomainNameConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainNameConfigurationProperty.Jsii$Proxy that = (DomainNameConfigurationProperty.Jsii$Proxy) o;

                if (this.certificateArn != null ? !this.certificateArn.equals(that.certificateArn) : that.certificateArn != null) return false;
                if (this.certificateName != null ? !this.certificateName.equals(that.certificateName) : that.certificateName != null) return false;
                if (this.endpointType != null ? !this.endpointType.equals(that.endpointType) : that.endpointType != null) return false;
                if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
                if (this.ownershipVerificationCertificateArn != null ? !this.ownershipVerificationCertificateArn.equals(that.ownershipVerificationCertificateArn) : that.ownershipVerificationCertificateArn != null) return false;
                return this.securityPolicy != null ? this.securityPolicy.equals(that.securityPolicy) : that.securityPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateArn != null ? this.certificateArn.hashCode() : 0;
                result = 31 * result + (this.certificateName != null ? this.certificateName.hashCode() : 0);
                result = 31 * result + (this.endpointType != null ? this.endpointType.hashCode() : 0);
                result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
                result = 31 * result + (this.ownershipVerificationCertificateArn != null ? this.ownershipVerificationCertificateArn.hashCode() : 0);
                result = 31 * result + (this.securityPolicy != null ? this.securityPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * If specified, API Gateway performs two-way authentication between the client and the server.
     * <p>
     * Clients must present a trusted certificate to access your API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigatewayv2.*;
     * MutualTlsAuthenticationProperty mutualTlsAuthenticationProperty = MutualTlsAuthenticationProperty.builder()
     *         .truststoreUri("truststoreUri")
     *         .truststoreVersion("truststoreVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnDomainName.MutualTlsAuthenticationProperty")
    @software.amazon.jsii.Jsii.Proxy(MutualTlsAuthenticationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MutualTlsAuthenticationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, <code>s3:// bucket-name / key-name</code> .
         * <p>
         * The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html#cfn-apigatewayv2-domainname-mutualtlsauthentication-truststoreuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html#cfn-apigatewayv2-domainname-mutualtlsauthentication-truststoreuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTruststoreUri() {
            return null;
        }

        /**
         * The version of the S3 object that contains your truststore.
         * <p>
         * To specify a version, you must have versioning enabled for the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html#cfn-apigatewayv2-domainname-mutualtlsauthentication-truststoreversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html#cfn-apigatewayv2-domainname-mutualtlsauthentication-truststoreversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTruststoreVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MutualTlsAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MutualTlsAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MutualTlsAuthenticationProperty> {
            java.lang.String truststoreUri;
            java.lang.String truststoreVersion;

            /**
             * Sets the value of {@link MutualTlsAuthenticationProperty#getTruststoreUri}
             * @param truststoreUri An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, <code>s3:// bucket-name / key-name</code> .
             *                      The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder truststoreUri(java.lang.String truststoreUri) {
                this.truststoreUri = truststoreUri;
                return this;
            }

            /**
             * Sets the value of {@link MutualTlsAuthenticationProperty#getTruststoreVersion}
             * @param truststoreVersion The version of the S3 object that contains your truststore.
             *                          To specify a version, you must have versioning enabled for the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder truststoreVersion(java.lang.String truststoreVersion) {
                this.truststoreVersion = truststoreVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MutualTlsAuthenticationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MutualTlsAuthenticationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MutualTlsAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MutualTlsAuthenticationProperty {
            private final java.lang.String truststoreUri;
            private final java.lang.String truststoreVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.truststoreUri = software.amazon.jsii.Kernel.get(this, "truststoreUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.truststoreVersion = software.amazon.jsii.Kernel.get(this, "truststoreVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.truststoreUri = builder.truststoreUri;
                this.truststoreVersion = builder.truststoreVersion;
            }

            @Override
            public final java.lang.String getTruststoreUri() {
                return this.truststoreUri;
            }

            @Override
            public final java.lang.String getTruststoreVersion() {
                return this.truststoreVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTruststoreUri() != null) {
                    data.set("truststoreUri", om.valueToTree(this.getTruststoreUri()));
                }
                if (this.getTruststoreVersion() != null) {
                    data.set("truststoreVersion", om.valueToTree(this.getTruststoreVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnDomainName.MutualTlsAuthenticationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MutualTlsAuthenticationProperty.Jsii$Proxy that = (MutualTlsAuthenticationProperty.Jsii$Proxy) o;

                if (this.truststoreUri != null ? !this.truststoreUri.equals(that.truststoreUri) : that.truststoreUri != null) return false;
                return this.truststoreVersion != null ? this.truststoreVersion.equals(that.truststoreVersion) : that.truststoreVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.truststoreUri != null ? this.truststoreUri.hashCode() : 0;
                result = 31 * result + (this.truststoreVersion != null ? this.truststoreVersion.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.CfnDomainName}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.CfnDomainName> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.CfnDomainNameProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.CfnDomainNameProps.Builder();
        }

        /**
         * The custom domain name for your API in Amazon API Gateway.
         * <p>
         * Uppercase letters and the underscore ( <code>_</code> ) character are not supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainname</a>
         * @param domainName The custom domain name for your API in Amazon API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * The domain name configurations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations</a>
         * @param domainNameConfigurations The domain name configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNameConfigurations(final software.amazon.awscdk.IResolvable domainNameConfigurations) {
            this.props.domainNameConfigurations(domainNameConfigurations);
            return this;
        }
        /**
         * The domain name configurations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations</a>
         * @param domainNameConfigurations The domain name configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNameConfigurations(final java.util.List<? extends java.lang.Object> domainNameConfigurations) {
            this.props.domainNameConfigurations(domainNameConfigurations);
            return this;
        }

        /**
         * The mutual TLS authentication configuration for a custom domain name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-mutualtlsauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-mutualtlsauthentication</a>
         * @param mutualTlsAuthentication The mutual TLS authentication configuration for a custom domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualTlsAuthentication(final software.amazon.awscdk.IResolvable mutualTlsAuthentication) {
            this.props.mutualTlsAuthentication(mutualTlsAuthentication);
            return this;
        }
        /**
         * The mutual TLS authentication configuration for a custom domain name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-mutualtlsauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-mutualtlsauthentication</a>
         * @param mutualTlsAuthentication The mutual TLS authentication configuration for a custom domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualTlsAuthentication(final software.amazon.awscdk.services.apigatewayv2.CfnDomainName.MutualTlsAuthenticationProperty mutualTlsAuthentication) {
            this.props.mutualTlsAuthentication(mutualTlsAuthentication);
            return this;
        }

        /**
         * The routing mode API Gateway uses to route traffic to your APIs.
         * <p>
         * Default: - "API_MAPPING_ONLY"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-routingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-routingmode</a>
         * @param routingMode The routing mode API Gateway uses to route traffic to your APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingMode(final java.lang.String routingMode) {
            this.props.routingMode(routingMode);
            return this;
        }

        /**
         * The collection of tags associated with a domain name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-tags</a>
         * @param tags The collection of tags associated with a domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.CfnDomainName}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.CfnDomainName build() {
            return new software.amazon.awscdk.services.apigatewayv2.CfnDomainName(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
