package software.amazon.awscdk.services.apigatewayv2;

/**
 * The integration properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpApi httpApi;
 * IntegrationCredentials integrationCredentials;
 * ParameterMapping parameterMapping;
 * PayloadFormatVersion payloadFormatVersion;
 * HttpIntegrationProps httpIntegrationProps = HttpIntegrationProps.builder()
 *         .httpApi(httpApi)
 *         .integrationType(HttpIntegrationType.HTTP_PROXY)
 *         // the properties below are optional
 *         .connectionId("connectionId")
 *         .connectionType(HttpConnectionType.VPC_LINK)
 *         .credentials(integrationCredentials)
 *         .integrationSubtype(HttpIntegrationSubtype.EVENTBRIDGE_PUT_EVENTS)
 *         .integrationUri("integrationUri")
 *         .method(HttpMethod.ANY)
 *         .parameterMapping(parameterMapping)
 *         .payloadFormatVersion(payloadFormatVersion)
 *         .secureServerName("secureServerName")
 *         .timeout(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:44.558Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(HttpIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The HTTP API to which this integration should be bound.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IHttpApi getHttpApi();

    /**
     * Integration type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType getIntegrationType();

    /**
     * The ID of the VPC link for a private integration.
     * <p>
     * Supported only for HTTP APIs.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionId() {
        return null;
    }

    /**
     * The type of the network connection to the integration endpoint.
     * <p>
     * Default: HttpConnectionType.INTERNET
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpConnectionType getConnectionType() {
        return null;
    }

    /**
     * The credentials with which to invoke the integration.
     * <p>
     * Default: - no credentials, use resource-based permissions on supported AWS services
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials getCredentials() {
        return null;
    }

    /**
     * Integration subtype.
     * <p>
     * Used for AWS Service integrations, specifies the target of the integration.
     * <p>
     * Default: - none, required if no `integrationUri` is defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype getIntegrationSubtype() {
        return null;
    }

    /**
     * Integration URI.
     * <p>
     * This will be the function ARN in the case of <code>HttpIntegrationType.AWS_PROXY</code>,
     * or HTTP URL in the case of <code>HttpIntegrationType.HTTP_PROXY</code>.
     * <p>
     * Default: - none, required if no `integrationSubtype` is defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationUri() {
        return null;
    }

    /**
     * The HTTP method to use when calling the underlying HTTP proxy.
     * <p>
     * Default: - none. required if the integration type is `HttpIntegrationType.HTTP_PROXY`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpMethod getMethod() {
        return null;
    }

    /**
     * Specifies how to transform HTTP requests before sending them to the backend.
     * <p>
     * Default: undefined requests are sent to the backend unmodified
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
        return null;
    }

    /**
     * The version of the payload format.
     * <p>
     * Default: - defaults to latest in the case of HttpIntegrationType.AWS_PROXY`, irrelevant otherwise.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion getPayloadFormatVersion() {
        return null;
    }

    /**
     * Specifies the TLS configuration for a private integration.
     * <p>
     * Default: undefined private integration traffic will use HTTP protocol
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecureServerName() {
        return null;
    }

    /**
     * The maximum amount of time an integration will run before it returns without a response.
     * <p>
     * Must be between 50 milliseconds and 29 seconds.
     * <p>
     * Default: Duration.seconds(29)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpIntegrationProps> {
        software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi;
        software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType integrationType;
        java.lang.String connectionId;
        software.amazon.awscdk.services.apigatewayv2.HttpConnectionType connectionType;
        software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials credentials;
        software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype integrationSubtype;
        java.lang.String integrationUri;
        software.amazon.awscdk.services.apigatewayv2.HttpMethod method;
        software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion payloadFormatVersion;
        java.lang.String secureServerName;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link HttpIntegrationProps#getHttpApi}
         * @param httpApi The HTTP API to which this integration should be bound. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpApi(software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi) {
            this.httpApi = httpApi;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getIntegrationType}
         * @param integrationType Integration type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationType(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getConnectionId}
         * @param connectionId The ID of the VPC link for a private integration.
         *                     Supported only for HTTP APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionId(java.lang.String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getConnectionType}
         * @param connectionType The type of the network connection to the integration endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(software.amazon.awscdk.services.apigatewayv2.HttpConnectionType connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getCredentials}
         * @param credentials The credentials with which to invoke the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getIntegrationSubtype}
         * @param integrationSubtype Integration subtype.
         *                           Used for AWS Service integrations, specifies the target of the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationSubtype(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype integrationSubtype) {
            this.integrationSubtype = integrationSubtype;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getIntegrationUri}
         * @param integrationUri Integration URI.
         *                       This will be the function ARN in the case of <code>HttpIntegrationType.AWS_PROXY</code>,
         *                       or HTTP URL in the case of <code>HttpIntegrationType.HTTP_PROXY</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationUri(java.lang.String integrationUri) {
            this.integrationUri = integrationUri;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getMethod}
         * @param method The HTTP method to use when calling the underlying HTTP proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.apigatewayv2.HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getParameterMapping}
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMapping(software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.parameterMapping = parameterMapping;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getPayloadFormatVersion}
         * @param payloadFormatVersion The version of the payload format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payloadFormatVersion(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getSecureServerName}
         * @param secureServerName Specifies the TLS configuration for a private integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secureServerName(java.lang.String secureServerName) {
            this.secureServerName = secureServerName;
            return this;
        }

        /**
         * Sets the value of {@link HttpIntegrationProps#getTimeout}
         * @param timeout The maximum amount of time an integration will run before it returns without a response.
         *                Must be between 50 milliseconds and 29 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpIntegrationProps {
        private final software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi;
        private final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType integrationType;
        private final java.lang.String connectionId;
        private final software.amazon.awscdk.services.apigatewayv2.HttpConnectionType connectionType;
        private final software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials credentials;
        private final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype integrationSubtype;
        private final java.lang.String integrationUri;
        private final software.amazon.awscdk.services.apigatewayv2.HttpMethod method;
        private final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        private final software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion payloadFormatVersion;
        private final java.lang.String secureServerName;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpApi = software.amazon.jsii.Kernel.get(this, "httpApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpApi.class));
            this.integrationType = software.amazon.jsii.Kernel.get(this, "integrationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType.class));
            this.connectionId = software.amazon.jsii.Kernel.get(this, "connectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpConnectionType.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials.class));
            this.integrationSubtype = software.amazon.jsii.Kernel.get(this, "integrationSubtype", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype.class));
            this.integrationUri = software.amazon.jsii.Kernel.get(this, "integrationUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpMethod.class));
            this.parameterMapping = software.amazon.jsii.Kernel.get(this, "parameterMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class));
            this.payloadFormatVersion = software.amazon.jsii.Kernel.get(this, "payloadFormatVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion.class));
            this.secureServerName = software.amazon.jsii.Kernel.get(this, "secureServerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpApi = java.util.Objects.requireNonNull(builder.httpApi, "httpApi is required");
            this.integrationType = java.util.Objects.requireNonNull(builder.integrationType, "integrationType is required");
            this.connectionId = builder.connectionId;
            this.connectionType = builder.connectionType;
            this.credentials = builder.credentials;
            this.integrationSubtype = builder.integrationSubtype;
            this.integrationUri = builder.integrationUri;
            this.method = builder.method;
            this.parameterMapping = builder.parameterMapping;
            this.payloadFormatVersion = builder.payloadFormatVersion;
            this.secureServerName = builder.secureServerName;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IHttpApi getHttpApi() {
            return this.httpApi;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationType getIntegrationType() {
            return this.integrationType;
        }

        @Override
        public final java.lang.String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpConnectionType getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IntegrationCredentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype getIntegrationSubtype() {
            return this.integrationSubtype;
        }

        @Override
        public final java.lang.String getIntegrationUri() {
            return this.integrationUri;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
            return this.parameterMapping;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.PayloadFormatVersion getPayloadFormatVersion() {
            return this.payloadFormatVersion;
        }

        @Override
        public final java.lang.String getSecureServerName() {
            return this.secureServerName;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpApi", om.valueToTree(this.getHttpApi()));
            data.set("integrationType", om.valueToTree(this.getIntegrationType()));
            if (this.getConnectionId() != null) {
                data.set("connectionId", om.valueToTree(this.getConnectionId()));
            }
            if (this.getConnectionType() != null) {
                data.set("connectionType", om.valueToTree(this.getConnectionType()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getIntegrationSubtype() != null) {
                data.set("integrationSubtype", om.valueToTree(this.getIntegrationSubtype()));
            }
            if (this.getIntegrationUri() != null) {
                data.set("integrationUri", om.valueToTree(this.getIntegrationUri()));
            }
            if (this.getMethod() != null) {
                data.set("method", om.valueToTree(this.getMethod()));
            }
            if (this.getParameterMapping() != null) {
                data.set("parameterMapping", om.valueToTree(this.getParameterMapping()));
            }
            if (this.getPayloadFormatVersion() != null) {
                data.set("payloadFormatVersion", om.valueToTree(this.getPayloadFormatVersion()));
            }
            if (this.getSecureServerName() != null) {
                data.set("secureServerName", om.valueToTree(this.getSecureServerName()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.HttpIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpIntegrationProps.Jsii$Proxy that = (HttpIntegrationProps.Jsii$Proxy) o;

            if (!httpApi.equals(that.httpApi)) return false;
            if (!integrationType.equals(that.integrationType)) return false;
            if (this.connectionId != null ? !this.connectionId.equals(that.connectionId) : that.connectionId != null) return false;
            if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.integrationSubtype != null ? !this.integrationSubtype.equals(that.integrationSubtype) : that.integrationSubtype != null) return false;
            if (this.integrationUri != null ? !this.integrationUri.equals(that.integrationUri) : that.integrationUri != null) return false;
            if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
            if (this.parameterMapping != null ? !this.parameterMapping.equals(that.parameterMapping) : that.parameterMapping != null) return false;
            if (this.payloadFormatVersion != null ? !this.payloadFormatVersion.equals(that.payloadFormatVersion) : that.payloadFormatVersion != null) return false;
            if (this.secureServerName != null ? !this.secureServerName.equals(that.secureServerName) : that.secureServerName != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpApi.hashCode();
            result = 31 * result + (this.integrationType.hashCode());
            result = 31 * result + (this.connectionId != null ? this.connectionId.hashCode() : 0);
            result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.integrationSubtype != null ? this.integrationSubtype.hashCode() : 0);
            result = 31 * result + (this.integrationUri != null ? this.integrationUri.hashCode() : 0);
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            result = 31 * result + (this.parameterMapping != null ? this.parameterMapping.hashCode() : 0);
            result = 31 * result + (this.payloadFormatVersion != null ? this.payloadFormatVersion.hashCode() : 0);
            result = 31 * result + (this.secureServerName != null ? this.secureServerName.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
