package software.amazon.awscdk.services.apigatewayv2;

/**
 * Use CloudWatch Logs as a custom access log destination for API Gateway.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigateway.*;
 * import software.amazon.awscdk.services.logs.*;
 * HttpApi api;
 * LogGroup logGroup;
 * HttpStage stage = HttpStage.Builder.create(this, "Stage")
 *         .httpApi(api)
 *         .accessLogSettings(Map.of(
 *                 "destination", new LogGroupLogDestination(logGroup),
 *                 "format", AccessLogFormat.clf()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:44.599Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.LogGroupLogDestination")
public class LogGroupLogDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.IAccessLogDestination {

    protected LogGroupLogDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogGroupLogDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param logGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LogGroupLogDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup logGroup) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(logGroup, "logGroup is required") });
    }

    /**
     * Binds this destination to the CloudWatch Logs.
     * <p>
     * @param _stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.AccessLogDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IStage _stage) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.AccessLogDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_stage, "_stage is required") });
    }
}
