package software.amazon.awscdk.services.appconfig;

/**
 * Use an Amazon SQS queue as an event destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Queue queue;
 * Extension.Builder.create(this, "MyExtension")
 *         .actions(List.of(
 *             Action.Builder.create()
 *                     .actionPoints(List.of(ActionPoint.ON_DEPLOYMENT_START))
 *                     .eventDestination(new SqsDestination(queue))
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:44.771Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.SqsDestination")
public class SqsDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.appconfig.IEventDestination {

    protected SqsDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * The URI of the extension event destination.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExtensionUri() {
        return software.amazon.jsii.Kernel.get(this, "extensionUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the extension event destination.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.SourceType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.SourceType.class));
    }

    /**
     * The IAM policy document to invoke the event destination.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getPolicyDocument() {
        return software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }
}
