package software.amazon.awscdk.services.applicationautoscaling;

/**
 * The <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> resource defines a scaling policy that Application Auto Scaling uses to adjust the capacity of a scalable target.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html">Target tracking scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html">Step scaling policies</a> in the <em>Application Auto Scaling User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * CfnScalingPolicy cfnScalingPolicy = CfnScalingPolicy.Builder.create(this, "MyCfnScalingPolicy")
 *         .policyName("policyName")
 *         .policyType("policyType")
 *         // the properties below are optional
 *         .predictiveScalingPolicyConfiguration(PredictiveScalingPolicyConfigurationProperty.builder()
 *                 .metricSpecifications(List.of(PredictiveScalingMetricSpecificationProperty.builder()
 *                         .targetValue(123)
 *                         // the properties below are optional
 *                         .customizedCapacityMetricSpecification(PredictiveScalingCustomizedCapacityMetricProperty.builder()
 *                                 .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
 *                                         .expression("expression")
 *                                         .id("id")
 *                                         .label("label")
 *                                         .metricStat(PredictiveScalingMetricStatProperty.builder()
 *                                                 .metric(PredictiveScalingMetricProperty.builder()
 *                                                         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         .build())
 *                                                 .stat("stat")
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .customizedLoadMetricSpecification(PredictiveScalingCustomizedLoadMetricProperty.builder()
 *                                 .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
 *                                         .expression("expression")
 *                                         .id("id")
 *                                         .label("label")
 *                                         .metricStat(PredictiveScalingMetricStatProperty.builder()
 *                                                 .metric(PredictiveScalingMetricProperty.builder()
 *                                                         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         .build())
 *                                                 .stat("stat")
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .customizedScalingMetricSpecification(PredictiveScalingCustomizedScalingMetricProperty.builder()
 *                                 .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
 *                                         .expression("expression")
 *                                         .id("id")
 *                                         .label("label")
 *                                         .metricStat(PredictiveScalingMetricStatProperty.builder()
 *                                                 .metric(PredictiveScalingMetricProperty.builder()
 *                                                         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         .build())
 *                                                 .stat("stat")
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .maxCapacityBreachBehavior("maxCapacityBreachBehavior")
 *                 .maxCapacityBuffer(123)
 *                 .mode("mode")
 *                 .schedulingBufferTime(123)
 *                 .build())
 *         .resourceId("resourceId")
 *         .scalableDimension("scalableDimension")
 *         .scalingTargetId("scalingTargetId")
 *         .serviceNamespace("serviceNamespace")
 *         .stepScalingPolicyConfiguration(StepScalingPolicyConfigurationProperty.builder()
 *                 .adjustmentType("adjustmentType")
 *                 .cooldown(123)
 *                 .metricAggregationType("metricAggregationType")
 *                 .minAdjustmentMagnitude(123)
 *                 .stepAdjustments(List.of(StepAdjustmentProperty.builder()
 *                         .scalingAdjustment(123)
 *                         // the properties below are optional
 *                         .metricIntervalLowerBound(123)
 *                         .metricIntervalUpperBound(123)
 *                         .build()))
 *                 .build())
 *         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                 .targetValue(123)
 *                 // the properties below are optional
 *                 .customizedMetricSpecification(CustomizedMetricSpecificationProperty.builder()
 *                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .metricName("metricName")
 *                         .metrics(List.of(TargetTrackingMetricDataQueryProperty.builder()
 *                                 .expression("expression")
 *                                 .id("id")
 *                                 .label("label")
 *                                 .metricStat(TargetTrackingMetricStatProperty.builder()
 *                                         .metric(TargetTrackingMetricProperty.builder()
 *                                                 .dimensions(List.of(TargetTrackingMetricDimensionProperty.builder()
 *                                                         .name("name")
 *                                                         .value("value")
 *                                                         .build()))
 *                                                 .metricName("metricName")
 *                                                 .namespace("namespace")
 *                                                 .build())
 *                                         .stat("stat")
 *                                         .unit("unit")
 *                                         .build())
 *                                 .returnData(false)
 *                                 .build()))
 *                         .namespace("namespace")
 *                         .statistic("statistic")
 *                         .unit("unit")
 *                         .build())
 *                 .disableScaleIn(false)
 *                 .predefinedMetricSpecification(PredefinedMetricSpecificationProperty.builder()
 *                         .predefinedMetricType("predefinedMetricType")
 *                         // the properties below are optional
 *                         .resourceLabel("resourceLabel")
 *                         .build())
 *                 .scaleInCooldown(123)
 *                 .scaleOutCooldown(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:44.904Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy")
public class CfnScalingPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.applicationautoscaling.IScalingPolicyRef {

    protected CfnScalingPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScalingPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::ApplicationAutoScaling::ScalingPolicy</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnScalingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the ARN of a scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ScalingPolicy resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.applicationautoscaling.ScalingPolicyReference getScalingPolicyRef() {
        return software.amazon.jsii.Kernel.get(this, "scalingPolicyRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.applicationautoscaling.ScalingPolicyReference.class));
    }

    /**
     * The name of the scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyName", java.util.Objects.requireNonNull(value, "policyName is required"));
    }

    /**
     * The scaling policy type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyType() {
        return software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scaling policy type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyType", java.util.Objects.requireNonNull(value, "policyType is required"));
    }

    /**
     * The predictive scaling policy configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingPolicyConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPredictiveScalingPolicyConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "predictiveScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The predictive scaling policy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPredictiveScalingPolicyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "predictiveScalingPolicyConfiguration", value);
    }

    /**
     * The predictive scaling policy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPredictiveScalingPolicyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingPolicyConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "predictiveScalingPolicyConfiguration", value);
    }

    /**
     * The identifier of the resource associated with the scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
        return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the resource associated with the scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceId", value);
    }

    /**
     * The scalable dimension.
     * <p>
     * This string consists of the service namespace, resource type, and scaling property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScalableDimension() {
        return software.amazon.jsii.Kernel.get(this, "scalableDimension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scalable dimension.
     * <p>
     * This string consists of the service namespace, resource type, and scaling property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalableDimension(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scalableDimension", value);
    }

    /**
     * The CloudFormation-generated ID of an Application Auto Scaling scalable target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScalingTargetId() {
        return software.amazon.jsii.Kernel.get(this, "scalingTargetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CloudFormation-generated ID of an Application Auto Scaling scalable target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingTargetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scalingTargetId", value);
    }

    /**
     * The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceNamespace() {
        return software.amazon.jsii.Kernel.get(this, "serviceNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceNamespace(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceNamespace", value);
    }

    /**
     * A step scaling policy.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.StepScalingPolicyConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStepScalingPolicyConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "stepScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A step scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStepScalingPolicyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stepScalingPolicyConfiguration", value);
    }

    /**
     * A step scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStepScalingPolicyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.StepScalingPolicyConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "stepScalingPolicyConfiguration", value);
    }

    /**
     * A target tracking scaling policy.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargetTrackingScalingPolicyConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "targetTrackingScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A target tracking scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetTrackingScalingPolicyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetTrackingScalingPolicyConfiguration", value);
    }

    /**
     * A target tracking scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetTrackingScalingPolicyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetTrackingScalingPolicyConfiguration", value);
    }
    /**
     * Contains customized metric specification information for a target tracking scaling policy for Application Auto Scaling.
     * <p>
     * For information about the available metrics for a service, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">AWS services that publish CloudWatch metrics</a> in the <em>Amazon CloudWatch User Guide</em> .
     * <p>
     * To create your customized metric specification:
     * <p>
     * <ul>
     * <li>Add values for each required parameter from CloudWatch. You can use an existing metric, or a new metric that you create. To use your own metric, you must first publish the metric to CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publish custom metrics</a> in the <em>Amazon CloudWatch User Guide</em> .</li>
     * <li>Choose a metric that changes proportionally with capacity. The value of the metric should increase or decrease in inverse proportion to the number of capacity units. That is, the value of the metric should decrease when capacity increases, and increase when capacity decreases.</li>
     * </ul>
     * <p>
     * For an example of how creating new metrics can be useful, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-using-sqs-queue.html">Scaling based on Amazon SQS</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> . This topic mentions Auto Scaling groups, but the same scenario for Amazon SQS can apply to the target tracking scaling policies that you create for a Spot Fleet by using Application Auto Scaling.
     * <p>
     * For more information about the CloudWatch terminology below, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch concepts</a> .
     * <p>
     * <code>CustomizedMetricSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html">AWS::ApplicationAutoScaling::ScalingPolicy TargetTrackingScalingPolicyConfiguration</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * CustomizedMetricSpecificationProperty customizedMetricSpecificationProperty = CustomizedMetricSpecificationProperty.builder()
     *         .dimensions(List.of(MetricDimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .metricName("metricName")
     *         .metrics(List.of(TargetTrackingMetricDataQueryProperty.builder()
     *                 .expression("expression")
     *                 .id("id")
     *                 .label("label")
     *                 .metricStat(TargetTrackingMetricStatProperty.builder()
     *                         .metric(TargetTrackingMetricProperty.builder()
     *                                 .dimensions(List.of(TargetTrackingMetricDimensionProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .metricName("metricName")
     *                                 .namespace("namespace")
     *                                 .build())
     *                         .stat("stat")
     *                         .unit("unit")
     *                         .build())
     *                 .returnData(false)
     *                 .build()))
     *         .namespace("namespace")
     *         .statistic("statistic")
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomizedMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomizedMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dimensions of the metric.
         * <p>
         * Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.MetricDimensionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The name of the metric.
         * <p>
         * To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that's returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
            return null;
        }

        /**
         * The metrics to include in the target tracking scaling policy, as a metric data query.
         * <p>
         * This can include both raw metric and metric math expressions.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricDataQueryProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-metrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-metrics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetrics() {
            return null;
        }

        /**
         * The namespace of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * The statistic of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-statistic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-statistic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
            return null;
        }

        /**
         * The unit of the metric.
         * <p>
         * For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomizedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomizedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomizedMetricSpecificationProperty> {
            java.lang.Object dimensions;
            java.lang.String metricName;
            java.lang.Object metrics;
            java.lang.String namespace;
            java.lang.String statistic;
            java.lang.String unit;

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getDimensions}
             * @param dimensions The dimensions of the metric.
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getDimensions}
             * @param dimensions The dimensions of the metric.
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getMetricName}
             * @param metricName The name of the metric.
             *                   To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that's returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getMetrics}
             * @param metrics The metrics to include in the target tracking scaling policy, as a metric data query.
             *                This can include both raw metric and metric math expressions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metrics(software.amazon.awscdk.IResolvable metrics) {
                this.metrics = metrics;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getMetrics}
             * @param metrics The metrics to include in the target tracking scaling policy, as a metric data query.
             *                This can include both raw metric and metric math expressions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metrics(java.util.List<? extends java.lang.Object> metrics) {
                this.metrics = metrics;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getNamespace}
             * @param namespace The namespace of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getStatistic}
             * @param statistic The statistic of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getUnit}
             * @param unit The unit of the metric.
             *             For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomizedMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomizedMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomizedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomizedMetricSpecificationProperty {
            private final java.lang.Object dimensions;
            private final java.lang.String metricName;
            private final java.lang.Object metrics;
            private final java.lang.String namespace;
            private final java.lang.String statistic;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = builder.dimensions;
                this.metricName = builder.metricName;
                this.metrics = builder.metrics;
                this.namespace = builder.namespace;
                this.statistic = builder.statistic;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.Object getMetrics() {
                return this.metrics;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getMetricName() != null) {
                    data.set("metricName", om.valueToTree(this.getMetricName()));
                }
                if (this.getMetrics() != null) {
                    data.set("metrics", om.valueToTree(this.getMetrics()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getStatistic() != null) {
                    data.set("statistic", om.valueToTree(this.getStatistic()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomizedMetricSpecificationProperty.Jsii$Proxy that = (CustomizedMetricSpecificationProperty.Jsii$Proxy) o;

                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) return false;
                if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                result = 31 * result + (this.metricName != null ? this.metricName.hashCode() : 0);
                result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>MetricDimension</code> specifies a name/value pair that is part of the identity of a CloudWatch metric for the <code>Dimensions</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html">AWS::ApplicationAutoScaling::ScalingPolicy CustomizedMetricSpecification</a> property type. Duplicate dimensions are not allowed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * MetricDimensionProperty metricDimensionProperty = MetricDimensionProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html#cfn-applicationautoscaling-scalingpolicy-metricdimension-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html#cfn-applicationautoscaling-scalingpolicy-metricdimension-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html#cfn-applicationautoscaling-scalingpolicy-metricdimension-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html#cfn-applicationautoscaling-scalingpolicy-metricdimension-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link MetricDimensionProperty#getName}
             * @param name The name of the dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link MetricDimensionProperty#getValue}
             * @param value The value of the dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains predefined metric specification information for a target tracking scaling policy for Application Auto Scaling.
     * <p>
     * <code>PredefinedMetricSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html">AWS::ApplicationAutoScaling::ScalingPolicy TargetTrackingScalingPolicyConfiguration</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredefinedMetricSpecificationProperty predefinedMetricSpecificationProperty = PredefinedMetricSpecificationProperty.builder()
     *         .predefinedMetricType("predefinedMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredefinedMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredefinedMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric type.
         * <p>
         * The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot fleet requests and ECS services.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predefinedmetricspecification-predefinedmetrictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predefinedmetricspecification-predefinedmetrictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType();

        /**
         * Identifies the resource associated with the metric type.
         * <p>
         * You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet or ECS service.
         * <p>
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
         * <p>
         * <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code> .
         * <p>
         * Where:
         * <p>
         * <ul>
         * <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
         * <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
         * </ul>
         * <p>
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predefinedmetricspecification-resourcelabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predefinedmetricspecification-resourcelabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredefinedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredefinedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredefinedMetricSpecificationProperty> {
            java.lang.String predefinedMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredefinedMetricSpecificationProperty#getPredefinedMetricType}
             * @param predefinedMetricType The metric type. This parameter is required.
             *                             The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot fleet requests and ECS services.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricType(java.lang.String predefinedMetricType) {
                this.predefinedMetricType = predefinedMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredefinedMetricSpecificationProperty#getResourceLabel}
             * @param resourceLabel Identifies the resource associated with the metric type.
             *                      You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet or ECS service.
             *                      <p>
             *                      You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
             *                      <p>
             *                      <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code> .
             *                      <p>
             *                      Where:
             *                      <p>
             *                      <ul>
             *                      <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
             *                      <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
             *                      </ul>
             *                      <p>
             *                      To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredefinedMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredefinedMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredefinedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredefinedMetricSpecificationProperty {
            private final java.lang.String predefinedMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedMetricType = software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedMetricType = java.util.Objects.requireNonNull(builder.predefinedMetricType, "predefinedMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedMetricType() {
                return this.predefinedMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedMetricType", om.valueToTree(this.getPredefinedMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredefinedMetricSpecificationProperty.Jsii$Proxy that = (PredefinedMetricSpecificationProperty.Jsii$Proxy) o;

                if (!predefinedMetricType.equals(that.predefinedMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a CloudWatch metric of your choosing for a predictive scaling policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingCustomizedCapacityMetricProperty predictiveScalingCustomizedCapacityMetricProperty = PredictiveScalingCustomizedCapacityMetricProperty.builder()
     *         .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
     *                 .expression("expression")
     *                 .id("id")
     *                 .label("label")
     *                 .metricStat(PredictiveScalingMetricStatProperty.builder()
     *                         .metric(PredictiveScalingMetricProperty.builder()
     *                                 .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .metricName("metricName")
     *                                 .namespace("namespace")
     *                                 .build())
     *                         .stat("stat")
     *                         .unit("unit")
     *                         .build())
     *                 .returnData(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedcapacitymetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedcapacitymetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedCapacityMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingCustomizedCapacityMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingCustomizedCapacityMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more metric data queries to provide data points for a metric specification.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricDataQueryProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedcapacitymetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingcustomizedcapacitymetric-metricdataqueries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedcapacitymetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingcustomizedcapacitymetric-metricdataqueries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMetricDataQueries();

        /**
         * @return a {@link Builder} of {@link PredictiveScalingCustomizedCapacityMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingCustomizedCapacityMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingCustomizedCapacityMetricProperty> {
            java.lang.Object metricDataQueries;

            /**
             * Sets the value of {@link PredictiveScalingCustomizedCapacityMetricProperty#getMetricDataQueries}
             * @param metricDataQueries One or more metric data queries to provide data points for a metric specification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDataQueries(software.amazon.awscdk.IResolvable metricDataQueries) {
                this.metricDataQueries = metricDataQueries;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingCustomizedCapacityMetricProperty#getMetricDataQueries}
             * @param metricDataQueries One or more metric data queries to provide data points for a metric specification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDataQueries(java.util.List<? extends java.lang.Object> metricDataQueries) {
                this.metricDataQueries = metricDataQueries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingCustomizedCapacityMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingCustomizedCapacityMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingCustomizedCapacityMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingCustomizedCapacityMetricProperty {
            private final java.lang.Object metricDataQueries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricDataQueries = software.amazon.jsii.Kernel.get(this, "metricDataQueries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricDataQueries = java.util.Objects.requireNonNull(builder.metricDataQueries, "metricDataQueries is required");
            }

            @Override
            public final java.lang.Object getMetricDataQueries() {
                return this.metricDataQueries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricDataQueries", om.valueToTree(this.getMetricDataQueries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedCapacityMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingCustomizedCapacityMetricProperty.Jsii$Proxy that = (PredictiveScalingCustomizedCapacityMetricProperty.Jsii$Proxy) o;

                return this.metricDataQueries.equals(that.metricDataQueries);
            }

            @Override
            public final int hashCode() {
                int result = this.metricDataQueries.hashCode();
                return result;
            }
        }
    }
    /**
     * The customized load metric specification.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingCustomizedLoadMetricProperty predictiveScalingCustomizedLoadMetricProperty = PredictiveScalingCustomizedLoadMetricProperty.builder()
     *         .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
     *                 .expression("expression")
     *                 .id("id")
     *                 .label("label")
     *                 .metricStat(PredictiveScalingMetricStatProperty.builder()
     *                         .metric(PredictiveScalingMetricProperty.builder()
     *                                 .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .metricName("metricName")
     *                                 .namespace("namespace")
     *                                 .build())
     *                         .stat("stat")
     *                         .unit("unit")
     *                         .build())
     *                 .returnData(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedloadmetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedloadmetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedLoadMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingCustomizedLoadMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingCustomizedLoadMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricDataQueryProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedloadmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingcustomizedloadmetric-metricdataqueries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedloadmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingcustomizedloadmetric-metricdataqueries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMetricDataQueries();

        /**
         * @return a {@link Builder} of {@link PredictiveScalingCustomizedLoadMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingCustomizedLoadMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingCustomizedLoadMetricProperty> {
            java.lang.Object metricDataQueries;

            /**
             * Sets the value of {@link PredictiveScalingCustomizedLoadMetricProperty#getMetricDataQueries}
             * @param metricDataQueries the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDataQueries(software.amazon.awscdk.IResolvable metricDataQueries) {
                this.metricDataQueries = metricDataQueries;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingCustomizedLoadMetricProperty#getMetricDataQueries}
             * @param metricDataQueries the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDataQueries(java.util.List<? extends java.lang.Object> metricDataQueries) {
                this.metricDataQueries = metricDataQueries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingCustomizedLoadMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingCustomizedLoadMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingCustomizedLoadMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingCustomizedLoadMetricProperty {
            private final java.lang.Object metricDataQueries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricDataQueries = software.amazon.jsii.Kernel.get(this, "metricDataQueries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricDataQueries = java.util.Objects.requireNonNull(builder.metricDataQueries, "metricDataQueries is required");
            }

            @Override
            public final java.lang.Object getMetricDataQueries() {
                return this.metricDataQueries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricDataQueries", om.valueToTree(this.getMetricDataQueries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedLoadMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingCustomizedLoadMetricProperty.Jsii$Proxy that = (PredictiveScalingCustomizedLoadMetricProperty.Jsii$Proxy) o;

                return this.metricDataQueries.equals(that.metricDataQueries);
            }

            @Override
            public final int hashCode() {
                int result = this.metricDataQueries.hashCode();
                return result;
            }
        }
    }
    /**
     * One or more metric data queries to provide data points for a metric specification.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingCustomizedScalingMetricProperty predictiveScalingCustomizedScalingMetricProperty = PredictiveScalingCustomizedScalingMetricProperty.builder()
     *         .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
     *                 .expression("expression")
     *                 .id("id")
     *                 .label("label")
     *                 .metricStat(PredictiveScalingMetricStatProperty.builder()
     *                         .metric(PredictiveScalingMetricProperty.builder()
     *                                 .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .metricName("metricName")
     *                                 .namespace("namespace")
     *                                 .build())
     *                         .stat("stat")
     *                         .unit("unit")
     *                         .build())
     *                 .returnData(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedscalingmetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedscalingmetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedScalingMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingCustomizedScalingMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingCustomizedScalingMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more metric data queries to provide data points for a metric specification.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricDataQueryProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedscalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingcustomizedscalingmetric-metricdataqueries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingcustomizedscalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingcustomizedscalingmetric-metricdataqueries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMetricDataQueries();

        /**
         * @return a {@link Builder} of {@link PredictiveScalingCustomizedScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingCustomizedScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingCustomizedScalingMetricProperty> {
            java.lang.Object metricDataQueries;

            /**
             * Sets the value of {@link PredictiveScalingCustomizedScalingMetricProperty#getMetricDataQueries}
             * @param metricDataQueries One or more metric data queries to provide data points for a metric specification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDataQueries(software.amazon.awscdk.IResolvable metricDataQueries) {
                this.metricDataQueries = metricDataQueries;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingCustomizedScalingMetricProperty#getMetricDataQueries}
             * @param metricDataQueries One or more metric data queries to provide data points for a metric specification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDataQueries(java.util.List<? extends java.lang.Object> metricDataQueries) {
                this.metricDataQueries = metricDataQueries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingCustomizedScalingMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingCustomizedScalingMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingCustomizedScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingCustomizedScalingMetricProperty {
            private final java.lang.Object metricDataQueries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricDataQueries = software.amazon.jsii.Kernel.get(this, "metricDataQueries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricDataQueries = java.util.Objects.requireNonNull(builder.metricDataQueries, "metricDataQueries is required");
            }

            @Override
            public final java.lang.Object getMetricDataQueries() {
                return this.metricDataQueries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricDataQueries", om.valueToTree(this.getMetricDataQueries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedScalingMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingCustomizedScalingMetricProperty.Jsii$Proxy that = (PredictiveScalingCustomizedScalingMetricProperty.Jsii$Proxy) o;

                return this.metricDataQueries.equals(that.metricDataQueries);
            }

            @Override
            public final int hashCode() {
                int result = this.metricDataQueries.hashCode();
                return result;
            }
        }
    }
    /**
     * The metric data to return.
     * <p>
     * Also defines whether this call is returning data for one metric only, or whether it is performing a math expression on the values of returned metric statistics to create a new time series. A time series is a series of data points, each of which is associated with a timestamp.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingMetricDataQueryProperty predictiveScalingMetricDataQueryProperty = PredictiveScalingMetricDataQueryProperty.builder()
     *         .expression("expression")
     *         .id("id")
     *         .label("label")
     *         .metricStat(PredictiveScalingMetricStatProperty.builder()
     *                 .metric(PredictiveScalingMetricProperty.builder()
     *                         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .metricName("metricName")
     *                         .namespace("namespace")
     *                         .build())
     *                 .stat("stat")
     *                 .unit("unit")
     *                 .build())
     *         .returnData(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricDataQueryProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingMetricDataQueryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingMetricDataQueryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The math expression to perform on the returned data, if this object is performing a math expression.
         * <p>
         * This expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions.
         * <p>
         * Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> , but not both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * A short name that identifies the object's results in the response.
         * <p>
         * This name must be unique among all <code>MetricDataQuery</code> objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * A human-readable label for this metric or expression.
         * <p>
         * This is especially useful if this is a math expression, so that you know what the value represents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery-label">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery-label</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
            return null;
        }

        /**
         * Information about the metric data to return.
         * <p>
         * Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> , but not both.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricStatProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery-metricstat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery-metricstat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricStat() {
            return null;
        }

        /**
         * Indicates whether to return the timestamps and raw data values of this metric.
         * <p>
         * If you use any math expressions, specify <code>true</code> for this value for only the final math expression that the metric specification is based on. You must specify <code>false</code> for <code>ReturnData</code> for all the other metrics and expressions used in the metric specification.
         * <p>
         * If you are only retrieving metrics and not performing any math expressions, do not specify anything for <code>ReturnData</code> . This sets it to its default ( <code>true</code> ).
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery-returndata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdataquery-returndata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReturnData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingMetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingMetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingMetricDataQueryProperty> {
            java.lang.String expression;
            java.lang.String id;
            java.lang.String label;
            java.lang.Object metricStat;
            java.lang.Object returnData;

            /**
             * Sets the value of {@link PredictiveScalingMetricDataQueryProperty#getExpression}
             * @param expression The math expression to perform on the returned data, if this object is performing a math expression.
             *                   This expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions.
             *                   <p>
             *                   Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricDataQueryProperty#getId}
             * @param id A short name that identifies the object's results in the response.
             *           This name must be unique among all <code>MetricDataQuery</code> objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricDataQueryProperty#getLabel}
             * @param label A human-readable label for this metric or expression.
             *              This is especially useful if this is a math expression, so that you know what the value represents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder label(java.lang.String label) {
                this.label = label;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricDataQueryProperty#getMetricStat}
             * @param metricStat Information about the metric data to return.
             *                   Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricStat(software.amazon.awscdk.IResolvable metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricDataQueryProperty#getMetricStat}
             * @param metricStat Information about the metric data to return.
             *                   Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricStat(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricStatProperty metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricDataQueryProperty#getReturnData}
             * @param returnData Indicates whether to return the timestamps and raw data values of this metric.
             *                   If you use any math expressions, specify <code>true</code> for this value for only the final math expression that the metric specification is based on. You must specify <code>false</code> for <code>ReturnData</code> for all the other metrics and expressions used in the metric specification.
             *                   <p>
             *                   If you are only retrieving metrics and not performing any math expressions, do not specify anything for <code>ReturnData</code> . This sets it to its default ( <code>true</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder returnData(java.lang.Boolean returnData) {
                this.returnData = returnData;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricDataQueryProperty#getReturnData}
             * @param returnData Indicates whether to return the timestamps and raw data values of this metric.
             *                   If you use any math expressions, specify <code>true</code> for this value for only the final math expression that the metric specification is based on. You must specify <code>false</code> for <code>ReturnData</code> for all the other metrics and expressions used in the metric specification.
             *                   <p>
             *                   If you are only retrieving metrics and not performing any math expressions, do not specify anything for <code>ReturnData</code> . This sets it to its default ( <code>true</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder returnData(software.amazon.awscdk.IResolvable returnData) {
                this.returnData = returnData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingMetricDataQueryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingMetricDataQueryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingMetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingMetricDataQueryProperty {
            private final java.lang.String expression;
            private final java.lang.String id;
            private final java.lang.String label;
            private final java.lang.Object metricStat;
            private final java.lang.Object returnData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricStat = software.amazon.jsii.Kernel.get(this, "metricStat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.returnData = software.amazon.jsii.Kernel.get(this, "returnData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = builder.expression;
                this.id = builder.id;
                this.label = builder.label;
                this.metricStat = builder.metricStat;
                this.returnData = builder.returnData;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getLabel() {
                return this.label;
            }

            @Override
            public final java.lang.Object getMetricStat() {
                return this.metricStat;
            }

            @Override
            public final java.lang.Object getReturnData() {
                return this.returnData;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getLabel() != null) {
                    data.set("label", om.valueToTree(this.getLabel()));
                }
                if (this.getMetricStat() != null) {
                    data.set("metricStat", om.valueToTree(this.getMetricStat()));
                }
                if (this.getReturnData() != null) {
                    data.set("returnData", om.valueToTree(this.getReturnData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricDataQueryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingMetricDataQueryProperty.Jsii$Proxy that = (PredictiveScalingMetricDataQueryProperty.Jsii$Proxy) o;

                if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
                if (this.metricStat != null ? !this.metricStat.equals(that.metricStat) : that.metricStat != null) return false;
                return this.returnData != null ? this.returnData.equals(that.returnData) : that.returnData == null;
            }

            @Override
            public final int hashCode() {
                int result = this.expression != null ? this.expression.hashCode() : 0;
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
                result = 31 * result + (this.metricStat != null ? this.metricStat.hashCode() : 0);
                result = 31 * result + (this.returnData != null ? this.returnData.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the dimension of a metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingMetricDimensionProperty predictiveScalingMetricDimensionProperty = PredictiveScalingMetricDimensionProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingMetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingMetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdimension.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdimension-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdimension.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdimension-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of the dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdimension.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdimension-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricdimension.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricdimension-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingMetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingMetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingMetricDimensionProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link PredictiveScalingMetricDimensionProperty#getName}
             * @param name The name of the dimension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricDimensionProperty#getValue}
             * @param value The value of the dimension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingMetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingMetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingMetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingMetricDimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingMetricDimensionProperty.Jsii$Proxy that = (PredictiveScalingMetricDimensionProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the scaling metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingMetricProperty predictiveScalingMetricProperty = PredictiveScalingMetricProperty.builder()
     *         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .metricName("metricName")
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the dimensions of the metric.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricDimensionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetric-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetric-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The name of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetric-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetric-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
            return null;
        }

        /**
         * The namespace of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetric-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetric-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingMetricProperty> {
            java.lang.Object dimensions;
            java.lang.String metricName;
            java.lang.String namespace;

            /**
             * Sets the value of {@link PredictiveScalingMetricProperty#getDimensions}
             * @param dimensions Describes the dimensions of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricProperty#getDimensions}
             * @param dimensions Describes the dimensions of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricProperty#getMetricName}
             * @param metricName The name of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricProperty#getNamespace}
             * @param namespace The namespace of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingMetricProperty {
            private final java.lang.Object dimensions;
            private final java.lang.String metricName;
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = builder.dimensions;
                this.metricName = builder.metricName;
                this.namespace = builder.namespace;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getMetricName() != null) {
                    data.set("metricName", om.valueToTree(this.getMetricName()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingMetricProperty.Jsii$Proxy that = (PredictiveScalingMetricProperty.Jsii$Proxy) o;

                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) return false;
                return this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                result = 31 * result + (this.metricName != null ? this.metricName.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure specifies the metrics and target utilization settings for a predictive scaling policy.
     * <p>
     * You must specify either a metric pair, or a load metric and a scaling metric individually. Specifying a metric pair instead of individual metrics provides a simpler way to configure metrics for a scaling policy. You choose the metric pair, and the policy automatically knows the correct sum and average statistics to use for the load metric and the scaling metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingMetricSpecificationProperty predictiveScalingMetricSpecificationProperty = PredictiveScalingMetricSpecificationProperty.builder()
     *         .targetValue(123)
     *         // the properties below are optional
     *         .customizedCapacityMetricSpecification(PredictiveScalingCustomizedCapacityMetricProperty.builder()
     *                 .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
     *                         .expression("expression")
     *                         .id("id")
     *                         .label("label")
     *                         .metricStat(PredictiveScalingMetricStatProperty.builder()
     *                                 .metric(PredictiveScalingMetricProperty.builder()
     *                                         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                                                 .name("name")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .metricName("metricName")
     *                                         .namespace("namespace")
     *                                         .build())
     *                                 .stat("stat")
     *                                 .unit("unit")
     *                                 .build())
     *                         .returnData(false)
     *                         .build()))
     *                 .build())
     *         .customizedLoadMetricSpecification(PredictiveScalingCustomizedLoadMetricProperty.builder()
     *                 .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
     *                         .expression("expression")
     *                         .id("id")
     *                         .label("label")
     *                         .metricStat(PredictiveScalingMetricStatProperty.builder()
     *                                 .metric(PredictiveScalingMetricProperty.builder()
     *                                         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                                                 .name("name")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .metricName("metricName")
     *                                         .namespace("namespace")
     *                                         .build())
     *                                 .stat("stat")
     *                                 .unit("unit")
     *                                 .build())
     *                         .returnData(false)
     *                         .build()))
     *                 .build())
     *         .customizedScalingMetricSpecification(PredictiveScalingCustomizedScalingMetricProperty.builder()
     *                 .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
     *                         .expression("expression")
     *                         .id("id")
     *                         .label("label")
     *                         .metricStat(PredictiveScalingMetricStatProperty.builder()
     *                                 .metric(PredictiveScalingMetricProperty.builder()
     *                                         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                                                 .name("name")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .metricName("metricName")
     *                                         .namespace("namespace")
     *                                         .build())
     *                                 .stat("stat")
     *                                 .unit("unit")
     *                                 .build())
     *                         .returnData(false)
     *                         .build()))
     *                 .build())
     *         .predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricProperty.builder()
     *                 .predefinedMetricType("predefinedMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairProperty.builder()
     *                 .predefinedMetricType("predefinedMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricProperty.builder()
     *                 .predefinedMetricType("predefinedMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the target utilization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-targetvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-targetvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * The customized capacity metric specification.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedCapacityMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-customizedcapacitymetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-customizedcapacitymetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomizedCapacityMetricSpecification() {
            return null;
        }

        /**
         * The customized load metric specification.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedLoadMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-customizedloadmetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-customizedloadmetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomizedLoadMetricSpecification() {
            return null;
        }

        /**
         * The customized scaling metric specification.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedScalingMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-customizedscalingmetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-customizedscalingmetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomizedScalingMetricSpecification() {
            return null;
        }

        /**
         * The predefined load metric specification.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedLoadMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-predefinedloadmetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-predefinedloadmetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedLoadMetricSpecification() {
            return null;
        }

        /**
         * The predefined metric pair specification that determines the appropriate scaling metric and load metric to use.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedMetricPairProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-predefinedmetricpairspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-predefinedmetricpairspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedMetricPairSpecification() {
            return null;
        }

        /**
         * The predefined scaling metric specification.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedScalingMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-predefinedscalingmetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricspecification-predefinedscalingmetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedScalingMetricSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingMetricSpecificationProperty> {
            java.lang.Number targetValue;
            java.lang.Object customizedCapacityMetricSpecification;
            java.lang.Object customizedLoadMetricSpecification;
            java.lang.Object customizedScalingMetricSpecification;
            java.lang.Object predefinedLoadMetricSpecification;
            java.lang.Object predefinedMetricPairSpecification;
            java.lang.Object predefinedScalingMetricSpecification;

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getTargetValue}
             * @param targetValue Specifies the target utilization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getCustomizedCapacityMetricSpecification}
             * @param customizedCapacityMetricSpecification The customized capacity metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedCapacityMetricSpecification(software.amazon.awscdk.IResolvable customizedCapacityMetricSpecification) {
                this.customizedCapacityMetricSpecification = customizedCapacityMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getCustomizedCapacityMetricSpecification}
             * @param customizedCapacityMetricSpecification The customized capacity metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedCapacityMetricSpecification(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedCapacityMetricProperty customizedCapacityMetricSpecification) {
                this.customizedCapacityMetricSpecification = customizedCapacityMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getCustomizedLoadMetricSpecification}
             * @param customizedLoadMetricSpecification The customized load metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedLoadMetricSpecification(software.amazon.awscdk.IResolvable customizedLoadMetricSpecification) {
                this.customizedLoadMetricSpecification = customizedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getCustomizedLoadMetricSpecification}
             * @param customizedLoadMetricSpecification The customized load metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedLoadMetricSpecification(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedLoadMetricProperty customizedLoadMetricSpecification) {
                this.customizedLoadMetricSpecification = customizedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getCustomizedScalingMetricSpecification}
             * @param customizedScalingMetricSpecification The customized scaling metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedScalingMetricSpecification(software.amazon.awscdk.IResolvable customizedScalingMetricSpecification) {
                this.customizedScalingMetricSpecification = customizedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getCustomizedScalingMetricSpecification}
             * @param customizedScalingMetricSpecification The customized scaling metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedScalingMetricSpecification(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingCustomizedScalingMetricProperty customizedScalingMetricSpecification) {
                this.customizedScalingMetricSpecification = customizedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedLoadMetricSpecification}
             * @param predefinedLoadMetricSpecification The predefined load metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedLoadMetricSpecification(software.amazon.awscdk.IResolvable predefinedLoadMetricSpecification) {
                this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedLoadMetricSpecification}
             * @param predefinedLoadMetricSpecification The predefined load metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedLoadMetricSpecification(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedLoadMetricProperty predefinedLoadMetricSpecification) {
                this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedMetricPairSpecification}
             * @param predefinedMetricPairSpecification The predefined metric pair specification that determines the appropriate scaling metric and load metric to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricPairSpecification(software.amazon.awscdk.IResolvable predefinedMetricPairSpecification) {
                this.predefinedMetricPairSpecification = predefinedMetricPairSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedMetricPairSpecification}
             * @param predefinedMetricPairSpecification The predefined metric pair specification that determines the appropriate scaling metric and load metric to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricPairSpecification(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedMetricPairProperty predefinedMetricPairSpecification) {
                this.predefinedMetricPairSpecification = predefinedMetricPairSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedScalingMetricSpecification}
             * @param predefinedScalingMetricSpecification The predefined scaling metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedScalingMetricSpecification(software.amazon.awscdk.IResolvable predefinedScalingMetricSpecification) {
                this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedScalingMetricSpecification}
             * @param predefinedScalingMetricSpecification The predefined scaling metric specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedScalingMetricSpecification(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedScalingMetricProperty predefinedScalingMetricSpecification) {
                this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingMetricSpecificationProperty {
            private final java.lang.Number targetValue;
            private final java.lang.Object customizedCapacityMetricSpecification;
            private final java.lang.Object customizedLoadMetricSpecification;
            private final java.lang.Object customizedScalingMetricSpecification;
            private final java.lang.Object predefinedLoadMetricSpecification;
            private final java.lang.Object predefinedMetricPairSpecification;
            private final java.lang.Object predefinedScalingMetricSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customizedCapacityMetricSpecification = software.amazon.jsii.Kernel.get(this, "customizedCapacityMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customizedLoadMetricSpecification = software.amazon.jsii.Kernel.get(this, "customizedLoadMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customizedScalingMetricSpecification = software.amazon.jsii.Kernel.get(this, "customizedScalingMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predefinedLoadMetricSpecification = software.amazon.jsii.Kernel.get(this, "predefinedLoadMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predefinedMetricPairSpecification = software.amazon.jsii.Kernel.get(this, "predefinedMetricPairSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predefinedScalingMetricSpecification = software.amazon.jsii.Kernel.get(this, "predefinedScalingMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
                this.customizedCapacityMetricSpecification = builder.customizedCapacityMetricSpecification;
                this.customizedLoadMetricSpecification = builder.customizedLoadMetricSpecification;
                this.customizedScalingMetricSpecification = builder.customizedScalingMetricSpecification;
                this.predefinedLoadMetricSpecification = builder.predefinedLoadMetricSpecification;
                this.predefinedMetricPairSpecification = builder.predefinedMetricPairSpecification;
                this.predefinedScalingMetricSpecification = builder.predefinedScalingMetricSpecification;
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            public final java.lang.Object getCustomizedCapacityMetricSpecification() {
                return this.customizedCapacityMetricSpecification;
            }

            @Override
            public final java.lang.Object getCustomizedLoadMetricSpecification() {
                return this.customizedLoadMetricSpecification;
            }

            @Override
            public final java.lang.Object getCustomizedScalingMetricSpecification() {
                return this.customizedScalingMetricSpecification;
            }

            @Override
            public final java.lang.Object getPredefinedLoadMetricSpecification() {
                return this.predefinedLoadMetricSpecification;
            }

            @Override
            public final java.lang.Object getPredefinedMetricPairSpecification() {
                return this.predefinedMetricPairSpecification;
            }

            @Override
            public final java.lang.Object getPredefinedScalingMetricSpecification() {
                return this.predefinedScalingMetricSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));
                if (this.getCustomizedCapacityMetricSpecification() != null) {
                    data.set("customizedCapacityMetricSpecification", om.valueToTree(this.getCustomizedCapacityMetricSpecification()));
                }
                if (this.getCustomizedLoadMetricSpecification() != null) {
                    data.set("customizedLoadMetricSpecification", om.valueToTree(this.getCustomizedLoadMetricSpecification()));
                }
                if (this.getCustomizedScalingMetricSpecification() != null) {
                    data.set("customizedScalingMetricSpecification", om.valueToTree(this.getCustomizedScalingMetricSpecification()));
                }
                if (this.getPredefinedLoadMetricSpecification() != null) {
                    data.set("predefinedLoadMetricSpecification", om.valueToTree(this.getPredefinedLoadMetricSpecification()));
                }
                if (this.getPredefinedMetricPairSpecification() != null) {
                    data.set("predefinedMetricPairSpecification", om.valueToTree(this.getPredefinedMetricPairSpecification()));
                }
                if (this.getPredefinedScalingMetricSpecification() != null) {
                    data.set("predefinedScalingMetricSpecification", om.valueToTree(this.getPredefinedScalingMetricSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingMetricSpecificationProperty.Jsii$Proxy that = (PredictiveScalingMetricSpecificationProperty.Jsii$Proxy) o;

                if (!targetValue.equals(that.targetValue)) return false;
                if (this.customizedCapacityMetricSpecification != null ? !this.customizedCapacityMetricSpecification.equals(that.customizedCapacityMetricSpecification) : that.customizedCapacityMetricSpecification != null) return false;
                if (this.customizedLoadMetricSpecification != null ? !this.customizedLoadMetricSpecification.equals(that.customizedLoadMetricSpecification) : that.customizedLoadMetricSpecification != null) return false;
                if (this.customizedScalingMetricSpecification != null ? !this.customizedScalingMetricSpecification.equals(that.customizedScalingMetricSpecification) : that.customizedScalingMetricSpecification != null) return false;
                if (this.predefinedLoadMetricSpecification != null ? !this.predefinedLoadMetricSpecification.equals(that.predefinedLoadMetricSpecification) : that.predefinedLoadMetricSpecification != null) return false;
                if (this.predefinedMetricPairSpecification != null ? !this.predefinedMetricPairSpecification.equals(that.predefinedMetricPairSpecification) : that.predefinedMetricPairSpecification != null) return false;
                return this.predefinedScalingMetricSpecification != null ? this.predefinedScalingMetricSpecification.equals(that.predefinedScalingMetricSpecification) : that.predefinedScalingMetricSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetValue.hashCode();
                result = 31 * result + (this.customizedCapacityMetricSpecification != null ? this.customizedCapacityMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.customizedLoadMetricSpecification != null ? this.customizedLoadMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.customizedScalingMetricSpecification != null ? this.customizedScalingMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.predefinedLoadMetricSpecification != null ? this.predefinedLoadMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.predefinedMetricPairSpecification != null ? this.predefinedMetricPairSpecification.hashCode() : 0);
                result = 31 * result + (this.predefinedScalingMetricSpecification != null ? this.predefinedScalingMetricSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure defines the CloudWatch metric to return, along with the statistic and unit.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingMetricStatProperty predictiveScalingMetricStatProperty = PredictiveScalingMetricStatProperty.builder()
     *         .metric(PredictiveScalingMetricProperty.builder()
     *                 .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .metricName("metricName")
     *                 .namespace("namespace")
     *                 .build())
     *         .stat("stat")
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricstat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricstat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricStatProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingMetricStatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingMetricStatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CloudWatch metric to return, including the metric name, namespace, and dimensions.
         * <p>
         * To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricstat-metric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricstat-metric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetric() {
            return null;
        }

        /**
         * The statistic to return.
         * <p>
         * It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <em>Amazon CloudWatch User Guide</em> .
         * <p>
         * The most commonly used metrics for predictive scaling are <code>Average</code> and <code>Sum</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricstat-stat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricstat-stat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStat() {
            return null;
        }

        /**
         * The unit to use for the returned data points.
         * <p>
         * For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricstat-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingmetricstat-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingMetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingMetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingMetricStatProperty> {
            java.lang.Object metric;
            java.lang.String stat;
            java.lang.String unit;

            /**
             * Sets the value of {@link PredictiveScalingMetricStatProperty#getMetric}
             * @param metric The CloudWatch metric to return, including the metric name, namespace, and dimensions.
             *               To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.IResolvable metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricStatProperty#getMetric}
             * @param metric The CloudWatch metric to return, including the metric name, namespace, and dimensions.
             *               To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricProperty metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricStatProperty#getStat}
             * @param stat The statistic to return.
             *             It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <em>Amazon CloudWatch User Guide</em> .
             *             <p>
             *             The most commonly used metrics for predictive scaling are <code>Average</code> and <code>Sum</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stat(java.lang.String stat) {
                this.stat = stat;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricStatProperty#getUnit}
             * @param unit The unit to use for the returned data points.
             *             For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingMetricStatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingMetricStatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingMetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingMetricStatProperty {
            private final java.lang.Object metric;
            private final java.lang.String stat;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stat = software.amazon.jsii.Kernel.get(this, "stat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metric = builder.metric;
                this.stat = builder.stat;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.Object getMetric() {
                return this.metric;
            }

            @Override
            public final java.lang.String getStat() {
                return this.stat;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMetric() != null) {
                    data.set("metric", om.valueToTree(this.getMetric()));
                }
                if (this.getStat() != null) {
                    data.set("stat", om.valueToTree(this.getStat()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricStatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingMetricStatProperty.Jsii$Proxy that = (PredictiveScalingMetricStatProperty.Jsii$Proxy) o;

                if (this.metric != null ? !this.metric.equals(that.metric) : that.metric != null) return false;
                if (this.stat != null ? !this.stat.equals(that.stat) : that.stat != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metric != null ? this.metric.hashCode() : 0;
                result = 31 * result + (this.stat != null ? this.stat.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a predictive scaling policy configuration.
     * <p>
     * Predictive scaling is supported on Amazon ECS services.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingPolicyConfigurationProperty predictiveScalingPolicyConfigurationProperty = PredictiveScalingPolicyConfigurationProperty.builder()
     *         .metricSpecifications(List.of(PredictiveScalingMetricSpecificationProperty.builder()
     *                 .targetValue(123)
     *                 // the properties below are optional
     *                 .customizedCapacityMetricSpecification(PredictiveScalingCustomizedCapacityMetricProperty.builder()
     *                         .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
     *                                 .expression("expression")
     *                                 .id("id")
     *                                 .label("label")
     *                                 .metricStat(PredictiveScalingMetricStatProperty.builder()
     *                                         .metric(PredictiveScalingMetricProperty.builder()
     *                                                 .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                                                         .name("name")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .metricName("metricName")
     *                                                 .namespace("namespace")
     *                                                 .build())
     *                                         .stat("stat")
     *                                         .unit("unit")
     *                                         .build())
     *                                 .returnData(false)
     *                                 .build()))
     *                         .build())
     *                 .customizedLoadMetricSpecification(PredictiveScalingCustomizedLoadMetricProperty.builder()
     *                         .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
     *                                 .expression("expression")
     *                                 .id("id")
     *                                 .label("label")
     *                                 .metricStat(PredictiveScalingMetricStatProperty.builder()
     *                                         .metric(PredictiveScalingMetricProperty.builder()
     *                                                 .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                                                         .name("name")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .metricName("metricName")
     *                                                 .namespace("namespace")
     *                                                 .build())
     *                                         .stat("stat")
     *                                         .unit("unit")
     *                                         .build())
     *                                 .returnData(false)
     *                                 .build()))
     *                         .build())
     *                 .customizedScalingMetricSpecification(PredictiveScalingCustomizedScalingMetricProperty.builder()
     *                         .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
     *                                 .expression("expression")
     *                                 .id("id")
     *                                 .label("label")
     *                                 .metricStat(PredictiveScalingMetricStatProperty.builder()
     *                                         .metric(PredictiveScalingMetricProperty.builder()
     *                                                 .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
     *                                                         .name("name")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .metricName("metricName")
     *                                                 .namespace("namespace")
     *                                                 .build())
     *                                         .stat("stat")
     *                                         .unit("unit")
     *                                         .build())
     *                                 .returnData(false)
     *                                 .build()))
     *                         .build())
     *                 .predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricProperty.builder()
     *                         .predefinedMetricType("predefinedMetricType")
     *                         // the properties below are optional
     *                         .resourceLabel("resourceLabel")
     *                         .build())
     *                 .predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairProperty.builder()
     *                         .predefinedMetricType("predefinedMetricType")
     *                         // the properties below are optional
     *                         .resourceLabel("resourceLabel")
     *                         .build())
     *                 .predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricProperty.builder()
     *                         .predefinedMetricType("predefinedMetricType")
     *                         // the properties below are optional
     *                         .resourceLabel("resourceLabel")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .maxCapacityBreachBehavior("maxCapacityBreachBehavior")
     *         .maxCapacityBuffer(123)
     *         .mode("mode")
     *         .schedulingBufferTime(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This structure includes the metrics and target utilization to use for predictive scaling.
         * <p>
         * This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingMetricSpecificationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration-metricspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration-metricspecifications</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMetricSpecifications();

        /**
         * Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity.
         * <p>
         * Defaults to <code>HonorMaxCapacity</code> if not specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration-maxcapacitybreachbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration-maxcapacitybreachbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxCapacityBreachBehavior() {
            return null;
        }

        /**
         * The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
         * <p>
         * The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
         * <p>
         * Required if the <code>MaxCapacityBreachBehavior</code> property is set to <code>IncreaseMaxCapacity</code> , and cannot be used otherwise.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration-maxcapacitybuffer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration-maxcapacitybuffer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacityBuffer() {
            return null;
        }

        /**
         * The predictive scaling mode.
         * <p>
         * Defaults to <code>ForecastOnly</code> if not specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * The amount of time, in seconds, that the start time can be advanced.
         * <p>
         * The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration-schedulingbuffertime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration-schedulingbuffertime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingBufferTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingPolicyConfigurationProperty> {
            java.lang.Object metricSpecifications;
            java.lang.String maxCapacityBreachBehavior;
            java.lang.Number maxCapacityBuffer;
            java.lang.String mode;
            java.lang.Number schedulingBufferTime;

            /**
             * Sets the value of {@link PredictiveScalingPolicyConfigurationProperty#getMetricSpecifications}
             * @param metricSpecifications This structure includes the metrics and target utilization to use for predictive scaling. This parameter is required.
             *                             This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricSpecifications(software.amazon.awscdk.IResolvable metricSpecifications) {
                this.metricSpecifications = metricSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPolicyConfigurationProperty#getMetricSpecifications}
             * @param metricSpecifications This structure includes the metrics and target utilization to use for predictive scaling. This parameter is required.
             *                             This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricSpecifications(java.util.List<? extends java.lang.Object> metricSpecifications) {
                this.metricSpecifications = metricSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPolicyConfigurationProperty#getMaxCapacityBreachBehavior}
             * @param maxCapacityBreachBehavior Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity.
             *                                  Defaults to <code>HonorMaxCapacity</code> if not specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacityBreachBehavior(java.lang.String maxCapacityBreachBehavior) {
                this.maxCapacityBreachBehavior = maxCapacityBreachBehavior;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPolicyConfigurationProperty#getMaxCapacityBuffer}
             * @param maxCapacityBuffer The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
             *                          The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
             *                          <p>
             *                          Required if the <code>MaxCapacityBreachBehavior</code> property is set to <code>IncreaseMaxCapacity</code> , and cannot be used otherwise.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacityBuffer(java.lang.Number maxCapacityBuffer) {
                this.maxCapacityBuffer = maxCapacityBuffer;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPolicyConfigurationProperty#getMode}
             * @param mode The predictive scaling mode.
             *             Defaults to <code>ForecastOnly</code> if not specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPolicyConfigurationProperty#getSchedulingBufferTime}
             * @param schedulingBufferTime The amount of time, in seconds, that the start time can be advanced.
             *                             The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedulingBufferTime(java.lang.Number schedulingBufferTime) {
                this.schedulingBufferTime = schedulingBufferTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingPolicyConfigurationProperty {
            private final java.lang.Object metricSpecifications;
            private final java.lang.String maxCapacityBreachBehavior;
            private final java.lang.Number maxCapacityBuffer;
            private final java.lang.String mode;
            private final java.lang.Number schedulingBufferTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricSpecifications = software.amazon.jsii.Kernel.get(this, "metricSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxCapacityBreachBehavior = software.amazon.jsii.Kernel.get(this, "maxCapacityBreachBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxCapacityBuffer = software.amazon.jsii.Kernel.get(this, "maxCapacityBuffer", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schedulingBufferTime = software.amazon.jsii.Kernel.get(this, "schedulingBufferTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricSpecifications = java.util.Objects.requireNonNull(builder.metricSpecifications, "metricSpecifications is required");
                this.maxCapacityBreachBehavior = builder.maxCapacityBreachBehavior;
                this.maxCapacityBuffer = builder.maxCapacityBuffer;
                this.mode = builder.mode;
                this.schedulingBufferTime = builder.schedulingBufferTime;
            }

            @Override
            public final java.lang.Object getMetricSpecifications() {
                return this.metricSpecifications;
            }

            @Override
            public final java.lang.String getMaxCapacityBreachBehavior() {
                return this.maxCapacityBreachBehavior;
            }

            @Override
            public final java.lang.Number getMaxCapacityBuffer() {
                return this.maxCapacityBuffer;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Number getSchedulingBufferTime() {
                return this.schedulingBufferTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricSpecifications", om.valueToTree(this.getMetricSpecifications()));
                if (this.getMaxCapacityBreachBehavior() != null) {
                    data.set("maxCapacityBreachBehavior", om.valueToTree(this.getMaxCapacityBreachBehavior()));
                }
                if (this.getMaxCapacityBuffer() != null) {
                    data.set("maxCapacityBuffer", om.valueToTree(this.getMaxCapacityBuffer()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getSchedulingBufferTime() != null) {
                    data.set("schedulingBufferTime", om.valueToTree(this.getSchedulingBufferTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingPolicyConfigurationProperty.Jsii$Proxy that = (PredictiveScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (!metricSpecifications.equals(that.metricSpecifications)) return false;
                if (this.maxCapacityBreachBehavior != null ? !this.maxCapacityBreachBehavior.equals(that.maxCapacityBreachBehavior) : that.maxCapacityBreachBehavior != null) return false;
                if (this.maxCapacityBuffer != null ? !this.maxCapacityBuffer.equals(that.maxCapacityBuffer) : that.maxCapacityBuffer != null) return false;
                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.schedulingBufferTime != null ? this.schedulingBufferTime.equals(that.schedulingBufferTime) : that.schedulingBufferTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricSpecifications.hashCode();
                result = 31 * result + (this.maxCapacityBreachBehavior != null ? this.maxCapacityBreachBehavior.hashCode() : 0);
                result = 31 * result + (this.maxCapacityBuffer != null ? this.maxCapacityBuffer.hashCode() : 0);
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                result = 31 * result + (this.schedulingBufferTime != null ? this.schedulingBufferTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a load metric for a predictive scaling policy.
     * <p>
     * When returned in the output of <code>DescribePolicies</code> , it indicates that a predictive scaling policy uses individually specified load and scaling metrics instead of a metric pair.
     * <p>
     * The following predefined metrics are available for predictive scaling:
     * <p>
     * <ul>
     * <li><code>ECSServiceAverageCPUUtilization</code></li>
     * <li><code>ECSServiceAverageMemoryUtilization</code></li>
     * <li><code>ECSServiceCPUUtilization</code></li>
     * <li><code>ECSServiceMemoryUtilization</code></li>
     * <li><code>ECSServiceTotalCPUUtilization</code></li>
     * <li><code>ECSServiceTotalMemoryUtilization</code></li>
     * <li><code>ALBRequestCount</code></li>
     * <li><code>ALBRequestCountPerTarget</code></li>
     * <li><code>TotalALBRequestCount</code></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingPredefinedLoadMetricProperty predictiveScalingPredefinedLoadMetricProperty = PredictiveScalingPredefinedLoadMetricProperty.builder()
     *         .predefinedMetricType("predefinedMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedloadmetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedloadmetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedLoadMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingPredefinedLoadMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingPredefinedLoadMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedloadmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedloadmetric-predefinedmetrictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedloadmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedloadmetric-predefinedmetrictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType();

        /**
         * A label that uniquely identifies a target group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedloadmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedloadmetric-resourcelabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedloadmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedloadmetric-resourcelabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingPredefinedLoadMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingPredefinedLoadMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingPredefinedLoadMetricProperty> {
            java.lang.String predefinedMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredictiveScalingPredefinedLoadMetricProperty#getPredefinedMetricType}
             * @param predefinedMetricType The metric type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricType(java.lang.String predefinedMetricType) {
                this.predefinedMetricType = predefinedMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPredefinedLoadMetricProperty#getResourceLabel}
             * @param resourceLabel A label that uniquely identifies a target group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingPredefinedLoadMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingPredefinedLoadMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingPredefinedLoadMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingPredefinedLoadMetricProperty {
            private final java.lang.String predefinedMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedMetricType = software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedMetricType = java.util.Objects.requireNonNull(builder.predefinedMetricType, "predefinedMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedMetricType() {
                return this.predefinedMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedMetricType", om.valueToTree(this.getPredefinedMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedLoadMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingPredefinedLoadMetricProperty.Jsii$Proxy that = (PredictiveScalingPredefinedLoadMetricProperty.Jsii$Proxy) o;

                if (!predefinedMetricType.equals(that.predefinedMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a metric pair for a predictive scaling policy.
     * <p>
     * The following predefined metrics are available for predictive scaling:
     * <p>
     * <ul>
     * <li><code>ECSServiceAverageCPUUtilization</code></li>
     * <li><code>ECSServiceAverageMemoryUtilization</code></li>
     * <li><code>ECSServiceCPUUtilization</code></li>
     * <li><code>ECSServiceMemoryUtilization</code></li>
     * <li><code>ECSServiceTotalCPUUtilization</code></li>
     * <li><code>ECSServiceTotalMemoryUtilization</code></li>
     * <li><code>ALBRequestCount</code></li>
     * <li><code>ALBRequestCountPerTarget</code></li>
     * <li><code>TotalALBRequestCount</code></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingPredefinedMetricPairProperty predictiveScalingPredefinedMetricPairProperty = PredictiveScalingPredefinedMetricPairProperty.builder()
     *         .predefinedMetricType("predefinedMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedmetricpair.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedmetricpair.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedMetricPairProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingPredefinedMetricPairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingPredefinedMetricPairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates which metrics to use.
         * <p>
         * There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedmetricpair.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedmetricpair-predefinedmetrictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedmetricpair.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedmetricpair-predefinedmetrictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType();

        /**
         * A label that uniquely identifies a specific target group from which to determine the total and average request count.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedmetricpair.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedmetricpair-resourcelabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedmetricpair.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedmetricpair-resourcelabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingPredefinedMetricPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingPredefinedMetricPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingPredefinedMetricPairProperty> {
            java.lang.String predefinedMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredictiveScalingPredefinedMetricPairProperty#getPredefinedMetricType}
             * @param predefinedMetricType Indicates which metrics to use. This parameter is required.
             *                             There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricType(java.lang.String predefinedMetricType) {
                this.predefinedMetricType = predefinedMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPredefinedMetricPairProperty#getResourceLabel}
             * @param resourceLabel A label that uniquely identifies a specific target group from which to determine the total and average request count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingPredefinedMetricPairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingPredefinedMetricPairProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingPredefinedMetricPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingPredefinedMetricPairProperty {
            private final java.lang.String predefinedMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedMetricType = software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedMetricType = java.util.Objects.requireNonNull(builder.predefinedMetricType, "predefinedMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedMetricType() {
                return this.predefinedMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedMetricType", om.valueToTree(this.getPredefinedMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedMetricPairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingPredefinedMetricPairProperty.Jsii$Proxy that = (PredictiveScalingPredefinedMetricPairProperty.Jsii$Proxy) o;

                if (!predefinedMetricType.equals(that.predefinedMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a scaling metric for a predictive scaling policy.
     * <p>
     * When returned in the output of <code>DescribePolicies</code> , it indicates that a predictive scaling policy uses individually specified load and scaling metrics instead of a metric pair.
     * <p>
     * The following predefined metrics are available for predictive scaling:
     * <p>
     * <ul>
     * <li><code>ECSServiceAverageCPUUtilization</code></li>
     * <li><code>ECSServiceAverageMemoryUtilization</code></li>
     * <li><code>ECSServiceCPUUtilization</code></li>
     * <li><code>ECSServiceMemoryUtilization</code></li>
     * <li><code>ECSServiceTotalCPUUtilization</code></li>
     * <li><code>ECSServiceTotalMemoryUtilization</code></li>
     * <li><code>ALBRequestCount</code></li>
     * <li><code>ALBRequestCountPerTarget</code></li>
     * <li><code>TotalALBRequestCount</code></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * PredictiveScalingPredefinedScalingMetricProperty predictiveScalingPredefinedScalingMetricProperty = PredictiveScalingPredefinedScalingMetricProperty.builder()
     *         .predefinedMetricType("predefinedMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedscalingmetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedscalingmetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedScalingMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingPredefinedScalingMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingPredefinedScalingMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedscalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedscalingmetric-predefinedmetrictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedscalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedscalingmetric-predefinedmetrictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType();

        /**
         * A label that uniquely identifies a specific target group from which to determine the average request count.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedscalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedscalingmetric-resourcelabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predictivescalingpredefinedscalingmetric.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpredefinedscalingmetric-resourcelabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingPredefinedScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingPredefinedScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingPredefinedScalingMetricProperty> {
            java.lang.String predefinedMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredictiveScalingPredefinedScalingMetricProperty#getPredefinedMetricType}
             * @param predefinedMetricType The metric type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricType(java.lang.String predefinedMetricType) {
                this.predefinedMetricType = predefinedMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPredefinedScalingMetricProperty#getResourceLabel}
             * @param resourceLabel A label that uniquely identifies a specific target group from which to determine the average request count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingPredefinedScalingMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingPredefinedScalingMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingPredefinedScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingPredefinedScalingMetricProperty {
            private final java.lang.String predefinedMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedMetricType = software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedMetricType = java.util.Objects.requireNonNull(builder.predefinedMetricType, "predefinedMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedMetricType() {
                return this.predefinedMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedMetricType", om.valueToTree(this.getPredefinedMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.PredictiveScalingPredefinedScalingMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingPredefinedScalingMetricProperty.Jsii$Proxy that = (PredictiveScalingPredefinedScalingMetricProperty.Jsii$Proxy) o;

                if (!predefinedMetricType.equals(that.predefinedMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>StepAdjustment</code> specifies a step adjustment for the <code>StepAdjustments</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html">AWS::ApplicationAutoScaling::ScalingPolicy StepScalingPolicyConfiguration</a> property type.
     * <p>
     * For the following examples, suppose that you have an alarm with a breach threshold of 50:
     * <p>
     * <ul>
     * <li>To trigger a step adjustment when the metric is greater than or equal to 50 and less than 60, specify a lower bound of 0 and an upper bound of 10.</li>
     * <li>To trigger a step adjustment when the metric is greater than 40 and less than or equal to 50, specify a lower bound of -10 and an upper bound of 0.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#as-scaling-steps">Step adjustments</a> in the <em>Application Auto Scaling User Guide</em> .
     * <p>
     * You can find a sample template snippet in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#aws-resource-applicationautoscaling-scalingpolicy--examples">Examples</a> section of the <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> documentation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * StepAdjustmentProperty stepAdjustmentProperty = StepAdjustmentProperty.builder()
     *         .scalingAdjustment(123)
     *         // the properties below are optional
     *         .metricIntervalLowerBound(123)
     *         .metricIntervalUpperBound(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepadjustment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepadjustment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.StepAdjustmentProperty")
    @software.amazon.jsii.Jsii.Proxy(StepAdjustmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepAdjustmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount by which to scale.
         * <p>
         * The adjustment is based on the value that you specified in the <code>AdjustmentType</code> property (either an absolute number or a percentage). A positive value adds to the current capacity and a negative number subtracts from the current capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepadjustment-scalingadjustment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepadjustment-scalingadjustment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getScalingAdjustment();

        /**
         * The lower bound for the difference between the alarm threshold and the CloudWatch metric.
         * <p>
         * If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
         * <p>
         * You must specify at least one upper or lower bound.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepadjustment-metricintervallowerbound">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepadjustment-metricintervallowerbound</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMetricIntervalLowerBound() {
            return null;
        }

        /**
         * The upper bound for the difference between the alarm threshold and the CloudWatch metric.
         * <p>
         * If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
         * <p>
         * You must specify at least one upper or lower bound.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepadjustment-metricintervalupperbound">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepadjustment-metricintervalupperbound</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMetricIntervalUpperBound() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepAdjustmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepAdjustmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepAdjustmentProperty> {
            java.lang.Number scalingAdjustment;
            java.lang.Number metricIntervalLowerBound;
            java.lang.Number metricIntervalUpperBound;

            /**
             * Sets the value of {@link StepAdjustmentProperty#getScalingAdjustment}
             * @param scalingAdjustment The amount by which to scale. This parameter is required.
             *                          The adjustment is based on the value that you specified in the <code>AdjustmentType</code> property (either an absolute number or a percentage). A positive value adds to the current capacity and a negative number subtracts from the current capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingAdjustment(java.lang.Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            /**
             * Sets the value of {@link StepAdjustmentProperty#getMetricIntervalLowerBound}
             * @param metricIntervalLowerBound The lower bound for the difference between the alarm threshold and the CloudWatch metric.
             *                                 If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
             *                                 <p>
             *                                 You must specify at least one upper or lower bound.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricIntervalLowerBound(java.lang.Number metricIntervalLowerBound) {
                this.metricIntervalLowerBound = metricIntervalLowerBound;
                return this;
            }

            /**
             * Sets the value of {@link StepAdjustmentProperty#getMetricIntervalUpperBound}
             * @param metricIntervalUpperBound The upper bound for the difference between the alarm threshold and the CloudWatch metric.
             *                                 If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
             *                                 <p>
             *                                 You must specify at least one upper or lower bound.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricIntervalUpperBound(java.lang.Number metricIntervalUpperBound) {
                this.metricIntervalUpperBound = metricIntervalUpperBound;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepAdjustmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepAdjustmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepAdjustmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepAdjustmentProperty {
            private final java.lang.Number scalingAdjustment;
            private final java.lang.Number metricIntervalLowerBound;
            private final java.lang.Number metricIntervalUpperBound;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scalingAdjustment = software.amazon.jsii.Kernel.get(this, "scalingAdjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.metricIntervalLowerBound = software.amazon.jsii.Kernel.get(this, "metricIntervalLowerBound", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.metricIntervalUpperBound = software.amazon.jsii.Kernel.get(this, "metricIntervalUpperBound", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scalingAdjustment = java.util.Objects.requireNonNull(builder.scalingAdjustment, "scalingAdjustment is required");
                this.metricIntervalLowerBound = builder.metricIntervalLowerBound;
                this.metricIntervalUpperBound = builder.metricIntervalUpperBound;
            }

            @Override
            public final java.lang.Number getScalingAdjustment() {
                return this.scalingAdjustment;
            }

            @Override
            public final java.lang.Number getMetricIntervalLowerBound() {
                return this.metricIntervalLowerBound;
            }

            @Override
            public final java.lang.Number getMetricIntervalUpperBound() {
                return this.metricIntervalUpperBound;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scalingAdjustment", om.valueToTree(this.getScalingAdjustment()));
                if (this.getMetricIntervalLowerBound() != null) {
                    data.set("metricIntervalLowerBound", om.valueToTree(this.getMetricIntervalLowerBound()));
                }
                if (this.getMetricIntervalUpperBound() != null) {
                    data.set("metricIntervalUpperBound", om.valueToTree(this.getMetricIntervalUpperBound()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.StepAdjustmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepAdjustmentProperty.Jsii$Proxy that = (StepAdjustmentProperty.Jsii$Proxy) o;

                if (!scalingAdjustment.equals(that.scalingAdjustment)) return false;
                if (this.metricIntervalLowerBound != null ? !this.metricIntervalLowerBound.equals(that.metricIntervalLowerBound) : that.metricIntervalLowerBound != null) return false;
                return this.metricIntervalUpperBound != null ? this.metricIntervalUpperBound.equals(that.metricIntervalUpperBound) : that.metricIntervalUpperBound == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scalingAdjustment.hashCode();
                result = 31 * result + (this.metricIntervalLowerBound != null ? this.metricIntervalLowerBound.hashCode() : 0);
                result = 31 * result + (this.metricIntervalUpperBound != null ? this.metricIntervalUpperBound.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>StepScalingPolicyConfiguration</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a> resource that specifies a step scaling policy configuration for Application Auto Scaling.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html">Step scaling policies</a> in the <em>Application Auto Scaling User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * StepScalingPolicyConfigurationProperty stepScalingPolicyConfigurationProperty = StepScalingPolicyConfigurationProperty.builder()
     *         .adjustmentType("adjustmentType")
     *         .cooldown(123)
     *         .metricAggregationType("metricAggregationType")
     *         .minAdjustmentMagnitude(123)
     *         .stepAdjustments(List.of(StepAdjustmentProperty.builder()
     *                 .scalingAdjustment(123)
     *                 // the properties below are optional
     *                 .metricIntervalLowerBound(123)
     *                 .metricIntervalUpperBound(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.StepScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StepScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the <code>ScalingAdjustment</code> value in the <code>StepAdjustment</code> property is an absolute number or a percentage of the current capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-adjustmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-adjustmenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdjustmentType() {
            return null;
        }

        /**
         * The amount of time, in seconds, to wait for a previous scaling activity to take effect.
         * <p>
         * If not specified, the default value is 300. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/step-scaling-policy-overview.html#step-scaling-cooldown">Cooldown period</a> in the <em>Application Auto Scaling User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-cooldown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-cooldown</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCooldown() {
            return null;
        }

        /**
         * The aggregation type for the CloudWatch metrics.
         * <p>
         * Valid values are <code>Minimum</code> , <code>Maximum</code> , and <code>Average</code> . If the aggregation type is null, the value is treated as <code>Average</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-metricaggregationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-metricaggregationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricAggregationType() {
            return null;
        }

        /**
         * The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code> .
         * <p>
         * For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Application Auto Scaling scales out the service by 2 tasks.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-minadjustmentmagnitude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-minadjustmentmagnitude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinAdjustmentMagnitude() {
            return null;
        }

        /**
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * <p>
         * At least one step adjustment is required if you are adding a new step scaling policy configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.StepAdjustmentProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustments</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStepAdjustments() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepScalingPolicyConfigurationProperty> {
            java.lang.String adjustmentType;
            java.lang.Number cooldown;
            java.lang.String metricAggregationType;
            java.lang.Number minAdjustmentMagnitude;
            java.lang.Object stepAdjustments;

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getAdjustmentType}
             * @param adjustmentType Specifies whether the <code>ScalingAdjustment</code> value in the <code>StepAdjustment</code> property is an absolute number or a percentage of the current capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adjustmentType(java.lang.String adjustmentType) {
                this.adjustmentType = adjustmentType;
                return this;
            }

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getCooldown}
             * @param cooldown The amount of time, in seconds, to wait for a previous scaling activity to take effect.
             *                 If not specified, the default value is 300. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/step-scaling-policy-overview.html#step-scaling-cooldown">Cooldown period</a> in the <em>Application Auto Scaling User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cooldown(java.lang.Number cooldown) {
                this.cooldown = cooldown;
                return this;
            }

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getMetricAggregationType}
             * @param metricAggregationType The aggregation type for the CloudWatch metrics.
             *                              Valid values are <code>Minimum</code> , <code>Maximum</code> , and <code>Average</code> . If the aggregation type is null, the value is treated as <code>Average</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricAggregationType(java.lang.String metricAggregationType) {
                this.metricAggregationType = metricAggregationType;
                return this;
            }

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getMinAdjustmentMagnitude}
             * @param minAdjustmentMagnitude The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code> .
             *                               For example, suppose that you create a step scaling policy to scale out an Amazon ECS service by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the service has 4 tasks and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Application Auto Scaling scales out the service by 2 tasks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minAdjustmentMagnitude(java.lang.Number minAdjustmentMagnitude) {
                this.minAdjustmentMagnitude = minAdjustmentMagnitude;
                return this;
            }

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getStepAdjustments}
             * @param stepAdjustments A set of adjustments that enable you to scale based on the size of the alarm breach.
             *                        At least one step adjustment is required if you are adding a new step scaling policy configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepAdjustments(software.amazon.awscdk.IResolvable stepAdjustments) {
                this.stepAdjustments = stepAdjustments;
                return this;
            }

            /**
             * Sets the value of {@link StepScalingPolicyConfigurationProperty#getStepAdjustments}
             * @param stepAdjustments A set of adjustments that enable you to scale based on the size of the alarm breach.
             *                        At least one step adjustment is required if you are adding a new step scaling policy configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepAdjustments(java.util.List<? extends java.lang.Object> stepAdjustments) {
                this.stepAdjustments = stepAdjustments;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepScalingPolicyConfigurationProperty {
            private final java.lang.String adjustmentType;
            private final java.lang.Number cooldown;
            private final java.lang.String metricAggregationType;
            private final java.lang.Number minAdjustmentMagnitude;
            private final java.lang.Object stepAdjustments;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adjustmentType = software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.metricAggregationType = software.amazon.jsii.Kernel.get(this, "metricAggregationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minAdjustmentMagnitude = software.amazon.jsii.Kernel.get(this, "minAdjustmentMagnitude", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stepAdjustments = software.amazon.jsii.Kernel.get(this, "stepAdjustments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adjustmentType = builder.adjustmentType;
                this.cooldown = builder.cooldown;
                this.metricAggregationType = builder.metricAggregationType;
                this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
                this.stepAdjustments = builder.stepAdjustments;
            }

            @Override
            public final java.lang.String getAdjustmentType() {
                return this.adjustmentType;
            }

            @Override
            public final java.lang.Number getCooldown() {
                return this.cooldown;
            }

            @Override
            public final java.lang.String getMetricAggregationType() {
                return this.metricAggregationType;
            }

            @Override
            public final java.lang.Number getMinAdjustmentMagnitude() {
                return this.minAdjustmentMagnitude;
            }

            @Override
            public final java.lang.Object getStepAdjustments() {
                return this.stepAdjustments;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdjustmentType() != null) {
                    data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
                }
                if (this.getCooldown() != null) {
                    data.set("cooldown", om.valueToTree(this.getCooldown()));
                }
                if (this.getMetricAggregationType() != null) {
                    data.set("metricAggregationType", om.valueToTree(this.getMetricAggregationType()));
                }
                if (this.getMinAdjustmentMagnitude() != null) {
                    data.set("minAdjustmentMagnitude", om.valueToTree(this.getMinAdjustmentMagnitude()));
                }
                if (this.getStepAdjustments() != null) {
                    data.set("stepAdjustments", om.valueToTree(this.getStepAdjustments()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.StepScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepScalingPolicyConfigurationProperty.Jsii$Proxy that = (StepScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
                if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
                if (this.metricAggregationType != null ? !this.metricAggregationType.equals(that.metricAggregationType) : that.metricAggregationType != null) return false;
                if (this.minAdjustmentMagnitude != null ? !this.minAdjustmentMagnitude.equals(that.minAdjustmentMagnitude) : that.minAdjustmentMagnitude != null) return false;
                return this.stepAdjustments != null ? this.stepAdjustments.equals(that.stepAdjustments) : that.stepAdjustments == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adjustmentType != null ? this.adjustmentType.hashCode() : 0;
                result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
                result = 31 * result + (this.metricAggregationType != null ? this.metricAggregationType.hashCode() : 0);
                result = 31 * result + (this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.hashCode() : 0);
                result = 31 * result + (this.stepAdjustments != null ? this.stepAdjustments.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The metric data to return.
     * <p>
     * Also defines whether this call is returning data for one metric only, or whether it is performing a math expression on the values of returned metric statistics to create a new time series. A time series is a series of data points, each of which is associated with a timestamp.
     * <p>
     * You can call for a single metric or perform math expressions on multiple metrics. Any expressions used in a metric specification must eventually return a single time series.
     * <p>
     * For more information and examples, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking-metric-math.html">Create a target tracking scaling policy for Application Auto Scaling using metric math</a> in the <em>Application Auto Scaling User Guide</em> .
     * <p>
     * <code>TargetTrackingMetricDataQuery</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html">AWS::ApplicationAutoScaling::ScalingPolicy CustomizedMetricSpecification</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * TargetTrackingMetricDataQueryProperty targetTrackingMetricDataQueryProperty = TargetTrackingMetricDataQueryProperty.builder()
     *         .expression("expression")
     *         .id("id")
     *         .label("label")
     *         .metricStat(TargetTrackingMetricStatProperty.builder()
     *                 .metric(TargetTrackingMetricProperty.builder()
     *                         .dimensions(List.of(TargetTrackingMetricDimensionProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .metricName("metricName")
     *                         .namespace("namespace")
     *                         .build())
     *                 .stat("stat")
     *                 .unit("unit")
     *                 .build())
     *         .returnData(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricDataQueryProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingMetricDataQueryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingMetricDataQueryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The math expression to perform on the returned data, if this object is performing a math expression.
         * <p>
         * This expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions.
         * <p>
         * Conditional: Within each <code>TargetTrackingMetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> , but not both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * A short name that identifies the object's results in the response.
         * <p>
         * This name must be unique among all <code>MetricDataQuery</code> objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * A human-readable label for this metric or expression.
         * <p>
         * This is especially useful if this is a math expression, so that you know what the value represents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery-label">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery-label</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
            return null;
        }

        /**
         * Information about the metric data to return.
         * <p>
         * Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> , but not both.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricStatProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery-metricstat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery-metricstat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricStat() {
            return null;
        }

        /**
         * Indicates whether to return the timestamps and raw data values of this metric.
         * <p>
         * If you use any math expressions, specify <code>true</code> for this value for only the final math expression that the metric specification is based on. You must specify <code>false</code> for <code>ReturnData</code> for all the other metrics and expressions used in the metric specification.
         * <p>
         * If you are only retrieving metrics and not performing any math expressions, do not specify anything for <code>ReturnData</code> . This sets it to its default ( <code>true</code> ).
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery-returndata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery-returndata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReturnData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingMetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingMetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingMetricDataQueryProperty> {
            java.lang.String expression;
            java.lang.String id;
            java.lang.String label;
            java.lang.Object metricStat;
            java.lang.Object returnData;

            /**
             * Sets the value of {@link TargetTrackingMetricDataQueryProperty#getExpression}
             * @param expression The math expression to perform on the returned data, if this object is performing a math expression.
             *                   This expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions.
             *                   <p>
             *                   Conditional: Within each <code>TargetTrackingMetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricDataQueryProperty#getId}
             * @param id A short name that identifies the object's results in the response.
             *           This name must be unique among all <code>MetricDataQuery</code> objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricDataQueryProperty#getLabel}
             * @param label A human-readable label for this metric or expression.
             *              This is especially useful if this is a math expression, so that you know what the value represents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder label(java.lang.String label) {
                this.label = label;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricDataQueryProperty#getMetricStat}
             * @param metricStat Information about the metric data to return.
             *                   Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricStat(software.amazon.awscdk.IResolvable metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricDataQueryProperty#getMetricStat}
             * @param metricStat Information about the metric data to return.
             *                   Conditional: Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricStat(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricStatProperty metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricDataQueryProperty#getReturnData}
             * @param returnData Indicates whether to return the timestamps and raw data values of this metric.
             *                   If you use any math expressions, specify <code>true</code> for this value for only the final math expression that the metric specification is based on. You must specify <code>false</code> for <code>ReturnData</code> for all the other metrics and expressions used in the metric specification.
             *                   <p>
             *                   If you are only retrieving metrics and not performing any math expressions, do not specify anything for <code>ReturnData</code> . This sets it to its default ( <code>true</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder returnData(java.lang.Boolean returnData) {
                this.returnData = returnData;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricDataQueryProperty#getReturnData}
             * @param returnData Indicates whether to return the timestamps and raw data values of this metric.
             *                   If you use any math expressions, specify <code>true</code> for this value for only the final math expression that the metric specification is based on. You must specify <code>false</code> for <code>ReturnData</code> for all the other metrics and expressions used in the metric specification.
             *                   <p>
             *                   If you are only retrieving metrics and not performing any math expressions, do not specify anything for <code>ReturnData</code> . This sets it to its default ( <code>true</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder returnData(software.amazon.awscdk.IResolvable returnData) {
                this.returnData = returnData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingMetricDataQueryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingMetricDataQueryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingMetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingMetricDataQueryProperty {
            private final java.lang.String expression;
            private final java.lang.String id;
            private final java.lang.String label;
            private final java.lang.Object metricStat;
            private final java.lang.Object returnData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricStat = software.amazon.jsii.Kernel.get(this, "metricStat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.returnData = software.amazon.jsii.Kernel.get(this, "returnData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = builder.expression;
                this.id = builder.id;
                this.label = builder.label;
                this.metricStat = builder.metricStat;
                this.returnData = builder.returnData;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getLabel() {
                return this.label;
            }

            @Override
            public final java.lang.Object getMetricStat() {
                return this.metricStat;
            }

            @Override
            public final java.lang.Object getReturnData() {
                return this.returnData;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getLabel() != null) {
                    data.set("label", om.valueToTree(this.getLabel()));
                }
                if (this.getMetricStat() != null) {
                    data.set("metricStat", om.valueToTree(this.getMetricStat()));
                }
                if (this.getReturnData() != null) {
                    data.set("returnData", om.valueToTree(this.getReturnData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricDataQueryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingMetricDataQueryProperty.Jsii$Proxy that = (TargetTrackingMetricDataQueryProperty.Jsii$Proxy) o;

                if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
                if (this.metricStat != null ? !this.metricStat.equals(that.metricStat) : that.metricStat != null) return false;
                return this.returnData != null ? this.returnData.equals(that.returnData) : that.returnData == null;
            }

            @Override
            public final int hashCode() {
                int result = this.expression != null ? this.expression.hashCode() : 0;
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
                result = 31 * result + (this.metricStat != null ? this.metricStat.hashCode() : 0);
                result = 31 * result + (this.returnData != null ? this.returnData.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>TargetTrackingMetricDimension</code> specifies a name/value pair that is part of the identity of a CloudWatch metric for the <code>Dimensions</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetric.html">AWS::ApplicationAutoScaling::ScalingPolicy TargetTrackingMetric</a> property type. Duplicate dimensions are not allowed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * TargetTrackingMetricDimensionProperty targetTrackingMetricDimensionProperty = TargetTrackingMetricDimensionProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingMetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingMetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdimension.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdimension-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdimension.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdimension-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of the dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdimension.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdimension-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdimension.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricdimension-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingMetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingMetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingMetricDimensionProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link TargetTrackingMetricDimensionProperty#getName}
             * @param name The name of the dimension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricDimensionProperty#getValue}
             * @param value The value of the dimension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingMetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingMetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingMetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingMetricDimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingMetricDimensionProperty.Jsii$Proxy that = (TargetTrackingMetricDimensionProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a specific metric for a target tracking scaling policy for Application Auto Scaling.
     * <p>
     * Metric is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricstat.html">AWS::ApplicationAutoScaling::ScalingPolicy TargetTrackingMetricStat</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * TargetTrackingMetricProperty targetTrackingMetricProperty = TargetTrackingMetricProperty.builder()
     *         .dimensions(List.of(TargetTrackingMetricDimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .metricName("metricName")
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dimensions for the metric.
         * <p>
         * For the list of available dimensions, see the AWS documentation available from the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">AWS services that publish CloudWatch metrics</a> in the <em>Amazon CloudWatch User Guide</em> .
         * <p>
         * Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricDimensionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetric.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetric-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetric.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetric-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The name of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetric.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetric-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetric.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetric-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
            return null;
        }

        /**
         * The namespace of the metric.
         * <p>
         * For more information, see the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">AWS services that publish CloudWatch metrics</a> in the <em>Amazon CloudWatch User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetric.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetric-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetric.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetric-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingMetricProperty> {
            java.lang.Object dimensions;
            java.lang.String metricName;
            java.lang.String namespace;

            /**
             * Sets the value of {@link TargetTrackingMetricProperty#getDimensions}
             * @param dimensions The dimensions for the metric.
             *                   For the list of available dimensions, see the AWS documentation available from the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">AWS services that publish CloudWatch metrics</a> in the <em>Amazon CloudWatch User Guide</em> .
             *                   <p>
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricProperty#getDimensions}
             * @param dimensions The dimensions for the metric.
             *                   For the list of available dimensions, see the AWS documentation available from the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">AWS services that publish CloudWatch metrics</a> in the <em>Amazon CloudWatch User Guide</em> .
             *                   <p>
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricProperty#getMetricName}
             * @param metricName The name of the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricProperty#getNamespace}
             * @param namespace The namespace of the metric.
             *                  For more information, see the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">AWS services that publish CloudWatch metrics</a> in the <em>Amazon CloudWatch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingMetricProperty {
            private final java.lang.Object dimensions;
            private final java.lang.String metricName;
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = builder.dimensions;
                this.metricName = builder.metricName;
                this.namespace = builder.namespace;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getMetricName() != null) {
                    data.set("metricName", om.valueToTree(this.getMetricName()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingMetricProperty.Jsii$Proxy that = (TargetTrackingMetricProperty.Jsii$Proxy) o;

                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) return false;
                return this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                result = 31 * result + (this.metricName != null ? this.metricName.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure defines the CloudWatch metric to return, along with the statistic and unit.
     * <p>
     * <code>TargetTrackingMetricStat</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricdataquery.html">AWS::ApplicationAutoScaling::ScalingPolicy TargetTrackingMetricDataQuery</a> property type.
     * <p>
     * For more information about the CloudWatch terminology below, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch concepts</a> in the <em>Amazon CloudWatch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * TargetTrackingMetricStatProperty targetTrackingMetricStatProperty = TargetTrackingMetricStatProperty.builder()
     *         .metric(TargetTrackingMetricProperty.builder()
     *                 .dimensions(List.of(TargetTrackingMetricDimensionProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .metricName("metricName")
     *                 .namespace("namespace")
     *                 .build())
     *         .stat("stat")
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricstat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricstat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricStatProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingMetricStatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingMetricStatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CloudWatch metric to return, including the metric name, namespace, and dimensions.
         * <p>
         * To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricstat-metric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricstat-metric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetric() {
            return null;
        }

        /**
         * The statistic to return.
         * <p>
         * It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <em>Amazon CloudWatch User Guide</em> .
         * <p>
         * The most commonly used metric for scaling is <code>Average</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricstat-stat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricstat-stat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStat() {
            return null;
        }

        /**
         * The unit to use for the returned data points.
         * <p>
         * For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricstat-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingmetricstat.html#cfn-applicationautoscaling-scalingpolicy-targettrackingmetricstat-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingMetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingMetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingMetricStatProperty> {
            java.lang.Object metric;
            java.lang.String stat;
            java.lang.String unit;

            /**
             * Sets the value of {@link TargetTrackingMetricStatProperty#getMetric}
             * @param metric The CloudWatch metric to return, including the metric name, namespace, and dimensions.
             *               To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.IResolvable metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricStatProperty#getMetric}
             * @param metric The CloudWatch metric to return, including the metric name, namespace, and dimensions.
             *               To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricProperty metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricStatProperty#getStat}
             * @param stat The statistic to return.
             *             It can include any CloudWatch statistic or extended statistic. For a list of valid values, see the table in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <em>Amazon CloudWatch User Guide</em> .
             *             <p>
             *             The most commonly used metric for scaling is <code>Average</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stat(java.lang.String stat) {
                this.stat = stat;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingMetricStatProperty#getUnit}
             * @param unit The unit to use for the returned data points.
             *             For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingMetricStatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingMetricStatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingMetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingMetricStatProperty {
            private final java.lang.Object metric;
            private final java.lang.String stat;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stat = software.amazon.jsii.Kernel.get(this, "stat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metric = builder.metric;
                this.stat = builder.stat;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.Object getMetric() {
                return this.metric;
            }

            @Override
            public final java.lang.String getStat() {
                return this.stat;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMetric() != null) {
                    data.set("metric", om.valueToTree(this.getMetric()));
                }
                if (this.getStat() != null) {
                    data.set("stat", om.valueToTree(this.getStat()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingMetricStatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingMetricStatProperty.Jsii$Proxy that = (TargetTrackingMetricStatProperty.Jsii$Proxy) o;

                if (this.metric != null ? !this.metric.equals(that.metric) : that.metric != null) return false;
                if (this.stat != null ? !this.stat.equals(that.stat) : that.stat != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metric != null ? this.metric.hashCode() : 0;
                result = 31 * result + (this.stat != null ? this.stat.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>TargetTrackingScalingPolicyConfiguration</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy</a> resource that specifies a target tracking scaling policy configuration for Application Auto Scaling. Use a target tracking scaling policy to adjust the capacity of the specified scalable target in response to actual workloads, so that resource utilization remains at or near the target utilization value.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html">Target tracking scaling policies</a> in the <em>Application Auto Scaling User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * TargetTrackingScalingPolicyConfigurationProperty targetTrackingScalingPolicyConfigurationProperty = TargetTrackingScalingPolicyConfigurationProperty.builder()
     *         .targetValue(123)
     *         // the properties below are optional
     *         .customizedMetricSpecification(CustomizedMetricSpecificationProperty.builder()
     *                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .metricName("metricName")
     *                 .metrics(List.of(TargetTrackingMetricDataQueryProperty.builder()
     *                         .expression("expression")
     *                         .id("id")
     *                         .label("label")
     *                         .metricStat(TargetTrackingMetricStatProperty.builder()
     *                                 .metric(TargetTrackingMetricProperty.builder()
     *                                         .dimensions(List.of(TargetTrackingMetricDimensionProperty.builder()
     *                                                 .name("name")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .metricName("metricName")
     *                                         .namespace("namespace")
     *                                         .build())
     *                                 .stat("stat")
     *                                 .unit("unit")
     *                                 .build())
     *                         .returnData(false)
     *                         .build()))
     *                 .namespace("namespace")
     *                 .statistic("statistic")
     *                 .unit("unit")
     *                 .build())
     *         .disableScaleIn(false)
     *         .predefinedMetricSpecification(PredefinedMetricSpecificationProperty.builder()
     *                 .predefinedMetricType("predefinedMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .scaleInCooldown(123)
     *         .scaleOutCooldown(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target value for the metric.
         * <p>
         * Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-targetvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-targetvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * A customized metric.
         * <p>
         * You can specify either a predefined metric or a customized metric.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-customizedmetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-customizedmetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomizedMetricSpecification() {
            return null;
        }

        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled.
         * <p>
         * If the value is <code>true</code> , scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-disablescalein">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-disablescalein</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableScaleIn() {
            return null;
        }

        /**
         * A predefined metric.
         * <p>
         * You can specify either a predefined metric or a customized metric.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-predefinedmetricspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-predefinedmetricspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedMetricSpecification() {
            return null;
        }

        /**
         * The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
         * <p>
         * For more information and for default values, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/target-tracking-scaling-policy-overview.html#target-tracking-cooldown">Define cooldown periods</a> in the <em>Application Auto Scaling User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleincooldown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleincooldown</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleInCooldown() {
            return null;
        }

        /**
         * The amount of time, in seconds, to wait for a previous scale-out activity to take effect.
         * <p>
         * For more information and for default values, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/target-tracking-scaling-policy-overview.html#target-tracking-cooldown">Define cooldown periods</a> in the <em>Application Auto Scaling User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleoutcooldown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleoutcooldown</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleOutCooldown() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingScalingPolicyConfigurationProperty> {
            java.lang.Number targetValue;
            java.lang.Object customizedMetricSpecification;
            java.lang.Object disableScaleIn;
            java.lang.Object predefinedMetricSpecification;
            java.lang.Number scaleInCooldown;
            java.lang.Number scaleOutCooldown;

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getTargetValue}
             * @param targetValue The target value for the metric. This parameter is required.
             *                    Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getCustomizedMetricSpecification}
             * @param customizedMetricSpecification A customized metric.
             *                                      You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedMetricSpecification(software.amazon.awscdk.IResolvable customizedMetricSpecification) {
                this.customizedMetricSpecification = customizedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getCustomizedMetricSpecification}
             * @param customizedMetricSpecification A customized metric.
             *                                      You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedMetricSpecification(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty customizedMetricSpecification) {
                this.customizedMetricSpecification = customizedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Indicates whether scale in by the target tracking scaling policy is disabled.
             *                       If the value is <code>true</code> , scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Indicates whether scale in by the target tracking scaling policy is disabled.
             *                       If the value is <code>true</code> , scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(software.amazon.awscdk.IResolvable disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getPredefinedMetricSpecification}
             * @param predefinedMetricSpecification A predefined metric.
             *                                      You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricSpecification(software.amazon.awscdk.IResolvable predefinedMetricSpecification) {
                this.predefinedMetricSpecification = predefinedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getPredefinedMetricSpecification}
             * @param predefinedMetricSpecification A predefined metric.
             *                                      You can specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricSpecification(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty predefinedMetricSpecification) {
                this.predefinedMetricSpecification = predefinedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getScaleInCooldown}
             * @param scaleInCooldown The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
             *                        For more information and for default values, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/target-tracking-scaling-policy-overview.html#target-tracking-cooldown">Define cooldown periods</a> in the <em>Application Auto Scaling User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleInCooldown(java.lang.Number scaleInCooldown) {
                this.scaleInCooldown = scaleInCooldown;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getScaleOutCooldown}
             * @param scaleOutCooldown The amount of time, in seconds, to wait for a previous scale-out activity to take effect.
             *                         For more information and for default values, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/target-tracking-scaling-policy-overview.html#target-tracking-cooldown">Define cooldown periods</a> in the <em>Application Auto Scaling User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleOutCooldown(java.lang.Number scaleOutCooldown) {
                this.scaleOutCooldown = scaleOutCooldown;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingScalingPolicyConfigurationProperty {
            private final java.lang.Number targetValue;
            private final java.lang.Object customizedMetricSpecification;
            private final java.lang.Object disableScaleIn;
            private final java.lang.Object predefinedMetricSpecification;
            private final java.lang.Number scaleInCooldown;
            private final java.lang.Number scaleOutCooldown;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customizedMetricSpecification = software.amazon.jsii.Kernel.get(this, "customizedMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableScaleIn = software.amazon.jsii.Kernel.get(this, "disableScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predefinedMetricSpecification = software.amazon.jsii.Kernel.get(this, "predefinedMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scaleInCooldown = software.amazon.jsii.Kernel.get(this, "scaleInCooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scaleOutCooldown = software.amazon.jsii.Kernel.get(this, "scaleOutCooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
                this.customizedMetricSpecification = builder.customizedMetricSpecification;
                this.disableScaleIn = builder.disableScaleIn;
                this.predefinedMetricSpecification = builder.predefinedMetricSpecification;
                this.scaleInCooldown = builder.scaleInCooldown;
                this.scaleOutCooldown = builder.scaleOutCooldown;
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            public final java.lang.Object getCustomizedMetricSpecification() {
                return this.customizedMetricSpecification;
            }

            @Override
            public final java.lang.Object getDisableScaleIn() {
                return this.disableScaleIn;
            }

            @Override
            public final java.lang.Object getPredefinedMetricSpecification() {
                return this.predefinedMetricSpecification;
            }

            @Override
            public final java.lang.Number getScaleInCooldown() {
                return this.scaleInCooldown;
            }

            @Override
            public final java.lang.Number getScaleOutCooldown() {
                return this.scaleOutCooldown;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));
                if (this.getCustomizedMetricSpecification() != null) {
                    data.set("customizedMetricSpecification", om.valueToTree(this.getCustomizedMetricSpecification()));
                }
                if (this.getDisableScaleIn() != null) {
                    data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
                }
                if (this.getPredefinedMetricSpecification() != null) {
                    data.set("predefinedMetricSpecification", om.valueToTree(this.getPredefinedMetricSpecification()));
                }
                if (this.getScaleInCooldown() != null) {
                    data.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
                }
                if (this.getScaleOutCooldown() != null) {
                    data.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy that = (TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (!targetValue.equals(that.targetValue)) return false;
                if (this.customizedMetricSpecification != null ? !this.customizedMetricSpecification.equals(that.customizedMetricSpecification) : that.customizedMetricSpecification != null) return false;
                if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
                if (this.predefinedMetricSpecification != null ? !this.predefinedMetricSpecification.equals(that.predefinedMetricSpecification) : that.predefinedMetricSpecification != null) return false;
                if (this.scaleInCooldown != null ? !this.scaleInCooldown.equals(that.scaleInCooldown) : that.scaleInCooldown != null) return false;
                return this.scaleOutCooldown != null ? this.scaleOutCooldown.equals(that.scaleOutCooldown) : that.scaleOutCooldown == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetValue.hashCode();
                result = 31 * result + (this.customizedMetricSpecification != null ? this.customizedMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
                result = 31 * result + (this.predefinedMetricSpecification != null ? this.predefinedMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.scaleInCooldown != null ? this.scaleInCooldown.hashCode() : 0);
                result = 31 * result + (this.scaleOutCooldown != null ? this.scaleOutCooldown.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicyProps.Builder();
        }

        /**
         * The name of the scaling policy.
         * <p>
         * Updates to the name of a target tracking scaling policy are not supported, unless you also update the metric used for scaling. To change only a target tracking scaling policy's name, first delete the policy by removing the existing <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> resource from the template and updating the stack. Then, recreate the resource with the same settings and a different name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname</a>
         * @param policyName The name of the scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(final java.lang.String policyName) {
            this.props.policyName(policyName);
            return this;
        }

        /**
         * The scaling policy type.
         * <p>
         * The following policy types are supported:
         * <p>
         * <code>TargetTrackingScaling</code> —Not supported for Amazon EMR
         * <p>
         * <code>StepScaling</code> —Not supported for DynamoDB, Amazon Comprehend, Lambda, Amazon Keyspaces, Amazon MSK, Amazon ElastiCache, or Neptune.
         * <p>
         * <code>PredictiveScaling</code> —Only supported for Amazon ECS
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policytype</a>
         * @param policyType The scaling policy type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyType(final java.lang.String policyType) {
            this.props.policyType(policyType);
            return this;
        }

        /**
         * The predictive scaling policy configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration</a>
         * @param predictiveScalingPolicyConfiguration The predictive scaling policy configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predictiveScalingPolicyConfiguration(final software.amazon.awscdk.IResolvable predictiveScalingPolicyConfiguration) {
            this.props.predictiveScalingPolicyConfiguration(predictiveScalingPolicyConfiguration);
            return this;
        }
        /**
         * The predictive scaling policy configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration</a>
         * @param predictiveScalingPolicyConfiguration The predictive scaling policy configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predictiveScalingPolicyConfiguration(final software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingPolicyConfigurationProperty predictiveScalingPolicyConfiguration) {
            this.props.predictiveScalingPolicyConfiguration(predictiveScalingPolicyConfiguration);
            return this;
        }

        /**
         * The identifier of the resource associated with the scaling policy.
         * <p>
         * This string consists of the resource type and unique identifier.
         * <p>
         * <ul>
         * <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/my-cluster/my-service</code> .</li>
         * <li>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
         * <li>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code> .</li>
         * <li>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code> .</li>
         * <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code> .</li>
         * <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code> .</li>
         * <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
         * <li>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
         * <li>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://docs.aws.amazon.com/https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a> .</li>
         * <li>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code> .</li>
         * <li>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code> .</li>
         * <li>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code> . Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code> .</li>
         * <li>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code> .</li>
         * <li>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code> .</li>
         * <li>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code> .</li>
         * <li>Amazon ElastiCache cache cluster - The resource type is <code>cache-cluster</code> and the unique identifier is the cache cluster name. Example: <code>cache-cluster/mycluster</code> .</li>
         * <li>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code> .</li>
         * <li>SageMaker serverless endpoint - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
         * <li>SageMaker inference component - The resource type is <code>inference-component</code> and the unique identifier is the resource ID. Example: <code>inference-component/my-inference-component</code> .</li>
         * <li>Pool of WorkSpaces - The resource type is <code>workspacespool</code> and the unique identifier is the pool ID. Example: <code>workspacespool/wspool-123456</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-resourceid</a>
         * @param resourceId The identifier of the resource associated with the scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
         * <p>
         * <ul>
         * <li><code>ecs:service:DesiredCount</code> - The task count of an ECS service.</li>
         * <li><code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</li>
         * <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</li>
         * <li><code>appstream:fleet:DesiredCapacity</code> - The capacity of an AppStream 2.0 fleet.</li>
         * <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
         * <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
         * <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
         * <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
         * <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
         * <li><code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint variant.</li>
         * <li><code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</li>
         * <li><code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</li>
         * <li><code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</li>
         * <li><code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</li>
         * <li><code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</li>
         * <li><code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</li>
         * <li><code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</li>
         * <li><code>elasticache:cache-cluster:Nodes</code> - The number of nodes for an Amazon ElastiCache cache cluster.</li>
         * <li><code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</li>
         * <li><code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</li>
         * <li><code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</li>
         * <li><code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a SageMaker serverless endpoint.</li>
         * <li><code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for a SageMaker inference component.</li>
         * <li><code>workspaces:workspacespool:DesiredUserSessions</code> - The number of user sessions for the WorkSpaces in the pool.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalabledimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalabledimension</a>
         * @param scalableDimension The scalable dimension. This string consists of the service namespace, resource type, and scaling property. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalableDimension(final java.lang.String scalableDimension) {
            this.props.scalableDimension(scalableDimension);
            return this;
        }

        /**
         * The CloudFormation-generated ID of an Application Auto Scaling scalable target.
         * <p>
         * For more information about the ID, see the Return Value section of the <code>AWS::ApplicationAutoScaling::ScalableTarget</code> resource.
         * <p>
         * <blockquote>
         * <p>
         * You must specify either the <code>ScalingTargetId</code> property, or the <code>ResourceId</code> , <code>ScalableDimension</code> , and <code>ServiceNamespace</code> properties, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalingtargetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalingtargetid</a>
         * @param scalingTargetId The CloudFormation-generated ID of an Application Auto Scaling scalable target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingTargetId(final java.lang.String scalingTargetId) {
            this.props.scalingTargetId(scalingTargetId);
            return this;
        }

        /**
         * The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-servicenamespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-servicenamespace</a>
         * @param serviceNamespace The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNamespace(final java.lang.String serviceNamespace) {
            this.props.serviceNamespace(serviceNamespace);
            return this;
        }

        /**
         * A step scaling policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration</a>
         * @param stepScalingPolicyConfiguration A step scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepScalingPolicyConfiguration(final software.amazon.awscdk.IResolvable stepScalingPolicyConfiguration) {
            this.props.stepScalingPolicyConfiguration(stepScalingPolicyConfiguration);
            return this;
        }
        /**
         * A step scaling policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration</a>
         * @param stepScalingPolicyConfiguration A step scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepScalingPolicyConfiguration(final software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.StepScalingPolicyConfigurationProperty stepScalingPolicyConfiguration) {
            this.props.stepScalingPolicyConfiguration(stepScalingPolicyConfiguration);
            return this;
        }

        /**
         * A target tracking scaling policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration</a>
         * @param targetTrackingScalingPolicyConfiguration A target tracking scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTrackingScalingPolicyConfiguration(final software.amazon.awscdk.IResolvable targetTrackingScalingPolicyConfiguration) {
            this.props.targetTrackingScalingPolicyConfiguration(targetTrackingScalingPolicyConfiguration);
            return this;
        }
        /**
         * A target tracking scaling policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration</a>
         * @param targetTrackingScalingPolicyConfiguration A target tracking scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTrackingScalingPolicyConfiguration(final software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty targetTrackingScalingPolicyConfiguration) {
            this.props.targetTrackingScalingPolicyConfiguration(targetTrackingScalingPolicyConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy build() {
            return new software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
