package software.amazon.awscdk.services.applicationsignals;

/**
 * A structure that contains the complete grouping configuration for an account, including all defined grouping attributes and metadata about when it was last updated.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationsignals.*;
 * CfnGroupingConfiguration cfnGroupingConfiguration = CfnGroupingConfiguration.Builder.create(this, "MyCfnGroupingConfiguration")
 *         .groupingAttributeDefinitions(List.of(GroupingAttributeDefinitionProperty.builder()
 *                 .groupingName("groupingName")
 *                 .groupingSourceKeys(List.of("groupingSourceKeys"))
 *                 // the properties below are optional
 *                 .defaultGroupingValue("defaultGroupingValue")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-groupingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-groupingconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:44.984Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnGroupingConfiguration")
public class CfnGroupingConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.applicationsignals.IGroupingConfigurationRef {

    protected CfnGroupingConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGroupingConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.applicationsignals.CfnGroupingConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::ApplicationSignals::GroupingConfiguration</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGroupingConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationsignals.CfnGroupingConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The 12 digit AWS Account ID for the account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAccountId() {
        return software.amazon.jsii.Kernel.get(this, "attrAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when this grouping configuration was last updated.
     * <p>
     * When used in a raw HTTP Query API, it is formatted as epoch time in seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a GroupingConfiguration resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.applicationsignals.GroupingConfigurationReference getGroupingConfigurationRef() {
        return software.amazon.jsii.Kernel.get(this, "groupingConfigurationRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.applicationsignals.GroupingConfigurationReference.class));
    }

    /**
     * An array of grouping attribute definitions that specify how services should be grouped based on various attributes and source keys.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnGroupingConfiguration.GroupingAttributeDefinitionProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getGroupingAttributeDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "groupingAttributeDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of grouping attribute definitions that specify how services should be grouped based on various attributes and source keys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupingAttributeDefinitions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "groupingAttributeDefinitions", java.util.Objects.requireNonNull(value, "groupingAttributeDefinitions is required"));
    }

    /**
     * An array of grouping attribute definitions that specify how services should be grouped based on various attributes and source keys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupingAttributeDefinitions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.applicationsignals.CfnGroupingConfiguration.GroupingAttributeDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.applicationsignals.CfnGroupingConfiguration.GroupingAttributeDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "groupingAttributeDefinitions", java.util.Objects.requireNonNull(value, "groupingAttributeDefinitions is required"));
    }
    /**
     * A structure that defines how services should be grouped based on specific attributes.
     * <p>
     * This includes the friendly name for the grouping, the source keys to derive values from, and an optional default value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * GroupingAttributeDefinitionProperty groupingAttributeDefinitionProperty = GroupingAttributeDefinitionProperty.builder()
     *         .groupingName("groupingName")
     *         .groupingSourceKeys(List.of("groupingSourceKeys"))
     *         // the properties below are optional
     *         .defaultGroupingValue("defaultGroupingValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-groupingconfiguration-groupingattributedefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-groupingconfiguration-groupingattributedefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnGroupingConfiguration.GroupingAttributeDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(GroupingAttributeDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupingAttributeDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The friendly name for this grouping attribute, such as <code>BusinessUnit</code> or <code>Environment</code> .
         * <p>
         * This name is used to identify the grouping in the console and APIs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-groupingconfiguration-groupingattributedefinition.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinition-groupingname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-groupingconfiguration-groupingattributedefinition.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinition-groupingname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupingName();

        /**
         * An array of source keys used to derive the grouping attribute value from telemetry data, AWS tags, or other sources.
         * <p>
         * For example, ["business_unit", "team"] would look for values in those fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-groupingconfiguration-groupingattributedefinition.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinition-groupingsourcekeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-groupingconfiguration-groupingattributedefinition.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinition-groupingsourcekeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getGroupingSourceKeys();

        /**
         * The default value to use for this grouping attribute when no value can be derived from the source keys.
         * <p>
         * This ensures all services have a grouping value even if the source data is missing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-groupingconfiguration-groupingattributedefinition.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinition-defaultgroupingvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-groupingconfiguration-groupingattributedefinition.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinition-defaultgroupingvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultGroupingValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GroupingAttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GroupingAttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GroupingAttributeDefinitionProperty> {
            java.lang.String groupingName;
            java.util.List<java.lang.String> groupingSourceKeys;
            java.lang.String defaultGroupingValue;

            /**
             * Sets the value of {@link GroupingAttributeDefinitionProperty#getGroupingName}
             * @param groupingName The friendly name for this grouping attribute, such as <code>BusinessUnit</code> or <code>Environment</code> . This parameter is required.
             *                     This name is used to identify the grouping in the console and APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupingName(java.lang.String groupingName) {
                this.groupingName = groupingName;
                return this;
            }

            /**
             * Sets the value of {@link GroupingAttributeDefinitionProperty#getGroupingSourceKeys}
             * @param groupingSourceKeys An array of source keys used to derive the grouping attribute value from telemetry data, AWS tags, or other sources. This parameter is required.
             *                           For example, ["business_unit", "team"] would look for values in those fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupingSourceKeys(java.util.List<java.lang.String> groupingSourceKeys) {
                this.groupingSourceKeys = groupingSourceKeys;
                return this;
            }

            /**
             * Sets the value of {@link GroupingAttributeDefinitionProperty#getDefaultGroupingValue}
             * @param defaultGroupingValue The default value to use for this grouping attribute when no value can be derived from the source keys.
             *                             This ensures all services have a grouping value even if the source data is missing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultGroupingValue(java.lang.String defaultGroupingValue) {
                this.defaultGroupingValue = defaultGroupingValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupingAttributeDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GroupingAttributeDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GroupingAttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupingAttributeDefinitionProperty {
            private final java.lang.String groupingName;
            private final java.util.List<java.lang.String> groupingSourceKeys;
            private final java.lang.String defaultGroupingValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupingName = software.amazon.jsii.Kernel.get(this, "groupingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupingSourceKeys = software.amazon.jsii.Kernel.get(this, "groupingSourceKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.defaultGroupingValue = software.amazon.jsii.Kernel.get(this, "defaultGroupingValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupingName = java.util.Objects.requireNonNull(builder.groupingName, "groupingName is required");
                this.groupingSourceKeys = java.util.Objects.requireNonNull(builder.groupingSourceKeys, "groupingSourceKeys is required");
                this.defaultGroupingValue = builder.defaultGroupingValue;
            }

            @Override
            public final java.lang.String getGroupingName() {
                return this.groupingName;
            }

            @Override
            public final java.util.List<java.lang.String> getGroupingSourceKeys() {
                return this.groupingSourceKeys;
            }

            @Override
            public final java.lang.String getDefaultGroupingValue() {
                return this.defaultGroupingValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupingName", om.valueToTree(this.getGroupingName()));
                data.set("groupingSourceKeys", om.valueToTree(this.getGroupingSourceKeys()));
                if (this.getDefaultGroupingValue() != null) {
                    data.set("defaultGroupingValue", om.valueToTree(this.getDefaultGroupingValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnGroupingConfiguration.GroupingAttributeDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GroupingAttributeDefinitionProperty.Jsii$Proxy that = (GroupingAttributeDefinitionProperty.Jsii$Proxy) o;

                if (!groupingName.equals(that.groupingName)) return false;
                if (!groupingSourceKeys.equals(that.groupingSourceKeys)) return false;
                return this.defaultGroupingValue != null ? this.defaultGroupingValue.equals(that.defaultGroupingValue) : that.defaultGroupingValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groupingName.hashCode();
                result = 31 * result + (this.groupingSourceKeys.hashCode());
                result = 31 * result + (this.defaultGroupingValue != null ? this.defaultGroupingValue.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.applicationsignals.CfnGroupingConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationsignals.CfnGroupingConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationsignals.CfnGroupingConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationsignals.CfnGroupingConfigurationProps.Builder();
        }

        /**
         * An array of grouping attribute definitions that specify how services should be grouped based on various attributes and source keys.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-groupingconfiguration.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-groupingconfiguration.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinitions</a>
         * @param groupingAttributeDefinitions An array of grouping attribute definitions that specify how services should be grouped based on various attributes and source keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingAttributeDefinitions(final software.amazon.awscdk.IResolvable groupingAttributeDefinitions) {
            this.props.groupingAttributeDefinitions(groupingAttributeDefinitions);
            return this;
        }
        /**
         * An array of grouping attribute definitions that specify how services should be grouped based on various attributes and source keys.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-groupingconfiguration.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-groupingconfiguration.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinitions</a>
         * @param groupingAttributeDefinitions An array of grouping attribute definitions that specify how services should be grouped based on various attributes and source keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingAttributeDefinitions(final java.util.List<? extends java.lang.Object> groupingAttributeDefinitions) {
            this.props.groupingAttributeDefinitions(groupingAttributeDefinitions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.applicationsignals.CfnGroupingConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.applicationsignals.CfnGroupingConfiguration build() {
            return new software.amazon.awscdk.services.applicationsignals.CfnGroupingConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
