package software.amazon.awscdk.services.applicationsignals;

/**
 * Properties for defining a <code>CfnGroupingConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationsignals.*;
 * CfnGroupingConfigurationProps cfnGroupingConfigurationProps = CfnGroupingConfigurationProps.builder()
 *         .groupingAttributeDefinitions(List.of(GroupingAttributeDefinitionProperty.builder()
 *                 .groupingName("groupingName")
 *                 .groupingSourceKeys(List.of("groupingSourceKeys"))
 *                 // the properties below are optional
 *                 .defaultGroupingValue("defaultGroupingValue")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-groupingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-groupingconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:44.985Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnGroupingConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnGroupingConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGroupingConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An array of grouping attribute definitions that specify how services should be grouped based on various attributes and source keys.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnGroupingConfiguration.GroupingAttributeDefinitionProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-groupingconfiguration.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-groupingconfiguration.html#cfn-applicationsignals-groupingconfiguration-groupingattributedefinitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getGroupingAttributeDefinitions();

    /**
     * @return a {@link Builder} of {@link CfnGroupingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGroupingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGroupingConfigurationProps> {
        java.lang.Object groupingAttributeDefinitions;

        /**
         * Sets the value of {@link CfnGroupingConfigurationProps#getGroupingAttributeDefinitions}
         * @param groupingAttributeDefinitions An array of grouping attribute definitions that specify how services should be grouped based on various attributes and source keys. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingAttributeDefinitions(software.amazon.awscdk.IResolvable groupingAttributeDefinitions) {
            this.groupingAttributeDefinitions = groupingAttributeDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnGroupingConfigurationProps#getGroupingAttributeDefinitions}
         * @param groupingAttributeDefinitions An array of grouping attribute definitions that specify how services should be grouped based on various attributes and source keys. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingAttributeDefinitions(java.util.List<? extends java.lang.Object> groupingAttributeDefinitions) {
            this.groupingAttributeDefinitions = groupingAttributeDefinitions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGroupingConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGroupingConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGroupingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGroupingConfigurationProps {
        private final java.lang.Object groupingAttributeDefinitions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groupingAttributeDefinitions = software.amazon.jsii.Kernel.get(this, "groupingAttributeDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupingAttributeDefinitions = java.util.Objects.requireNonNull(builder.groupingAttributeDefinitions, "groupingAttributeDefinitions is required");
        }

        @Override
        public final java.lang.Object getGroupingAttributeDefinitions() {
            return this.groupingAttributeDefinitions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("groupingAttributeDefinitions", om.valueToTree(this.getGroupingAttributeDefinitions()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnGroupingConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGroupingConfigurationProps.Jsii$Proxy that = (CfnGroupingConfigurationProps.Jsii$Proxy) o;

            return this.groupingAttributeDefinitions.equals(that.groupingAttributeDefinitions);
        }

        @Override
        public final int hashCode() {
            int result = this.groupingAttributeDefinitions.hashCode();
            return result;
        }
    }
}
