package software.amazon.awscdk.services.appstream;

/**
 * Properties for defining a <code>CfnApplicationEntitlementAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appstream.*;
 * CfnApplicationEntitlementAssociationProps cfnApplicationEntitlementAssociationProps = CfnApplicationEntitlementAssociationProps.builder()
 *         .applicationIdentifier("applicationIdentifier")
 *         .entitlementName("entitlementName")
 *         .stackName("stackName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-applicationentitlementassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-applicationentitlementassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:45.288Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appstream.CfnApplicationEntitlementAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationEntitlementAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationEntitlementAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-applicationentitlementassociation.html#cfn-appstream-applicationentitlementassociation-applicationidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-applicationentitlementassociation.html#cfn-appstream-applicationentitlementassociation-applicationidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationIdentifier();

    /**
     * The name of the entitlement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-applicationentitlementassociation.html#cfn-appstream-applicationentitlementassociation-entitlementname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-applicationentitlementassociation.html#cfn-appstream-applicationentitlementassociation-entitlementname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEntitlementName();

    /**
     * The name of the stack.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-applicationentitlementassociation.html#cfn-appstream-applicationentitlementassociation-stackname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-applicationentitlementassociation.html#cfn-appstream-applicationentitlementassociation-stackname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackName();

    /**
     * @return a {@link Builder} of {@link CfnApplicationEntitlementAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationEntitlementAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationEntitlementAssociationProps> {
        java.lang.String applicationIdentifier;
        java.lang.String entitlementName;
        java.lang.String stackName;

        /**
         * Sets the value of {@link CfnApplicationEntitlementAssociationProps#getApplicationIdentifier}
         * @param applicationIdentifier The identifier of the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationIdentifier(java.lang.String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationEntitlementAssociationProps#getEntitlementName}
         * @param entitlementName The name of the entitlement. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entitlementName(java.lang.String entitlementName) {
            this.entitlementName = entitlementName;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationEntitlementAssociationProps#getStackName}
         * @param stackName The name of the stack. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationEntitlementAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationEntitlementAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationEntitlementAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationEntitlementAssociationProps {
        private final java.lang.String applicationIdentifier;
        private final java.lang.String entitlementName;
        private final java.lang.String stackName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationIdentifier = software.amazon.jsii.Kernel.get(this, "applicationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.entitlementName = software.amazon.jsii.Kernel.get(this, "entitlementName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackName = software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationIdentifier = java.util.Objects.requireNonNull(builder.applicationIdentifier, "applicationIdentifier is required");
            this.entitlementName = java.util.Objects.requireNonNull(builder.entitlementName, "entitlementName is required");
            this.stackName = java.util.Objects.requireNonNull(builder.stackName, "stackName is required");
        }

        @Override
        public final java.lang.String getApplicationIdentifier() {
            return this.applicationIdentifier;
        }

        @Override
        public final java.lang.String getEntitlementName() {
            return this.entitlementName;
        }

        @Override
        public final java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationIdentifier", om.valueToTree(this.getApplicationIdentifier()));
            data.set("entitlementName", om.valueToTree(this.getEntitlementName()));
            data.set("stackName", om.valueToTree(this.getStackName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appstream.CfnApplicationEntitlementAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationEntitlementAssociationProps.Jsii$Proxy that = (CfnApplicationEntitlementAssociationProps.Jsii$Proxy) o;

            if (!applicationIdentifier.equals(that.applicationIdentifier)) return false;
            if (!entitlementName.equals(that.entitlementName)) return false;
            return this.stackName.equals(that.stackName);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationIdentifier.hashCode();
            result = 31 * result + (this.entitlementName.hashCode());
            result = 31 * result + (this.stackName.hashCode());
            return result;
        }
    }
}
