package software.amazon.awscdk.services.appsync;

/**
 * An AppSync datasource backed by a http endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigateway.*;
 * EventApi api = EventApi.Builder.create(this, "EventApiHttp")
 *         .apiName("HttpEventApi")
 *         .build();
 * RestApi randomApi = new RestApi(this, "RandomApi");
 * Resource randomRoute = randomApi.root.addResource("random");
 * randomRoute.addMethod("GET", MockIntegration.Builder.create()
 *         .integrationResponses(List.of(IntegrationResponse.builder()
 *                 .statusCode("200")
 *                 .responseTemplates(Map.of(
 *                         "application/json", "my-random-value"))
 *                 .build()))
 *         .passthroughBehavior(PassthroughBehavior.NEVER)
 *         .requestTemplates(Map.of(
 *                 "application/json", "{ \"statusCode\": 200 }"))
 *         .build(), MethodOptions.builder()
 *         .methodResponses(List.of(MethodResponse.builder().statusCode("200").build()))
 *         .build());
 * AppSyncHttpDataSource dataSource = api.addHttpDataSource("httpsource", String.format("https://%s.execute-api.%s.amazonaws.com", randomApi.getRestApiId(), this.region));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:45.365Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncHttpDataSource")
public class AppSyncHttpDataSource extends software.amazon.awscdk.services.appsync.AppSyncBackedDataSource {

    protected AppSyncHttpDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppSyncHttpDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AppSyncHttpDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncHttpDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.AppSyncHttpDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.AppSyncHttpDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.AppSyncHttpDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.AppSyncHttpDataSourceProps.Builder();
        }

        /**
         * The API to attach this data source to.
         * <p>
         * @return {@code this}
         * @param api The API to attach this data source to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(final software.amazon.awscdk.services.appsync.IApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * The description of the data source.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param description The description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the data source.
         * <p>
         * The only allowed pattern is: {[_A-Za-z][_0-9A-Za-z]*}.
         * Any invalid characters will be automatically removed.
         * <p>
         * Default: - id of data source
         * <p>
         * @return {@code this}
         * @param name The name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The IAM service role to be assumed by AppSync to interact with the data source.
         * <p>
         * Default: -  Create a new role
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM service role to be assumed by AppSync to interact with the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * The http endpoint.
         * <p>
         * @return {@code this}
         * @param endpoint The http endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(final java.lang.String endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        /**
         * The authorization config in case the HTTP endpoint requires authorization.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param authorizationConfig The authorization config in case the HTTP endpoint requires authorization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationConfig(final software.amazon.awscdk.services.appsync.AppSyncAwsIamConfig authorizationConfig) {
            this.props.authorizationConfig(authorizationConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.AppSyncHttpDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.AppSyncHttpDataSource build() {
            return new software.amazon.awscdk.services.appsync.AppSyncHttpDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
