package software.amazon.awscdk.services.appsync;

/**
 * The Schema for a GraphQL Api.
 * <p>
 * If no options are configured, schema will be generated
 * code-first.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.route53.*;
 * // hosted zone and route53 features
 * String hostedZoneId;
 * String zoneName = "example.com";
 * String myDomainName = "api.example.com";
 * Certificate certificate = Certificate.Builder.create(this, "cert").domainName(myDomainName).build();
 * SchemaFile schema = SchemaFile.Builder.create().filePath("mySchemaFile").build();
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("myApi")
 *         .definition(Definition.fromSchema(schema))
 *         .domainName(DomainOptions.builder()
 *                 .certificate(certificate)
 *                 .domainName(myDomainName)
 *                 .build())
 *         .build();
 * // hosted zone for adding appsync domain
 * IHostedZone zone = HostedZone.fromHostedZoneAttributes(this, "HostedZone", HostedZoneAttributes.builder()
 *         .hostedZoneId(hostedZoneId)
 *         .zoneName(zoneName)
 *         .build());
 * // create a cname to the appsync domain. will map to something like xxxx.cloudfront.net
 * // create a cname to the appsync domain. will map to something like xxxx.cloudfront.net
 * CnameRecord.Builder.create(this, "CnameApiRecord")
 *         .recordName("api")
 *         .zone(zone)
 *         .domainName(api.getAppSyncDomainName())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:45.541Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.SchemaFile")
public class SchemaFile extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.appsync.ISchema {

    protected SchemaFile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SchemaFile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SchemaFile(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.SchemaProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Generate a Schema from file.
     * <p>
     * @return <code>SchemaAsset</code> with immutable schema defintion
     * @param filePath the file path of the schema file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.SchemaFile fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String filePath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.SchemaFile.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.SchemaFile.class), new Object[] { java.util.Objects.requireNonNull(filePath, "filePath is required") });
    }

    /**
     * Called when the GraphQL Api is initialized to allow this object to bind to the stack.
     * <p>
     * @param api The binding GraphQL Api. This parameter is required.
     * @param _options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ISchemaConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi api, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.SchemaBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ISchemaConfig.class), new Object[] { java.util.Objects.requireNonNull(api, "api is required"), _options });
    }

    /**
     * Called when the GraphQL Api is initialized to allow this object to bind to the stack.
     * <p>
     * @param api The binding GraphQL Api. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ISchemaConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi api) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ISchemaConfig.class), new Object[] { java.util.Objects.requireNonNull(api, "api is required") });
    }

    /**
     * The definition for this schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDefinition() {
        return software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The definition for this schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.SchemaFile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.SchemaFile> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.appsync.SchemaProps.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.appsync.SchemaProps.Builder();
        }

        /**
         * The file path for the schema.
         * <p>
         * When this option is
         * configured, then the schema will be generated from an
         * existing file from disk.
         * <p>
         * @return {@code this}
         * @param filePath The file path for the schema. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filePath(final java.lang.String filePath) {
            this.options.filePath(filePath);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.SchemaFile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.SchemaFile build() {
            return new software.amazon.awscdk.services.appsync.SchemaFile(
                this.options.build()
            );
        }
    }
}
