package software.amazon.awscdk.services.appsync;

/**
 * Configuration of source API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * GraphqlApi graphqlApi;
 * SourceApi sourceApi = SourceApi.builder()
 *         .sourceApi(graphqlApi)
 *         // the properties below are optional
 *         .description("description")
 *         .mergeType(MergeType.MANUAL_MERGE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:45.542Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.SourceApi")
@software.amazon.jsii.Jsii.Proxy(SourceApi.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SourceApi extends software.amazon.jsii.JsiiSerializable {

    /**
     * Source API that is associated with the merged API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi getSourceApi();

    /**
     * Description of the Source API asssociation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Merging option used to associate the source API to the Merged API.
     * <p>
     * Default: - Auto merge. The merge is triggered automatically when the source API has changed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.MergeType getMergeType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SourceApi}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SourceApi}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SourceApi> {
        software.amazon.awscdk.services.appsync.IGraphqlApi sourceApi;
        java.lang.String description;
        software.amazon.awscdk.services.appsync.MergeType mergeType;

        /**
         * Sets the value of {@link SourceApi#getSourceApi}
         * @param sourceApi Source API that is associated with the merged API. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceApi(software.amazon.awscdk.services.appsync.IGraphqlApi sourceApi) {
            this.sourceApi = sourceApi;
            return this;
        }

        /**
         * Sets the value of {@link SourceApi#getDescription}
         * @param description Description of the Source API asssociation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link SourceApi#getMergeType}
         * @param mergeType Merging option used to associate the source API to the Merged API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergeType(software.amazon.awscdk.services.appsync.MergeType mergeType) {
            this.mergeType = mergeType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceApi}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SourceApi build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SourceApi}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceApi {
        private final software.amazon.awscdk.services.appsync.IGraphqlApi sourceApi;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.appsync.MergeType mergeType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceApi = software.amazon.jsii.Kernel.get(this, "sourceApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mergeType = software.amazon.jsii.Kernel.get(this, "mergeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MergeType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceApi = java.util.Objects.requireNonNull(builder.sourceApi, "sourceApi is required");
            this.description = builder.description;
            this.mergeType = builder.mergeType;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.IGraphqlApi getSourceApi() {
            return this.sourceApi;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.MergeType getMergeType() {
            return this.mergeType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceApi", om.valueToTree(this.getSourceApi()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMergeType() != null) {
                data.set("mergeType", om.valueToTree(this.getMergeType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.SourceApi"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SourceApi.Jsii$Proxy that = (SourceApi.Jsii$Proxy) o;

            if (!sourceApi.equals(that.sourceApi)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.mergeType != null ? this.mergeType.equals(that.mergeType) : that.mergeType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sourceApi.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.mergeType != null ? this.mergeType.hashCode() : 0);
            return result;
        }
    }
}
